/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.sei.BodyBuilder;
import com.sun.xml.ws.client.sei.MessageFiller;
import com.sun.xml.ws.client.sei.MethodHandler;
import com.sun.xml.ws.client.sei.ResponseBuilder;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.client.sei.ValueGetter;
import com.sun.xml.ws.client.sei.ValueSetter;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.CheckedExceptionImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.WrapperParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

final class SyncMethodHandler
extends MethodHandler {
    private final BodyBuilder bodyBuilder;
    private final MessageFiller[] inFillers;
    private final String soapAction;
    private final boolean isOneWay;
    private final JavaMethodImpl javaMethod;
    final ValueGetter[] valueGetters;
    private final ResponseBuilder responseBuilder;
    private final Map<QName, CheckedExceptionImpl> checkedExceptions = new HashMap<QName, CheckedExceptionImpl>();

    public SyncMethodHandler(SEIStub owner, JavaMethodImpl method) {
        super(owner);
        for (CheckedExceptionImpl ce : method.getCheckedExceptions()) {
            this.checkedExceptions.put(ce.getBridge().getTypeReference().tagName, ce);
        }
        this.soapAction = method.getInputAction() != null && !method.getBinding().getSOAPAction().equals("") ? method.getInputAction() : method.getBinding().getSOAPAction();
        this.javaMethod = method;
        List<ParameterImpl> rp = method.getRequestParameters();
        BodyBuilder bodyBuilder = null;
        ArrayList<MessageFiller> fillers = new ArrayList<MessageFiller>();
        this.valueGetters = new ValueGetter[rp.size()];
        block21: for (ParameterImpl param : rp) {
            ValueGetter getter = ValueGetter.get(param);
            switch (param.getInBinding().kind) {
                case BODY: {
                    if (param.isWrapperStyle()) {
                        if (param.getParent().getBinding().isRpcLit()) {
                            bodyBuilder = new BodyBuilder.RpcLit((WrapperParameter)param, owner.soapVersion);
                            continue block21;
                        }
                        bodyBuilder = new BodyBuilder.DocLit((WrapperParameter)param, owner.soapVersion);
                        continue block21;
                    }
                    bodyBuilder = new BodyBuilder.Bare(param, owner.soapVersion);
                    continue block21;
                }
                case HEADER: {
                    fillers.add(new MessageFiller.Header(param.getIndex(), param.getBridge(), getter));
                    continue block21;
                }
                case ATTACHMENT: {
                    fillers.add(MessageFiller.AttachmentFiller.createAttachmentFiller(param, getter));
                    continue block21;
                }
                case UNBOUND: {
                    continue block21;
                }
            }
            throw new AssertionError();
        }
        if (bodyBuilder == null) {
            switch (owner.soapVersion) {
                case SOAP_11: {
                    bodyBuilder = BodyBuilder.EMPTY_SOAP11;
                    break;
                }
                case SOAP_12: {
                    bodyBuilder = BodyBuilder.EMPTY_SOAP12;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.bodyBuilder = bodyBuilder;
        this.inFillers = fillers.toArray(new MessageFiller[fillers.size()]);
        rp = method.getResponseParameters();
        ArrayList<ResponseBuilder> builders = new ArrayList<ResponseBuilder>();
        block22: for (ParameterImpl param : rp) {
            ValueSetter setter = ValueSetter.get(param);
            switch (param.getOutBinding().kind) {
                case BODY: {
                    if (param.isWrapperStyle()) {
                        if (param.getParent().getBinding().isRpcLit()) {
                            builders.add(new ResponseBuilder.RpcLit((WrapperParameter)param));
                            continue block22;
                        }
                        builders.add(new ResponseBuilder.DocLit((WrapperParameter)param));
                        continue block22;
                    }
                    builders.add(new ResponseBuilder.Body(param.getBridge(), setter));
                    continue block22;
                }
                case HEADER: {
                    builders.add(new ResponseBuilder.Header(owner.soapVersion, param, setter));
                    continue block22;
                }
                case ATTACHMENT: {
                    builders.add(ResponseBuilder.AttachmentBuilder.createAttachmentBuilder(param, setter));
                    continue block22;
                }
                case UNBOUND: {
                    builders.add(new ResponseBuilder.NullSetter(setter, ResponseBuilder.getVMUninitializedValue(param.getTypeReference().type)));
                    continue block22;
                }
            }
            throw new AssertionError();
        }
        switch (builders.size()) {
            case 0: {
                this.responseBuilder = ResponseBuilder.NONE;
                break;
            }
            case 1: {
                this.responseBuilder = (ResponseBuilder)builders.get(0);
                break;
            }
            default: {
                this.responseBuilder = new ResponseBuilder.Composite(builders);
            }
        }
        this.isOneWay = method.getMEP().isOneWay();
    }

    public JavaMethodImpl getJavaMethod() {
        return this.javaMethod;
    }

    public Object invoke(Object proxy, Object[] args) throws Throwable {
        return this.invoke(proxy, args, this.owner.requestContext, this.owner);
    }

    public Object invoke(Object proxy, Object[] args, RequestContext rc, ResponseContextReceiver receiver) throws Throwable {
        Packet req = new Packet(this.createRequestMessage(args));
        req.soapAction = this.soapAction;
        req.expectReply = !this.isOneWay;
        req.getMessage().assertOneWay(this.isOneWay);
        Packet reply = this.owner.doProcess(req, rc, receiver);
        Message msg = reply.getMessage();
        if (msg == null) {
            return null;
        }
        try {
            if (msg.isFault()) {
                SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                throw faultBuilder.createException(this.checkedExceptions);
            }
            return this.responseBuilder.readResponse(msg, args);
        }
        catch (JAXBException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
        catch (XMLStreamException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
    }

    private Message createRequestMessage(Object[] args) {
        Message msg = this.bodyBuilder.createMessage(args);
        for (MessageFiller filler : this.inFillers) {
            filler.fillIn(args, msg);
        }
        return msg;
    }
}

