/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.ContainerProxyFactory;
import org.jboss.aop.proxy.container.Delegate;

public class GeneratedAOPProxyFactory
implements AOPProxyFactory {
    public Object createAdvisedProxy(AOPProxyFactoryParameters params) {
        return this.createAdvisedProxy(params.isObjectAsSuperClass(), params.getProxiedClass(), params.getInterfaces(), params.getSimpleMetaData(), params.getTarget());
    }

    private Object createAdvisedProxy(boolean objectAsSuper, Class proxiedClass, Class[] interfaces, SimpleMetaData metadata, Object target) {
        AspectManager manager = AspectManager.instance();
        if (target != null) {
            if (proxiedClass != null) {
                if (!proxiedClass.isAssignableFrom(target.getClass())) {
                    throw new RuntimeException("Specified class type " + proxiedClass.getName() + " and target " + target.getClass().getName() + " are not compatible");
                }
            } else {
                proxiedClass = target.getClass();
            }
        } else if (proxiedClass == null) {
            proxiedClass = Object.class;
        }
        return this.getProxy(objectAsSuper, manager, proxiedClass, interfaces, metadata, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getProxy(boolean objectAsSuper, AspectManager manager, Class proxiedClass, Class[] interfaces, SimpleMetaData metadata, Object target) {
        try {
            ContainerCache cache = null;
            Class proxyClass = null;
            boolean isAdvised = Advised.class.isAssignableFrom(proxiedClass);
            if (target instanceof Untransformable) {
                return target;
            }
            Object object = ContainerCache.mapLock;
            synchronized (object) {
                cache = ContainerCache.initialise(manager, proxiedClass, interfaces);
                if (!cache.hasAspects() && !cache.requiresInstanceAdvisor()) {
                    return target;
                }
                proxyClass = this.generateProxy(objectAsSuper, cache);
            }
            return this.instantiateAndConfigureProxy(proxyClass, cache, metadata, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class generateProxy(boolean objectAsSuper, ContainerCache cache) throws Exception {
        Class proxyClass = ContainerProxyFactory.getProxyClass(objectAsSuper, cache.getKey(), cache.getAdvisor());
        return proxyClass;
    }

    private Object instantiateAndConfigureProxy(Class proxyClass, ContainerCache cache, SimpleMetaData metadata, Object target) throws Exception {
        AspectManaged proxy = (AspectManaged)proxyClass.newInstance();
        proxy.setAdvisor(cache.getClassAdvisor());
        if (cache.getInstanceContainer() != null) {
            proxy.setInstanceAdvisor(cache.getInstanceContainer());
        }
        if (metadata != null) {
            proxy.setMetadata(metadata);
        }
        if (target != null) {
            ((Delegate)((Object)proxy)).setDelegate(target);
        } else {
            ((Delegate)((Object)proxy)).setDelegate(new Object());
        }
        return proxy;
    }
}

