/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.util.NestedRuntimeException;

public class TransactionLocalDelegateImpl
implements TransactionLocalDelegate {
    private Map transactionMap = Collections.synchronizedMap(new WeakHashMap());

    public boolean containsValue(TransactionLocal transactionLocal, Transaction transaction) {
        Map map = this.getMap(transaction, false);
        return map != null && map.containsKey(transactionLocal);
    }

    public Object getValue(TransactionLocal transactionLocal, Transaction transaction) {
        Map map = this.getMap(transaction, false);
        return map == null ? null : map.get(transactionLocal);
    }

    public void storeValue(TransactionLocal transactionLocal, Transaction transaction, Object value) {
        int status;
        try {
            status = transaction.getStatus();
        }
        catch (SystemException se) {
            throw new NestedRuntimeException((Throwable)se);
        }
        if (status == 0) {
            Map map = this.getMap(transaction, true);
            map.put(transactionLocal, value);
        }
    }

    public void lock(TransactionLocal transactionLocal, Transaction transaction) throws InterruptedException {
        int status;
        try {
            status = transaction.getStatus();
        }
        catch (SystemException se) {
            throw new NestedRuntimeException((Throwable)se);
        }
        if (status != 0) {
            throw new IllegalStateException("Transaction not active");
        }
        TransactionLocalSynchronization synchronization = this.getSynchronization(transaction, true);
        synchronization.lock(transactionLocal);
    }

    public void unlock(TransactionLocal transactionLocal, Transaction transaction) {
        TransactionLocalSynchronization synchronization = this.getSynchronization(transaction, true);
        if (synchronization != null) {
            synchronization.unlock(transactionLocal);
        }
    }

    private Map getMap(Transaction transaction, boolean create) {
        TransactionLocalSynchronization synchronization = this.getSynchronization(transaction, create);
        return synchronization == null ? null : synchronization.getMap();
    }

    private TransactionLocalSynchronization getSynchronization(Transaction transaction, boolean create) {
        TransactionLocalSynchronization synchronization;
        WeakReference reference = (WeakReference)this.transactionMap.get(transaction);
        if (reference != null && (synchronization = (TransactionLocalSynchronization)reference.get()) != null) {
            return synchronization;
        }
        if (!create) {
            return null;
        }
        synchronization = new TransactionLocalSynchronization();
        try {
            transaction.registerSynchronization((Synchronization)synchronization);
        }
        catch (Exception ex) {
            throw new NestedRuntimeException((Throwable)ex);
        }
        this.transactionMap.put(transaction, new WeakReference<TransactionLocalSynchronization>(synchronization));
        return synchronization;
    }

    private static class TransactionLocalSynchronization
    implements Synchronization {
        private Map map = Collections.synchronizedMap(new HashMap());
        private Thread lockingThread;
        private int lockCount;
        private byte[] lock = new byte[0];

        private TransactionLocalSynchronization() {
        }

        public Map getMap() {
            return this.map;
        }

        public void afterCompletion(int result) {
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(TransactionLocal transactionLocal) {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                Thread currentThread = Thread.currentThread();
                if (currentThread == this.lockingThread) {
                    ++this.lockCount;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                while (this.lockingThread != null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                this.lockingThread = currentThread;
                ++this.lockCount;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(TransactionLocal transactionLocal) {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                Thread currentThread = Thread.currentThread();
                if (currentThread != this.lockingThread) {
                    throw new IllegalStateException("Unlock called from wrong thread.  Locking thread: " + this.lockingThread + ", current thread: " + currentThread);
                }
                if (--this.lockCount == 0) {
                    this.lockingThread = null;
                    this.lock.notify();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

