/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jta;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;

public class AppServerJDBCXARecovery
implements XAResourceRecovery {
    private XAConnection _connection;
    private XADataSource _dataSource;
    private LocalConnectionEventListener _connectionEventListener;
    private boolean _hasMoreResources;
    private String _dataSourceId;
    private Logger log = Logger.getLogger((Class)AppServerJDBCXARecovery.class);
    static /* synthetic */ Class class$java$lang$String;

    public AppServerJDBCXARecovery() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"AppServerJDBCXARecovery<init>");
        }
        this._hasMoreResources = false;
        this._connectionEventListener = new LocalConnectionEventListener();
    }

    public boolean initialise(String parameter) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AppServerJDBCXARecovery.initialise(" + parameter + ")"));
        }
        if (parameter == null) {
            return false;
        }
        this._dataSourceId = parameter;
        return true;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        this.createConnection();
        return this._connection.getXAResource();
    }

    public boolean hasMoreResources() {
        if (this._dataSource == null) {
            try {
                this.createDataSource();
            }
            catch (SQLException sqlException) {
                return false;
            }
        }
        if (this._dataSource != null) {
            this._hasMoreResources = !this._hasMoreResources;
            return this._hasMoreResources;
        }
        return false;
    }

    private final void createDataSource() throws SQLException {
        block5: {
            try {
                if (this._dataSource != null) break block5;
                InitialContext context = new InitialContext();
                MBeanServerConnection server = (MBeanServerConnection)context.lookup("jmx/invoker/RMIAdaptor");
                ObjectName objectName = new ObjectName("jboss.jca:name=" + this._dataSourceId + ",service=ManagedConnectionFactory");
                String className = (String)server.invoke(objectName, "getManagedConnectionFactoryAttribute", new Object[]{"XADataSourceClass"}, new String[]{"java.lang.String"});
                this.log.debug((Object)("AppServerJDBCXARecovery datasource classname = " + className));
                String properties = (String)server.invoke(objectName, "getManagedConnectionFactoryAttribute", new Object[]{"XADataSourceProperties"}, new String[]{"java.lang.String"});
                try {
                    this._dataSource = this.getXADataSource(className, properties);
                }
                catch (Exception e) {
                    this._dataSource = null;
                    this.log.error((Object)("AppServerJDBCXARecovery.createDataSource got exception during getXADataSource call: " + e.toString()), (Throwable)e);
                    throw new SQLException(e.toString());
                }
            }
            catch (SQLException ex) {
                this.log.error((Object)("AppServerJDBCXARecovery.createDataSource got exception " + ex.toString()), (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                this.log.error((Object)("AppServerJDBCXARecovery.createDataSource got exception " + e.toString()), (Throwable)e);
                throw new SQLException(e.toString());
            }
        }
    }

    private final void createConnection() throws SQLException {
        try {
            if (this._dataSource == null) {
                this.createDataSource();
            }
            if (this._connection == null) {
                this._connection = this._dataSource.getXAConnection();
                this._connection.addConnectionEventListener(this._connectionEventListener);
            }
        }
        catch (SQLException ex) {
            this.log.error((Object)("AppServerJDBCXARecovery.createConnection got exception " + ex.toString()), (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            this.log.error((Object)("AppServerJDBCXARecovery.createConnection got exception " + e.toString()), (Throwable)e);
            throw new SQLException(e.toString());
        }
    }

    private XADataSource getXADataSource(String xaDataSourceClassname, String propertiesString) throws Exception {
        propertiesString = propertiesString.replaceAll("\\\\", "\\\\\\\\");
        Properties properties = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(propertiesString.getBytes());
        properties.load(is);
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassname);
        XADataSource xads = (XADataSource)clazz.newInstance();
        Class[] NOCLASSES = new Class[]{};
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = properties.getProperty(name);
            Class<?> type = null;
            try {
                Method getter = clazz.getMethod("get" + name, NOCLASSES);
                type = getter.getReturnType();
            }
            catch (NoSuchMethodException e) {
                type = class$java$lang$String == null ? AppServerJDBCXARecovery.class$("java.lang.String") : class$java$lang$String;
                try {
                    Method getter = clazz.getMethod("is" + name, NOCLASSES);
                    type = getter.getReturnType();
                }
                catch (NoSuchMethodException nsme) {
                    type = class$java$lang$String == null ? AppServerJDBCXARecovery.class$("java.lang.String") : class$java$lang$String;
                }
            }
            Method setter = clazz.getMethod("set" + name, type);
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            editor.setAsText(value);
            setter.invoke((Object)xads, editor.getValue());
        }
        return xads;
    }

    private class LocalConnectionEventListener
    implements ConnectionEventListener {
        private LocalConnectionEventListener() {
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            AppServerJDBCXARecovery.this._connection.removeConnectionEventListener(AppServerJDBCXARecovery.this._connectionEventListener);
            AppServerJDBCXARecovery.this._connection = null;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            AppServerJDBCXARecovery.this._connection.removeConnectionEventListener(AppServerJDBCXARecovery.this._connectionEventListener);
            AppServerJDBCXARecovery.this._connection = null;
        }
    }
}

