/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public abstract class ScriptedTask
extends Task
implements Cloneable {
    protected final TaskLogger log = new TaskLogger(this);
    protected final Map beans = new HashMap();
    protected BSFManager manager;
    protected String language = "jpython";

    public void setLanguage(String language) {
        this.language = language;
    }

    protected void validate() throws BuildException {
        if (this.language == null) {
            throw new MissingAttributeException("language", this);
        }
    }

    protected BSFManager getManager() throws BSFException {
        if (this.manager == null) {
            this.manager = new BSFManager();
            this.log.debug("created bsf manager: " + this.manager);
        }
        return this.manager;
    }

    protected BSFEngine createEngine() throws BSFException {
        BSFManager manager = this.getManager();
        this.addBeans(this.project.getProperties());
        this.addBeans(this.project.getUserProperties());
        this.addBeans(this.project.getTargets());
        this.addBeans(this.project.getReferences());
        this.beans.put("project", this.project);
        Iterator iter = this.beans.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = this.beans.get(key);
            manager.declareBean(key, value, value.getClass());
            this.log.debug("declared bean: " + key + " = " + value);
        }
        BSFEngine engine = manager.loadScriptingEngine(this.language);
        this.log.debug("created engine: " + engine);
        return engine;
    }

    protected String getSourceName() {
        return "<SCRIPT>";
    }

    protected boolean isValidIdentifier(String value) {
        boolean valid = value.length() > 0 && Character.isJavaIdentifierStart(value.charAt(0));
        int i = 1;
        while (valid && i < value.length()) {
            valid = Character.isJavaIdentifierPart(value.charAt(i));
            ++i;
        }
        return valid;
    }

    protected void addBeans(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (this.isValidIdentifier(key)) {
                this.beans.put(key, map.get(key));
                continue;
            }
            this.log.debug("not a valid identifier: " + key);
        }
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            BSFEngine engine = this.createEngine();
            this.execute(engine);
        }
        catch (BSFException e) {
            Throwable nested = e.getTargetException();
            if (nested != null) {
                if (nested instanceof BuildException) {
                    throw (BuildException)nested;
                }
                nested = e;
            }
            throw new BuildException(nested);
        }
    }

    protected abstract void execute(BSFEngine var1) throws BSFException, BuildException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

