/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.CallTarget;
import org.jboss.tools.buildmagic.task.MissingElementException;
import org.jboss.tools.buildmagic.task.Script;
import org.jboss.tools.buildmagic.task.ScriptedTask;

public abstract class ScriptedContainerTask
extends ScriptedTask {
    protected List tasks = new LinkedList();

    public void setTarget(String target) {
        CallTarget call = this.createCall();
        call.setTarget(target);
        this.tasks.add(call);
    }

    public void setScript(String script) {
        Script task = this.createScript();
        task.addText(script);
        this.tasks.add(task);
    }

    public CallTarget createCall() {
        this.log.verbose("creating nested <call> task");
        CallTarget task = (CallTarget)this.project.createTask("call");
        this.tasks.add(task);
        this.log.verbose("tasks: " + this.tasks);
        return task;
    }

    public Script createScript() {
        this.log.verbose("creating nested <script> task");
        Script task = (Script)this.project.createTask("script");
        this.tasks.add(task);
        this.log.verbose("tasks: " + this.tasks);
        return task;
    }

    protected void validate() throws BuildException {
        super.validate();
        if (this.tasks.size() == 0) {
            throw new MissingElementException("call' or 'script", this);
        }
    }

    protected void executeTasks() throws BuildException {
        Iterator iter = this.tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            this.log.debug("executing sub-task: " + task);
            task.execute();
        }
    }
}

