/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.TimeoutException;

public class CondVar {
    Object cond;
    final String name;
    final Object lock;

    public CondVar(String name, Object cond) {
        this.name = name;
        this.cond = cond;
        this.lock = this;
    }

    public CondVar(String name, Object cond, Object lock) {
        this.name = name;
        this.cond = cond;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object object = this.lock;
        synchronized (object) {
            return this.cond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object result) {
        Object object = this.lock;
        synchronized (object) {
            this.cond = result;
            this.lock.notifyAll();
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void waitUntilWithTimeout(Object result, long timeout) throws TimeoutException {
        this._waitUntilWithTimeout(result, timeout);
    }

    public void waitUntil(Object result, long timeout) {
        try {
            this._waitUntilWithTimeout(result, timeout);
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    public void waitUntil(Object result) {
        try {
            this.waitUntilWithTimeout(result, 0L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _waitUntilWithTimeout(Object result, long timeout) throws TimeoutException {
        long time_to_wait = timeout;
        boolean timeout_occurred = false;
        Object object = this.lock;
        synchronized (object) {
            if (result == null && this.cond == null) {
                return;
            }
            long start = System.currentTimeMillis();
            while (!this.match(result, this.cond)) {
                if (timeout <= 0L) {
                    this.doWait();
                    continue;
                }
                if (time_to_wait <= 0L) {
                    timeout_occurred = true;
                    break;
                }
                this.doWait(time_to_wait);
                time_to_wait = timeout - (System.currentTimeMillis() - start);
            }
            if (timeout_occurred) {
                throw new TimeoutException();
            }
        }
    }

    void doWait() {
        try {
            this.lock.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void doWait(long timeout) {
        try {
            this.lock.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean match(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2.equals(o1);
    }

    public String toString() {
        return this.name + "=" + this.cond;
    }
}

