/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannelFactory;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.mux.MuxChannel;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class MultiplexerViewTest
extends ChannelTestBase {
    private Channel c1;
    private Channel c2;
    private Channel c3;
    private Channel c4;
    static final BlockEvent BLOCK_EVENT = new BlockEvent();
    static final UnblockEvent UNBLOCK_EVENT = new UnblockEvent();
    JChannelFactory factory;
    JChannelFactory factory2;

    public MultiplexerViewTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.factory = new JChannelFactory();
        this.factory.setMultiplexerConfig(MUX_CHANNEL_CONFIG);
        this.factory2 = new JChannelFactory();
        this.factory2.setMultiplexerConfig(MUX_CHANNEL_CONFIG);
    }

    public void tearDown() throws Exception {
        Util.sleep(1000L);
        if (this.c2 != null) {
            this.c2.close();
        }
        if (this.c1 != null) {
            this.c1.close();
        }
        this.factory.destroy();
        this.factory2.destroy();
        super.tearDown();
    }

    public void testBasicLifeCycle() throws Exception {
        this.c1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        System.out.println("c1: " + this.c1);
        MultiplexerViewTest.assertTrue((boolean)this.c1.isOpen());
        MultiplexerViewTest.assertFalse((boolean)this.c1.isConnected());
        View v = this.c1.getView();
        MultiplexerViewTest.assertNull((Object)v);
        ((MuxChannel)this.c1).getClusterView();
        MultiplexerViewTest.assertNull((Object)v);
        Address local_addr = this.c1.getLocalAddress();
        MultiplexerViewTest.assertNull((Object)local_addr);
        this.c1.connect("bla");
        MultiplexerViewTest.assertTrue((boolean)this.c1.isConnected());
        local_addr = this.c1.getLocalAddress();
        MultiplexerViewTest.assertNotNull((Object)local_addr);
        v = this.c1.getView();
        MultiplexerViewTest.assertNotNull((Object)v);
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        v = ((MuxChannel)this.c1).getClusterView();
        MultiplexerViewTest.assertNotNull((Object)v);
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        this.c1.disconnect();
        MultiplexerViewTest.assertFalse((boolean)this.c1.isConnected());
        MultiplexerViewTest.assertTrue((boolean)this.c1.isOpen());
        local_addr = this.c1.getLocalAddress();
        MultiplexerViewTest.assertNull((Object)local_addr);
        this.c1.close();
        MultiplexerViewTest.assertFalse((boolean)this.c1.isOpen());
    }

    public void testBlockPush() throws Exception {
        this.c1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c1.setOpt(0, Boolean.TRUE);
        MyReceiver receiver = new MyReceiver();
        this.c1.setReceiver(receiver);
        this.c1.connect("bla");
        this.c2 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c2.setOpt(0, Boolean.TRUE);
        MyReceiver receiver2 = new MyReceiver();
        this.c2.setReceiver(receiver2);
        this.c2.connect("bla");
        Util.sleep(1000L);
        List events = receiver.getEvents();
        int num_events = events.size();
        System.out.println("-- receiver: " + events);
        MultiplexerViewTest.assertEquals((String)"we should have a BLOCK, UNBLOCK, BLOCK, UNBLOCK,BLOCK, UNBLOCK, BLOCK, UNBLOCK sequence", (int)8, (int)num_events);
        Object evt = events.remove(0);
        MultiplexerViewTest.assertTrue((String)("evt=" + evt), (boolean)(evt instanceof BlockEvent));
        evt = events.remove(0);
        MultiplexerViewTest.assertTrue((String)("evt=" + evt), (boolean)(evt instanceof UnblockEvent));
        evt = events.remove(0);
        MultiplexerViewTest.assertTrue((String)("evt=" + evt), (boolean)(evt instanceof BlockEvent));
        evt = events.remove(0);
        MultiplexerViewTest.assertTrue((String)("evt=" + evt), (boolean)(evt instanceof UnblockEvent));
        events = receiver2.getEvents();
        num_events = events.size();
        System.out.println("-- receiver2: " + events);
        evt = events.remove(0);
        MultiplexerViewTest.assertTrue((boolean)(evt instanceof BlockEvent));
        evt = events.remove(0);
        MultiplexerViewTest.assertTrue((boolean)(evt instanceof UnblockEvent));
    }

    public void testBlockPush2() throws Exception {
        this.c1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c1.setOpt(0, Boolean.TRUE);
        MyReceiver receiver = new MyReceiver();
        this.c1.setReceiver(receiver);
        this.c1.connect("bla");
        this.c2 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-2");
        this.c2.setOpt(0, Boolean.TRUE);
        MyReceiver receiver2 = new MyReceiver();
        this.c2.setReceiver(receiver2);
        this.c2.connect("bla");
        this.c3 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-3");
        this.c3.setOpt(0, Boolean.TRUE);
        MyReceiver receiver3 = new MyReceiver();
        this.c3.setReceiver(receiver3);
        this.c3.connect("bla");
        this.c4 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-3");
        this.c4.setOpt(0, Boolean.TRUE);
        MyReceiver receiver4 = new MyReceiver();
        this.c4.setReceiver(receiver4);
        this.c4.connect("bla");
        Util.sleep(1000L);
        List events = receiver.getEvents();
        this.checkBlockAndUnBlock(events, "receiver", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        events = receiver2.getEvents();
        this.checkBlockAndUnBlock(events, "receiver2", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        events = receiver3.getEvents();
        this.checkBlockAndUnBlock(events, "receiver3", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        events = receiver4.getEvents();
        System.out.println("-- [receiver4] events: " + events);
        this.checkBlockAndUnBlock(events, "receiver4", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        receiver.clear();
        receiver2.clear();
        receiver3.clear();
        receiver4.clear();
        System.out.println("-- Closing c4");
        this.c4.close();
        Util.sleep(5000L);
        events = receiver.getEvents();
        this.checkBlockAndUnBlock(events, "receiver", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        events = receiver2.getEvents();
        this.checkBlockAndUnBlock(events, "receiver2", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        events = receiver3.getEvents();
        this.checkBlockAndUnBlock(events, "receiver3", new Object[]{BLOCK_EVENT, UNBLOCK_EVENT, BLOCK_EVENT, UNBLOCK_EVENT});
        events = receiver4.getEvents();
        System.out.println("-- [receiver4] events: " + events);
        MultiplexerViewTest.assertFalse((String)"new joiner should not have a BlockEvent", (boolean)events.contains(new BlockEvent()));
    }

    private void checkBlockAndUnBlock(List events, String service_name, Object[] seq) {
        int num_events = events.size();
        System.out.println("-- [" + service_name + "] events: " + events);
        MultiplexerViewTest.assertEquals((String)("[" + service_name + "] we should have the following sequence: " + Util.array2String(seq)), (int)seq.length, (int)num_events);
        for (int i = 0; i < seq.length; ++i) {
            Object expected_type = seq[i];
            Object actual_type = events.remove(0);
            MultiplexerViewTest.assertEquals((String)("element should be " + expected_type.getClass().getName()), actual_type.getClass(), expected_type.getClass());
        }
    }

    public void testTwoServicesOneChannel() throws Exception {
        this.c1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c2 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-2");
        this.c1.connect("bla");
        this.c2.connect("blo");
        View v = ((MuxChannel)this.c1).getClusterView();
        View v2 = ((MuxChannel)this.c2).getClusterView();
        MultiplexerViewTest.assertNotNull((Object)v);
        MultiplexerViewTest.assertNotNull((Object)v2);
        MultiplexerViewTest.assertEquals((Object)v, (Object)v2);
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        MultiplexerViewTest.assertEquals((int)1, (int)v2.size());
        v = this.c1.getView();
        v2 = this.c2.getView();
        MultiplexerViewTest.assertNotNull((Object)v);
        MultiplexerViewTest.assertNotNull((Object)v2);
        MultiplexerViewTest.assertEquals((Object)v, (Object)v2);
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        MultiplexerViewTest.assertEquals((int)1, (int)v2.size());
    }

    public void testTwoServicesTwoChannels() throws Exception {
        this.c1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c2 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-2");
        this.c1.connect("bla");
        this.c2.connect("blo");
        this.c3 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c4 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-2");
        this.c3.connect("foo");
        Util.sleep(500L);
        View v = ((MuxChannel)this.c1).getClusterView();
        View v2 = ((MuxChannel)this.c3).getClusterView();
        MultiplexerViewTest.assertNotNull((Object)v);
        MultiplexerViewTest.assertNotNull((Object)v2);
        MultiplexerViewTest.assertEquals((int)2, (int)v2.size());
        MultiplexerViewTest.assertEquals((Object)v, (Object)v2);
        v = this.c1.getView();
        v2 = this.c3.getView();
        MultiplexerViewTest.assertNotNull((Object)v);
        MultiplexerViewTest.assertNotNull((Object)v2);
        MultiplexerViewTest.assertEquals((int)2, (int)v2.size());
        MultiplexerViewTest.assertEquals((Object)v, (Object)v2);
        v = this.c2.getView();
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        this.c4.connect("bar");
        Util.sleep(500L);
        v = this.c2.getView();
        v2 = this.c4.getView();
        MultiplexerViewTest.assertEquals((int)2, (int)v.size());
        MultiplexerViewTest.assertEquals((Object)v, (Object)v2);
        this.c3.disconnect();
        Util.sleep(500L);
        v = this.c1.getView();
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        v = this.c2.getView();
        MultiplexerViewTest.assertEquals((int)2, (int)v.size());
        v = this.c4.getView();
        MultiplexerViewTest.assertEquals((int)2, (int)v.size());
        this.c3.close();
        this.c2.close();
        Util.sleep(500L);
        v = this.c4.getView();
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
    }

    public void testReconnect() throws Exception {
        this.c1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c1.connect("bla");
        this.c3 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-1");
        this.c4 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "service-2");
        this.c3.connect("foo");
        this.c4.connect("bar");
        Util.sleep(500L);
        View v = this.c1.getView();
        MultiplexerViewTest.assertEquals((int)2, (int)v.size());
        this.c3.disconnect();
        Util.sleep(500L);
        v = this.c1.getView();
        MultiplexerViewTest.assertEquals((int)1, (int)v.size());
        this.c3.connect("foobar");
        Util.sleep(500L);
        v = this.c1.getView();
        MultiplexerViewTest.assertEquals((int)2, (int)v.size());
        this.c4.close();
        Util.sleep(500L);
        v = this.c1.getView();
        MultiplexerViewTest.assertEquals((int)2, (int)v.size());
    }

    public static Test suite() {
        return new TestSuite(MultiplexerViewTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiplexerViewTest.suite());
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        List events = new LinkedList();

        private MyReceiver() {
        }

        public List getEvents() {
            return this.events;
        }

        public void clear() {
            this.events.clear();
        }

        public void block() {
            this.events.add(new BlockEvent());
        }

        public void unblock() {
            this.events.add(new UnblockEvent());
        }

        public void viewAccepted(View new_view) {
        }
    }
}

