/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

public class JoinTest
extends TestCase {
    Channel c1;
    Channel c2;
    static String STACK = "udp.xml";

    public JoinTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        STACK = System.getProperty("stack", STACK);
        this.c1 = new JChannel(STACK);
        this.c2 = new JChannel(STACK);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.c1 != null) {
            this.c1.close();
        }
        if (this.c2 != null) {
            this.c2.close();
        }
    }

    public void testSingleJoin() throws ChannelException {
        this.c1.connect("X");
        View v = this.c1.getView();
        JoinTest.assertNotNull((Object)v);
        JoinTest.assertEquals((int)1, (int)v.size());
    }

    public void testJoinsOnTwoChannels() throws ChannelException {
        this.c1.connect("X");
        this.c2.connect("X");
        View v1 = this.c1.getView();
        View v2 = this.c2.getView();
        System.out.println("v1=" + v1 + ", v2=" + v2);
        JoinTest.assertNotNull((Object)v1);
        JoinTest.assertNotNull((Object)v2);
        JoinTest.assertEquals((int)2, (int)v1.size());
        JoinTest.assertEquals((int)2, (int)v2.size());
        JoinTest.assertEquals((Object)v1, (Object)v2);
    }

    public void testJoinsOnTwoChannelsAndSend() throws ChannelException {
        MyReceiver r1 = new MyReceiver("c1");
        MyReceiver r2 = new MyReceiver("c2");
        this.c1.setReceiver(r1);
        this.c2.setReceiver(r2);
        Message m1 = new Message(null, null, (Serializable)((Object)"message-1"));
        Message m2 = new Message(null, null, (Serializable)((Object)"message-2"));
        this.c1.connect("X");
        this.c2.connect("X");
        this.c1.send(m1);
        this.c2.send(m2);
        Util.sleep(200L);
        List c1_list = r1.getMsgs();
        List c2_list = r2.getMsgs();
        System.out.println("c1: " + c1_list.size() + " msgs, c2: " + c2_list.size() + " msgs");
        JoinTest.assertNotNull((Object)c1_list);
        JoinTest.assertNotNull((Object)c2_list);
        JoinTest.assertEquals((int)2, (int)c1_list.size());
        JoinTest.assertEquals((int)2, (int)c2_list.size());
        JoinTest.assertTrue((boolean)c1_list.contains("message-1"));
        JoinTest.assertTrue((boolean)c2_list.contains("message-1"));
        JoinTest.assertTrue((boolean)c1_list.contains("message-2"));
        JoinTest.assertTrue((boolean)c2_list.contains("message-2"));
    }

    public static Test suite() {
        return new TestSuite(JoinTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JoinTest.suite());
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        String name;
        List msgs = new LinkedList();

        public MyReceiver(String name) {
            this.name = name;
        }

        public List getMsgs() {
            return this.msgs;
        }

        public void clear() {
            this.msgs.clear();
        }

        public void receive(Message msg) {
            String s = (String)msg.getObject();
            this.msgs.add(s);
            System.out.println("[" + this.name + "] received " + s + " from " + msg.getSrc());
        }

        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + "] view: " + new_view);
        }
    }
}

