/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand {
    private final Vector members = new Vector(11);
    private final HashMap connections = new HashMap(11);
    private long[] timeout = new long[]{400L, 800L, 1600L, 3200L};
    private Address local_addr = null;
    private TimeScheduler timer = null;
    private boolean use_gms = true;
    private boolean started = false;
    private final BoundedList previous_members = new BoundedList(50);
    private static final String name = "UNICAST";
    private static final long DEFAULT_FIRST_SEQNO = 1L;
    private long num_msgs_sent = 0L;
    private long num_msgs_received = 0L;
    private long num_bytes_sent = 0L;
    private long num_bytes_received = 0L;
    private long num_acks_sent = 0L;
    private long num_acks_received = 0L;
    private long num_xmit_requests_received = 0L;

    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    public String printConnections() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.connections.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    public long getNumberOfRetransmitRequestsReceived() {
        return this.num_xmit_requests_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfUnackedMessages() {
        int num = 0;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            Iterator it = this.connections.values().iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                if (entry.sent_msgs == null) continue;
                num += entry.sent_msgs.size();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnackedMessages() {
        StringBuffer sb = new StringBuffer();
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            Iterator it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object member = entry.getKey();
                Entry e = (Entry)entry.getValue();
                sb.append(member).append(": ");
                if (e.sent_msgs == null) continue;
                sb.append(e.sent_msgs.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            Iterator it = this.connections.values().iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                if (entry.received_msgs == null) continue;
                num += entry.received_msgs.size();
            }
        }
        return num;
    }

    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmit_requests_received = 0L;
    }

    public Map dumpStats() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("num_msgs_sent", new Long(this.num_msgs_sent));
        m.put("num_msgs_received", new Long(this.num_msgs_received));
        m.put("num_bytes_sent", new Long(this.num_bytes_sent));
        m.put("num_bytes_received", new Long(this.num_bytes_received));
        m.put("num_acks_sent", new Long(this.num_acks_sent));
        m.put("num_acks_received", new Long(this.num_acks_received));
        m.put("num_xmit_requests_received", new Long(this.num_xmit_requests_received));
        m.put("num_unacked_msgs", new Long(this.getNumberOfUnackedMessages()));
        m.put("unacked_msgs", this.getUnackedMessages());
        m.put("num_msgs_in_recv_windows", new Long(this.getNumberOfMessagesInReceiveWindows()));
        return m;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("window_size")) != null) {
            props.remove("window_size");
            this.log.warn((Object)"window_size is deprecated and will be ignored");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            props.remove("min_threshold");
            this.log.warn((Object)"min_threshold is deprecated and will be ignored");
        }
        if ((str = props.getProperty("use_gms")) != null) {
            this.use_gms = Boolean.valueOf(str);
            props.remove("use_gms");
        }
        if (props.size() > 0) {
            this.log.error((Object)("these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.removeAllConnections();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress() || (hdr = (UnicastHeader)msg.getHeader(name)) == null) break;
                Address src = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        if (this.handleDataReceived(src, hdr.seqno, msg)) {
                            this.sendAck(src, hdr.seqno);
                        }
                        return;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    default: {
                        this.log.error((Object)("UnicastHeader type " + hdr.type + " not known !"));
                    }
                }
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message tmp;
                Entry entry;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress()) break;
                if (this.previous_members.contains(dst)) {
                    if (!this.log.isTraceEnabled()) return;
                    this.log.trace((Object)("discarding message to " + dst + " as this member left the group," + " previous_members=" + this.previous_members));
                    return;
                }
                if (!this.started) {
                    if (!this.log.isWarnEnabled()) return;
                    this.log.warn((Object)("discarded message as start() has not yet been called, message: " + msg));
                    return;
                }
                HashMap hashMap = this.connections;
                synchronized (hashMap) {
                    entry = (Entry)this.connections.get(dst);
                    if (entry == null) {
                        entry = new Entry();
                        this.connections.put(dst, entry);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(this.local_addr + ": created new connection for dst " + dst));
                        }
                    }
                }
                Entry entry2 = entry;
                synchronized (entry2) {
                    long seqno = -2L;
                    try {
                        seqno = entry.sent_msgs_seqno;
                        UnicastHeader hdr = new UnicastHeader(0, seqno);
                        if (entry.sent_msgs == null) {
                            entry.sent_msgs = new AckSenderWindow(this, this.timeout, this.timer, this.local_addr);
                        }
                        msg.putHeader(name, hdr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)new StringBuffer().append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno));
                        }
                        tmp = msg;
                        entry.sent_msgs.add(seqno, tmp);
                        ++entry.sent_msgs_seqno;
                    }
                    catch (Throwable t) {
                        entry.sent_msgs.ack(seqno);
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (!(t instanceof RuntimeException)) throw new RuntimeException("failure adding msg " + msg + " to the retransmit table", t);
                        throw (RuntimeException)t;
                    }
                }
                try {
                    this.passDown(new Event(1, tmp));
                    ++this.num_msgs_sent;
                    this.num_bytes_sent += (long)msg.getLength();
                    return;
                }
                catch (Throwable t) {
                    if (!this.log.isWarnEnabled()) return;
                    this.log.warn((Object)"failure passing message down", t);
                }
                return;
            }
            case 6: {
                Vector left_members;
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    left_members = Util.determineLeftMembers(this.members, new_members);
                    this.members.clear();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                }
                if (this.use_gms && left_members.size() > 0) {
                    for (int i = 0; i < left_members.size(); ++i) {
                        Object mbr = left_members.elementAt(i);
                        boolean rc = this.removeConnection(mbr);
                        if (!rc || !this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)("removed " + mbr + " from connection table, member(s) " + left_members + " left"));
                    }
                }
                Enumeration e = this.previous_members.elements();
                while (e.hasMoreElements()) {
                    Object mbr = e.nextElement();
                    if (!this.members.contains(mbr) || this.previous_members.removeElement(mbr) == null || !this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("removing " + mbr + " from previous_members as result of VIEW_CHANGE event, " + "previous_members=" + this.previous_members));
                }
                break;
            }
            case 67: {
                Object member = evt.getArg();
                Object removed = this.previous_members.removeElement(member);
                if (removed == null || !this.log.isTraceEnabled()) break;
                this.log.trace((Object)("removing " + member + " from previous_members as result of ENABLE_UNICAST_TO event, " + "previous_members=" + this.previous_members));
                break;
            }
            case 81: {
                Object member = evt.getArg();
                this.removeConnection(member);
                this.previous_members.removeElement(member);
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeConnection(Object mbr) {
        Entry entry;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            entry = (Entry)this.connections.remove(mbr);
            if (!this.previous_members.contains(mbr)) {
                this.previous_members.add(mbr);
            }
        }
        if (entry != null) {
            entry.reset();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(this.local_addr + ": removed connection for dst " + mbr));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConnections() {
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            Iterator it = this.connections.values().iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                entry.reset();
            }
            this.connections.clear();
        }
    }

    public void retransmit(long seqno, Message msg) {
        Address dst = msg.getDest();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.local_addr + "] --> XMIT(" + dst + ": #" + seqno + ')'));
        }
        this.passDown(new Event(1, msg));
        ++this.num_xmit_requests_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDataReceived(Object sender, long seqno, Message msg) {
        AckReceiverWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuffer().append(this.local_addr).append(" <-- DATA(").append(sender).append(": #").append(seqno));
        }
        if (this.previous_members.contains(sender)) {
            if (seqno > 1L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("discarding message " + seqno + " from previous member " + sender));
                }
                return false;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removed " + sender + " from previous_members as we received a message from it"));
            }
            this.previous_members.removeElement(sender);
        }
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            Entry entry = (Entry)this.connections.get(sender);
            if (entry == null) {
                entry = new Entry();
                this.connections.put(sender, entry);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.local_addr + ": created new connection for dst " + sender));
                }
            }
            if ((win = entry.received_msgs) == null) {
                entry.received_msgs = win = new AckReceiverWindow(1L);
            }
        }
        win.add(seqno, msg);
        ++this.num_msgs_received;
        this.num_bytes_received += (long)msg.getLength();
        AckReceiverWindow ackReceiverWindow = win;
        synchronized (ackReceiverWindow) {
            Message m;
            while ((m = win.remove()) != null) {
                this.passUp(new Event(1, m));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAckReceived(Object sender, long seqno) {
        Entry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuffer().append(this.local_addr).append(" <-- ACK(").append(sender).append(": #").append(seqno).append(')'));
        }
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            entry = (Entry)this.connections.get(sender);
        }
        if (entry == null || entry.sent_msgs == null) {
            return;
        }
        AckSenderWindow win = entry.sent_msgs;
        win.ack(seqno);
        ++this.num_acks_received;
    }

    private void sendAck(Address dst, long seqno) {
        Message ack = new Message(dst);
        ack.putHeader(name, new UnicastHeader(1, seqno));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuffer().append(this.local_addr).append(" --> ACK(").append(dst).append(": #").append(seqno).append(')'));
        }
        this.passDown(new Event(1, ack));
        ++this.num_acks_sent;
    }

    private static final class Entry {
        AckReceiverWindow received_msgs = null;
        AckSenderWindow sent_msgs = null;
        long sent_msgs_seqno = 1L;

        private Entry() {
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
            this.sent_msgs_seqno = 1L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=").append(this.sent_msgs).append('\n');
            }
            if (this.received_msgs != null) {
                sb.append("received_msgs=").append(this.received_msgs).append('\n');
            }
            return sb.toString();
        }
    }

    public static class UnicastHeader
    extends Header
    implements Streamable {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        byte type = 0;
        long seqno = 0L;
        static final long serialized_size = 9L;

        public UnicastHeader() {
        }

        public UnicastHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        public String toString() {
            return "[UNICAST: " + UnicastHeader.type2Str(this.type) + ", seqno=" + this.seqno + ']';
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
            }
            return "<unknown>";
        }

        public final long size() {
            return 9L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }
    }
}

