/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.SavedMessages;

class MessageAcks {
    final Log log = LogFactory.getLog((Class)MessageAcks.class);
    private final Vector acks = new Vector();
    private final SavedMessages message_history = new SavedMessages();

    MessageAcks(Vector members) {
        this.reset(members);
    }

    public synchronized void reset(Vector members) {
        this.clear();
        int num_members = members.size();
        for (int i = 0; i < num_members; ++i) {
            Object temp_obj = members.elementAt(i);
            if (!(temp_obj instanceof Address)) {
                this.log.error((Object)"Error: (TOTAL_OLD) MessageAcks.reset() - could not cast element of \"members\" to an Address object");
                return;
            }
            this.acks.addElement(new Entry((Address)temp_obj));
        }
    }

    private void clear() {
        this.acks.removeAllElements();
        this.message_history.clearMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(Address addr) {
        Vector vector = this.acks;
        synchronized (vector) {
            int size = this.acks.size();
            for (int i = 0; i < size; ++i) {
                Object temp_obj = this.acks.elementAt(i);
                if (temp_obj instanceof Entry) {
                    Entry this_entry = (Entry)temp_obj;
                    if (!this_entry.addr.equals(addr)) continue;
                    return this_entry;
                }
                this.log.error((Object)"Error: (TOTAL_OLD) MessageAcks.getEntry() - could not cast element of \"acks\" to an Entry");
            }
            return null;
        }
    }

    public void setSeq(Address addr, long seq) {
        Entry this_entry = this.getEntry(addr);
        if (this_entry != null && this_entry.seq < seq) {
            this_entry.seq = seq;
            this.truncateHistory();
        }
    }

    public long getSeq(Address addr) {
        Entry this_entry = this.getEntry(addr);
        if (this_entry == null) {
            return -2L;
        }
        return this_entry.seq;
    }

    public Message getMessage(long seq) {
        return this.message_history.peekMessage(seq);
    }

    public void addMessage(Message msg, long seq) {
        this.message_history.insertMessage(msg, seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLowestSeqAck() {
        Vector vector = this.acks;
        synchronized (vector) {
            long ret_val = -10L;
            int size = this.acks.size();
            for (int i = 0; i < size; ++i) {
                Object temp_obj = this.acks.elementAt(i);
                if (temp_obj instanceof Entry) {
                    long this_seq = ((Entry)temp_obj).seq;
                    if (this_seq >= ret_val) continue;
                    ret_val = this_seq;
                    continue;
                }
                this.log.error((Object)("Error: (TOTAL_OLD) MessageAcks.getLowestSeqAck() - could not cast element of \"acks\" to an Entry (index=" + i + ')'));
                return -1L;
            }
            return ret_val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void truncateHistory() {
        long lowest_ack_seq = this.getLowestSeqAck();
        if (lowest_ack_seq < 0L) {
            return;
        }
        SavedMessages savedMessages = this.message_history;
        synchronized (savedMessages) {
            long lowest_stored_seq;
            while ((lowest_stored_seq = this.message_history.getFirstSeq()) >= 0L && lowest_stored_seq > lowest_ack_seq) {
                this.message_history.getFirstMessage();
            }
        }
    }

    class Entry {
        public final Address addr;
        public long seq;

        Entry(Address addr, long seq) {
            this.addr = addr;
            this.seq = seq;
        }

        Entry(Address addr) {
            this.addr = addr;
            this.seq = -1L;
        }
    }
}

