/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.PING;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Util;

public class MPING
extends PING
implements Runnable {
    MulticastSocket mcast_sock = null;
    Thread receiver = null;
    InetAddress bind_addr = null;
    boolean bind_to_all_interfaces = false;
    int ip_ttl = 16;
    InetAddress mcast_addr = null;
    int mcast_port = 7555;
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(512);
    byte[] receive_buf = new byte[1024];

    public String getName() {
        return "MPING";
    }

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public void setBindAddr(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public boolean isBindToAllInterfaces() {
        return this.bind_to_all_interfaces;
    }

    public void setBindToAllInterfaces(boolean bind_to_all_interfaces) {
        this.bind_to_all_interfaces = bind_to_all_interfaces;
    }

    public int getTTL() {
        return this.ip_ttl;
    }

    public void setTTL(int ip_ttl) {
        this.ip_ttl = ip_ttl;
    }

    public InetAddress getMcastAddr() {
        return this.mcast_addr;
    }

    public void setMcastAddr(InetAddress mcast_addr) {
        this.mcast_addr = mcast_addr;
    }

    public int getMcastPort() {
        return this.mcast_port;
    }

    public void setMcastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    public boolean setProperties(Properties props) {
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.mping.mcast_addr"}, props, "mcast_addr", false, "230.5.6.7")) != null) {
            try {
                this.mcast_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException e) {
                this.log.error((Object)("could not resolve " + str), (Throwable)e);
                return false;
            }
            props.remove("mcast_addr");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.mping.mcast_port"}, props, "mcast_port", false, "7555")) != null) {
            this.mcast_port = Integer.parseInt(str);
            props.remove("mcast_port");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.mping.ip_ttl"}, props, "ip_ttl", false, "16")) != null) {
            this.ip_ttl = Integer.parseInt(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("bind_to_all_interfaces")) != null) {
            this.bind_to_all_interfaces = new Boolean(str);
            props.remove("bind_to_all_interfaces");
        }
        if (this.mcast_addr == null) {
            try {
                this.mcast_addr = InetAddress.getByName("230.5.6.7");
            }
            catch (UnknownHostException e) {
                this.log.error((Object)"failed getting default mcast address", (Throwable)e);
                return false;
            }
        }
        return super.setProperties(props);
    }

    public void up(Event evt) {
        if (evt.getType() == 56) {
            if (this.bind_addr == null) {
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
            this.passUp(evt);
            return;
        }
        super.up(evt);
    }

    public void start() throws Exception {
        this.mcast_sock = new MulticastSocket(this.mcast_port);
        this.mcast_sock.setTimeToLive(this.ip_ttl);
        if (this.bind_to_all_interfaces) {
            this.bindToAllInterfaces();
            if (this.bind_addr != null) {
                this.mcast_sock.setNetworkInterface(NetworkInterface.getByInetAddress(this.bind_addr));
            }
        } else {
            if (this.bind_addr == null) {
                this.bind_addr = Util.getFirstNonLoopbackAddress();
            }
            if (this.bind_addr == null) {
                this.bind_addr = InetAddress.getLocalHost();
            }
            if (this.bind_addr != null && this.log.isInfoEnabled()) {
                this.log.info((Object)("sockets will use interface " + this.bind_addr.getHostAddress()));
            }
            if (this.bind_addr != null) {
                this.mcast_sock.setInterface(this.bind_addr);
            }
            this.mcast_sock.joinGroup(this.mcast_addr);
        }
        this.startReceiver();
        super.start();
    }

    private void bindToAllInterfaces() throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(this.mcast_addr, this.mcast_port);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            if (!en2.hasMoreElements()) continue;
            InetAddress addr = en2.nextElement();
            this.mcast_sock.joinGroup(tmp_mcast_addr, i);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("joined " + tmp_mcast_addr + " on interface " + i.getName() + " (" + addr + ")"));
        }
    }

    private void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            this.receiver = new Thread(Util.getGlobalThreadGroup(), this, "ReceiverThread");
            this.receiver.setDaemon(true);
            this.receiver.start();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"receiver thread started");
            }
        }
    }

    public void stop() {
        this.mcast_sock.close();
        this.mcast_sock = null;
        this.receiver = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMcastDiscoveryRequest(Message msg) {
        DataOutputStream out = null;
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            this.out_stream.reset();
            out = new DataOutputStream(this.out_stream);
            msg.writeTo(out);
            out.flush();
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            DatagramPacket packet = new DatagramPacket(buf.getBuf(), buf.getOffset(), buf.getLength(), this.mcast_addr, this.mcast_port);
            this.mcast_sock.send(packet);
            Util.close(out);
        }
        catch (IOException ex) {
            this.log.error((Object)"failed sending discovery request", (Throwable)ex);
        }
        finally {
            Util.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        DatagramPacket packet = new DatagramPacket(this.receive_buf, this.receive_buf.length);
        ByteArrayInputStream inp_stream = null;
        DataInputStream inp = null;
        while (this.mcast_sock != null && this.receiver != null && Thread.currentThread().equals(this.receiver)) {
            packet.setData(this.receive_buf, 0, this.receive_buf.length);
            try {
                this.mcast_sock.receive(packet);
                byte[] data = packet.getData();
                inp_stream = new ByteArrayInputStream(data, 0, data.length);
                inp = new DataInputStream(inp_stream);
                Message msg = new Message();
                msg.readFrom(inp);
                this.up(new Event(1, msg));
                this.closeInputStream(inp);
                this.closeInputStream(inp_stream);
            }
            catch (SocketException socketEx) {
                this.closeInputStream(inp);
                this.closeInputStream(inp_stream);
                break;
            }
            catch (Exception ex) {
                this.log.error((Object)"failed receiving packet", (Throwable)ex);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeInputStream(inp);
                this.closeInputStream(inp_stream);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"receiver thread terminated");
        }
    }

    private void closeInputStream(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

