/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherTest
extends ChannelTestBase {
    RpcDispatcher disp1;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    JChannel c1;
    JChannel c2;
    JChannel c3;
    static final int[] SIZES = new int[]{10000, 20000, 40000, 80000, 100000, 200000, 400000, 800000, 1000000, 2000000, 5000000, 10000000, 20000000};

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = (JChannel)this.createChannel("A");
        this.disp1 = new RpcDispatcher((Channel)this.c1, null, null, new ServerObject(1));
        this.c1.connect("demo");
        this.c2 = (JChannel)this.createChannel("A");
        this.disp2 = new RpcDispatcher((Channel)this.c2, null, null, new ServerObject(2));
        this.c2.connect("demo");
        this.c3 = (JChannel)this.createChannel("A");
        this.disp3 = new RpcDispatcher((Channel)this.c3, null, null, new ServerObject(3));
        this.c3.connect("demo");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.disp3.stop();
        this.c3.close();
        this.disp2.stop();
        this.c2.close();
        this.disp1.stop();
        this.c1.close();
    }

    public void foo() {
    }

    public void testMethodInvocationToNonExistingMembers() {
        View view = this.c3.getView();
        Vector members = view.getMembers();
        System.out.println("list is " + members);
        System.out.println("closing c3");
        this.c3.close();
        Util.sleep(1000L);
        System.out.println("calling method foo() in " + members + " (view=" + this.c2.getView() + ")");
        RspList rsps = this.disp1.callRemoteMethods(members, "foo", null, (Class[])null, 2, 5000L);
        System.out.println("responses:\n" + rsps);
        Iterator it = rsps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Rsp rsp = (Rsp)entry.getValue();
            RpcDispatcherTest.assertTrue((String)("response from " + entry.getKey() + " was not received"), (boolean)rsp.wasReceived());
            RpcDispatcherTest.assertFalse((boolean)rsp.wasSuspected());
        }
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherTest.suite());
    }

    private static class ServerObject {
        int i;

        public ServerObject(int i) {
            this.i = i;
        }

        public int foo() {
            return this.i;
        }

        public static byte[] largeReturnValue(int size) {
            return new byte[size];
        }
    }
}

