/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.EJB;
import javax.naming.InitialContext;
import org.jboss.ejb3.EjbLinkResolver;
import org.jboss.ejb3.injection.EJBHandler;
import org.jboss.ejb3.injection.pojo.InjectionHelper;
import org.jboss.ejb3.injection.pojo.PojoInjector;

public class EJBInjector
implements PojoInjector {
    private EjbLinkResolver resolver;
    private InitialContext initialContext;

    public EJBInjector(EjbLinkResolver resolver, InitialContext initialContext) {
        this.resolver = resolver;
        this.initialContext = initialContext;
    }

    public void inject(Method m, Annotation annotation, Object pojo) {
        InjectionHelper.checkMethodSignature(m, annotation);
        String jndiName = EJBHandler.getJndiName((EJB)annotation, this.resolver, m.getParameterTypes()[0]);
        try {
            m.invoke(pojo, this.initialContext.lookup(jndiName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void inject(Field f, Annotation annotation, Object pojo) {
        String jndiName = EJBHandler.getJndiName((EJB)annotation, this.resolver, f.getType());
        try {
            f.setAccessible(true);
            f.set(pojo, this.initialContext.lookup(jndiName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

