/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.PojoInjector;

public class JndiFieldInjector
implements Injector,
PojoInjector {
    private Field field;
    private String jndiName;
    private Context ctx;

    public JndiFieldInjector(Field field, String jndiName, Context ctx) {
        this.field = field;
        this.field.setAccessible(true);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    public JndiFieldInjector(Field field, Context ctx) {
        this(field, field.getName(), ctx);
    }

    public void inject(BeanContext bctx) {
        this.inject(bctx, bctx.getInstance());
    }

    public void inject(BeanContext bctx, Object instance) {
        Object dependency = null;
        try {
            dependency = this.ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to inject jndi dependency: " + this.jndiName + " into field " + this.field, e);
        }
        try {
            this.field.set(instance, dependency);
        }
        catch (IllegalArgumentException e) {
            String type = "UNKNOWN";
            String interfaces = "";
            if (dependency != null) {
                Class<?>[] intfs;
                type = dependency.getClass().getName();
                for (Class<?> intf : intfs = dependency.getClass().getInterfaces()) {
                    interfaces = interfaces + ", " + intf.getName();
                }
            }
            throw new RuntimeException("Non matching type for inject of field: " + this.field + " for type: " + type + " of jndiName " + this.jndiName + "\nintfs: " + interfaces, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

