/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import javax.persistence.FlushModeType;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TxManager;

public class FlushModeInterceptor
implements Interceptor {
    private FlushModeType mode;
    protected static ThreadLocal flushMode = new ThreadLocal();
    protected static TransactionLocal txFlushMode = new TransactionLocal((TransactionManager)TxManager.getInstance());

    public FlushModeInterceptor(FlushModeType mode) {
        this.mode = mode;
    }

    public String getName() {
        return FlushModeInterceptor.class.getName();
    }

    public static FlushModeType getFlushMode() {
        FlushModeType mode = (FlushModeType)flushMode.get();
        if (mode == null) {
            mode = FlushModeType.AUTO;
        }
        return mode;
    }

    public static FlushModeType getTxFlushMode() {
        FlushModeType mode = (FlushModeType)txFlushMode.get();
        if (mode == null) {
            mode = FlushModeType.AUTO;
        }
        return mode;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        flushMode.set(this.mode);
        if (txFlushMode.getTransaction() != null) {
            txFlushMode.set((Object)this.mode);
        }
        return invocation.invokeNext();
    }
}

