/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.dd;

import java.util.ArrayList;
import java.util.List;
import org.jboss.ejb3.dd.ClusterConfig;
import org.jboss.ejb3.dd.EjbLocalRef;
import org.jboss.ejb3.dd.EjbRef;
import org.jboss.ejb3.dd.EnterpriseBean;
import org.jboss.ejb3.dd.Invoker;
import org.jboss.ejb3.dd.MessageDestinationRef;
import org.jboss.ejb3.dd.MessageDrivenBean;
import org.jboss.ejb3.dd.MethodAttributes;
import org.jboss.ejb3.dd.ResourceEnvRef;
import org.jboss.ejb3.dd.ResourceRef;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeans {
    private static final Logger log = Logger.getLogger(EnterpriseBeans.class);
    private List enterpriseBeans = new ArrayList();
    private EnterpriseBean currentEjb;

    public void addResourceRef(ResourceRef ref) {
        this.currentEjb.mergeResourceRef(ref);
    }

    public void addResourceEnvRef(ResourceEnvRef ref) {
        this.currentEjb.mergeResourceEnvRef(ref);
    }

    public void addMessageDestinationRef(MessageDestinationRef ref) {
        this.currentEjb.mergeMessageDestinationRef(ref);
    }

    public void addInvoker(Invoker invoker) {
        this.currentEjb.addInvoker(invoker);
    }

    public void setMethodAttributes(MethodAttributes attributes) {
        this.currentEjb.setMethodAttributes(attributes);
    }

    public void setCurrentEjbName(String currentEjbName) {
        this.currentEjb = this.findEjbByEjbName(currentEjbName);
    }

    public void addDependency(String depends) {
        this.currentEjb.addDependency(depends);
    }

    public void updateEjbRef(EjbRef ref) {
        this.currentEjb.updateEjbRef(ref);
    }

    public void updateEjbLocalRef(EjbLocalRef ref) {
        this.currentEjb.updateEjbLocalRef(ref);
    }

    public void setResourceAdapterName(String name) {
        ((MessageDrivenBean)this.currentEjb).setResourceAdaptorName(name);
    }

    public void setAopDomainName(String aopDomainName) {
        this.currentEjb.setAopDomainName(aopDomainName);
    }

    public void setRunAsPrincipal(String principal) {
        this.currentEjb.setRunAsPrincipal(principal);
    }

    public void setClusterConfig(ClusterConfig config) {
        this.currentEjb.setClusterConfig(config);
    }

    public void setCallByValue(boolean callByValue) {
        this.currentEjb.setCallByValue(callByValue);
    }

    public void setJndiName(String jndiName) {
        this.currentEjb.setJndiName(jndiName);
    }

    public void setSecurityDomain(String securityDomain) {
        this.currentEjb.setSecurityDomain(securityDomain);
    }

    public void setLocalJndiName(String jndiName) {
        this.currentEjb.setLocalJndiName(jndiName);
    }

    public EnterpriseBean findEjbByEjbName(String ejbName) {
        for (EnterpriseBean ejb : this.enterpriseBeans) {
            if (!ejb.getEjbName().equals(ejbName)) continue;
            return ejb;
        }
        return null;
    }

    public List<EnterpriseBean> findEjbsByClass(String className) {
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        for (EnterpriseBean ejb : this.enterpriseBeans) {
            String ejbClassName = ejb.getEjbClass();
            if (ejbClassName == null || !ejbClassName.equals(className)) continue;
            result.add(ejb);
        }
        return result;
    }

    public EnterpriseBean findEjbByRemote(String remote) {
        for (EnterpriseBean ejb : this.enterpriseBeans) {
            if (ejb.getRemote() == null || !ejb.getRemote().equals(remote)) continue;
            return ejb;
        }
        return null;
    }

    public EnterpriseBean findEjbByLocal(String local) {
        for (EnterpriseBean ejb : this.enterpriseBeans) {
            if (ejb.getLocal() == null || !ejb.getLocal().equals(local)) continue;
            return ejb;
        }
        return null;
    }

    public List getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    public void setEnterpriseBeans(List enterpriseBeans) {
        this.enterpriseBeans = enterpriseBeans;
    }

    public void addEnterpriseBean(EnterpriseBean ejb) {
        this.enterpriseBeans.add(ejb);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append("enterpriseBeans=").append(this.enterpriseBeans);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnterpriseBeans)) {
            return false;
        }
        EnterpriseBeans ejbs = (EnterpriseBeans)o;
        return !(this.enterpriseBeans != null ? !((Object)this.enterpriseBeans).equals(ejbs.enterpriseBeans) : ejbs.enterpriseBeans != null);
    }

    public int hashCode() {
        int result = this.enterpriseBeans != null ? ((Object)this.enterpriseBeans).hashCode() : 0;
        return result;
    }
}

