/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.injection.Injector;

public abstract class AbstractPool
implements Pool {
    protected Class beanClass;
    protected Class contextClass;
    protected Injector[] injectors;
    protected Container container;

    public void initialize(Container container, Class contextClass, Class beanClass, int maxSize, long timeout) {
        this.beanClass = beanClass;
        this.contextClass = contextClass;
        this.container = container;
    }

    protected BeanContext create() {
        BeanContext ctx;
        Object bean;
        try {
            bean = this.container.construct();
            ctx = (BeanContext)this.contextClass.newInstance();
            ctx.setContainer(this.container);
            ctx.setInstance(bean);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (this.injectors != null) {
            for (int i = 0; i < this.injectors.length; ++i) {
                this.injectors[i].inject(ctx);
            }
        }
        ctx.initialiseInterceptorInstances();
        this.container.invokeInit(bean);
        this.container.invokePostConstruct(ctx);
        return ctx;
    }

    protected BeanContext create(Class[] initTypes, Object[] initValues) {
        BeanContext ctx;
        Object bean;
        try {
            bean = this.container.construct();
            ctx = (BeanContext)this.contextClass.newInstance();
            ctx.setContainer(this.container);
            ctx.setInstance(bean);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (this.injectors != null) {
            for (int i = 0; i < this.injectors.length; ++i) {
                this.injectors[i].inject(ctx);
            }
        }
        this.container.invokeInit(bean, initTypes, initValues);
        this.container.invokePostConstruct(ctx);
        return ctx;
    }

    public void remove(BeanContext ctx) {
        Object bean = ctx.getInstance();
        this.container.invokePreDestroy(ctx);
        ctx.remove();
    }

    public void setInjectors(Injector[] injectors) {
        this.injectors = injectors;
    }
}

