/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.digester.plugins.strategies;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.plugins.PluginException;
import com.sun.org.apache.commons.digester.plugins.RuleFinder;
import com.sun.org.apache.commons.digester.plugins.RuleLoader;
import com.sun.org.apache.commons.digester.plugins.strategies.LoaderFromStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FinderFromFile
extends RuleFinder {
    public static String DFLT_FILENAME_ATTR = "file";
    private String filenameAttr;

    public FinderFromFile() {
        this(DFLT_FILENAME_ATTR);
    }

    public FinderFromFile(String filenameAttr) {
        this.filenameAttr = filenameAttr;
    }

    public RuleLoader findLoader(Digester d, Class pluginClass, Properties p) throws PluginException {
        String rulesFileName = p.getProperty(this.filenameAttr);
        if (rulesFileName == null) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(rulesFileName);
        }
        catch (IOException ioe) {
            throw new PluginException("Unable to process file [" + rulesFileName + "]", ioe);
        }
        try {
            LoaderFromStream loader;
            LoaderFromStream loaderFromStream = loader = new LoaderFromStream(is);
            return loaderFromStream;
        }
        catch (Exception e) {
            throw new PluginException("Unable to load xmlrules from file [" + rulesFileName + "]", e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException ioe) {
                throw new PluginException("Unable to close stream for file [" + rulesFileName + "]", ioe);
            }
        }
    }
}

