/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils;

import com.sun.org.apache.commons.beanutils.DynaBean;
import com.sun.org.apache.commons.beanutils.DynaClass;
import com.sun.org.apache.commons.beanutils.DynaProperty;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

abstract class JDBCDynaClass
implements DynaClass,
Serializable {
    protected boolean lowerCase = true;
    protected DynaProperty[] properties = null;
    protected Map propertiesMap = new HashMap();

    JDBCDynaClass() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    protected Class loadClass(String className) throws SQLException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return cl.loadClass(className);
        }
        catch (Exception e) {
            throw new SQLException("Cannot load column class '" + className + "': " + e);
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
        String name = null;
        name = this.lowerCase ? metadata.getColumnName(i).toLowerCase() : metadata.getColumnName(i);
        String className = null;
        try {
            className = metadata.getColumnClassName(i);
        }
        catch (SQLException e) {
            // empty catch block
        }
        Class clazz = Object.class;
        if (className != null) {
            clazz = this.loadClass(className);
        }
        return new DynaProperty(name, clazz);
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        int i;
        ArrayList<DynaProperty> list = new ArrayList<DynaProperty>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int n = metadata.getColumnCount();
        for (i = 1; i <= n; ++i) {
            DynaProperty dynaProperty = this.createDynaProperty(metadata, i);
            if (dynaProperty == null) continue;
            list.add(dynaProperty);
        }
        this.properties = list.toArray(new DynaProperty[list.size()]);
        for (i = 0; i < this.properties.length; ++i) {
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
    }
}

