/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.type;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.InstantiationException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.engine.Cascades;
import cirrus.hibernate.engine.Mapping;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.ArrayHelper;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.AbstractType;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ComponentType
extends AbstractType
implements AbstractComponentType {
    private final Class componentClass;
    private final Constructor constructor;
    private final Type[] types;
    private final ReflectHelper.Getter[] getters;
    private final ReflectHelper.Setter[] setters;
    private final String[] propertyNames;
    private final Cascades.CascadeStyle[] cascade;
    private final int propertySpan;
    private final int[] joinedFetch;
    private final String parentProperty;
    private final ReflectHelper.Setter parentSetter;

    public int[] sqlTypes(Mapping pi) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(pi)];
        int n = 0;
        int i = 0;
        while (i < this.propertySpan) {
            int[] subtypes = this.types[i].sqlTypes(pi);
            int j = 0;
            while (j < subtypes.length) {
                sqlTypes[n++] = subtypes[j];
                ++j;
            }
            ++i;
        }
        return sqlTypes;
    }

    public int getColumnSpan(Mapping pi) throws MappingException {
        int span = 0;
        int i = 0;
        while (i < this.types.length) {
            span += this.types[i].getColumnSpan(pi);
            ++i;
        }
        return span;
    }

    public ComponentType(Class componentClass, Type[] types, String[] properties, int[] joinedFetch, Cascades.CascadeStyle[] cascade, String parentProperty, boolean embedded) throws MappingException {
        this.componentClass = componentClass;
        this.types = types;
        this.propertySpan = properties.length;
        this.getters = new ReflectHelper.Getter[this.propertySpan];
        this.setters = new ReflectHelper.Setter[this.propertySpan];
        int i = 0;
        while (i < properties.length) {
            this.getters[i] = ReflectHelper.getGetter(componentClass, properties[i]);
            this.setters[i] = ReflectHelper.getSetter(componentClass, properties[i]);
            ++i;
        }
        this.parentSetter = parentProperty == null ? null : ReflectHelper.getSetter(componentClass, parentProperty);
        this.parentProperty = parentProperty;
        this.propertyNames = properties;
        this.cascade = cascade;
        this.joinedFetch = joinedFetch;
        this.constructor = ReflectHelper.getDefaultConstructor(componentClass);
    }

    public boolean isPersistentCollectionType() {
        return false;
    }

    public final boolean isComponentType() {
        return true;
    }

    public final boolean isEntityType() {
        return false;
    }

    public Class returnedClass() {
        return this.componentClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        int i = 0;
        while (i < this.getters.length) {
            if (!this.types[i].equals(this.getters[i].get(x), this.getters[i].get(y))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDirty(Object x, Object y, Object owner, SessionFactoryImplementor factory) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        int i = 0;
        while (i < this.getters.length) {
            if (this.types[i].isDirty(this.getters[i].get(x), this.getters[i].get(y), owner, factory)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            int length = this.types[i].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.types[i].nullSafeGet(rs, range, session, owner);
            if (val != null) {
                notNull = true;
            }
            values[i] = val;
            begin += length;
            ++i;
        }
        if (notNull) {
            Object result = this.instantiate(owner);
            int i2 = 0;
            while (i2 < this.propertySpan) {
                this.setters[i2].set(result, values[i2]);
                ++i2;
            }
            return result;
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        int i = 0;
        while (i < this.propertySpan) {
            this.types[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.types[i].getColumnSpan(session.getFactory());
            ++i;
        }
    }

    private Object[] nullSafeGetValues(Object value) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return this.getters[i].get(component);
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        Object[] values = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            values[i] = this.getPropertyValue(component, i);
            ++i;
        }
        return values;
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        int i = 0;
        while (i < this.propertySpan) {
            this.setters[i].set(component, values[i]);
            ++i;
        }
    }

    public Type[] getSubtypes() {
        return this.types;
    }

    public String getName() {
        return this.componentClass.getName();
    }

    public String toXML(Object value, SessionFactoryImplementor factory) {
        return value == null ? null : value.toString();
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object deepCopy(Object component) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component);
        int i = 0;
        while (i < this.propertySpan) {
            values[i] = this.types[i].deepCopy(values[i]);
            ++i;
        }
        Object result = this.instantiate(null);
        this.setPropertyValues(result, values);
        return result;
    }

    public Object instantiate(Object parent) throws HibernateException {
        try {
            Object inst = this.constructor.newInstance(null);
            if (this.parentSetter != null) {
                this.parentSetter.set(inst, parent);
            }
            return inst;
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate component ", this.componentClass, e);
        }
    }

    public Cascades.CascadeStyle cascade(int i) {
        return this.cascade[i];
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(value);
        int i = 0;
        while (i < this.types.length) {
            values[i] = this.types[i].disassemble(values[i], session);
            ++i;
        }
        return values;
    }

    public Object assemble(Serializable object, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        if (object == null) {
            return null;
        }
        Object[] values = (Object[])object;
        Object[] assembled = new Object[values.length];
        int i = 0;
        while (i < this.types.length) {
            assembled[i] = this.types[i].assemble((Serializable)values[i], session, owner);
            ++i;
        }
        Object result = this.instantiate(owner);
        this.setPropertyValues(result, assembled);
        return result;
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public int enableJoinedFetch(int i) {
        return this.joinedFetch[i];
    }
}

