/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.transaction;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.FlushMode;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.TransactionException;
import cirrus.hibernate.engine.SessionImplementor;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTATransaction
implements Transaction,
Synchronization {
    private final SessionImplementor session;
    private final UserTransaction ut;
    private final boolean newTransaction;
    private final boolean synchronization;
    static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$transaction$JTATransaction == null ? (class$cirrus$hibernate$transaction$JTATransaction = JTATransaction.class$("cirrus.hibernate.transaction.JTATransaction")) : class$cirrus$hibernate$transaction$JTATransaction));
    static /* synthetic */ Class class$cirrus$hibernate$transaction$JTATransaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HibernateException, SQLException {
        log.debug((Object)"commit");
        try {
            if (this.session.getFlushMode() != FlushMode.NEVER) {
                this.session.flush();
            }
            try {
                if (this.newTransaction) {
                    this.ut.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)"Commit failed", (Throwable)e);
                throw new TransactionException("Commit failed with exception: ", e);
            }
            Object var3_2 = null;
            if (!this.synchronization) {
                this.session.afterTransactionCompletion();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.synchronization) {
                this.session.afterTransactionCompletion();
            }
            throw throwable;
        }
    }

    public void rollback() throws HibernateException {
        log.debug((Object)"rollback");
        try {
            block7: {
                try {
                    if (this.newTransaction) {
                        this.ut.rollback();
                        break block7;
                    }
                    this.ut.setRollbackOnly();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failed", (Throwable)e);
                    throw new TransactionException("Rollback failed with exception: ", e);
                }
            }
            Object var3_1 = null;
            if (!this.synchronization) {
                this.session.afterTransactionCompletion();
            }
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!this.synchronization) {
                this.session.afterTransactionCompletion();
            }
            throw throwable;
        }
    }

    public JTATransaction(SessionImplementor session, InitialContext context, String utName, TransactionManager transactionManager) throws HibernateException {
        this.session = session;
        log.debug((Object)("Looking for UserTransaction under: " + utName));
        try {
            this.ut = (UserTransaction)context.lookup(utName);
        }
        catch (NamingException ne) {
            log.error((Object)"Could not find UserTransaction in JNDI", (Throwable)ne);
            throw new TransactionException("Could not find UserTransaction in JNDI: ", ne);
        }
        if (this.ut == null) {
            throw new AssertionFailure("A naming service lookup returned null");
        }
        log.debug((Object)"Obtained UserTransaction");
        try {
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                log.debug((Object)"beginning new transaction");
                this.ut.begin();
            }
        }
        catch (Exception e) {
            log.error((Object)"Begin failed", (Throwable)e);
            throw new TransactionException("Begin failed with exception: ", e);
        }
        if (transactionManager == null) {
            this.synchronization = false;
        } else {
            try {
                transactionManager.getTransaction().registerSynchronization((Synchronization)this);
            }
            catch (Exception se) {
                log.error((Object)"Could not register Synchronization", (Throwable)se);
                throw new TransactionException("Could not register Synchronization: ", se);
            }
            this.synchronization = true;
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status", null);
        }
        return status == 1 || status == 9 || status == 4;
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status", null);
        }
        return status == 3;
    }

    public void afterCompletion(int status) {
        log.trace((Object)"transaction completion callback");
        this.session.afterTransactionCompletion();
    }

    public void beforeCompletion() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

