/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.transaction;

import cirrus.hibernate.FlushMode;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.TransactionException;
import cirrus.hibernate.engine.SessionImplementor;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCTransaction
implements Transaction {
    private SessionImplementor session;
    private boolean toggleAutoCommit;
    private boolean rolledBack;
    private boolean committed;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$transaction$JDBCTransaction == null ? (class$cirrus$hibernate$transaction$JDBCTransaction = JDBCTransaction.class$("cirrus.hibernate.transaction.JDBCTransaction")) : class$cirrus$hibernate$transaction$JDBCTransaction));
    static /* synthetic */ Class class$cirrus$hibernate$transaction$JDBCTransaction;

    public JDBCTransaction(SessionImplementor session) throws HibernateException {
        this.session = session;
        this.begin();
    }

    private void begin() throws HibernateException {
        log.debug((Object)"begin");
        try {
            this.toggleAutoCommit = this.session.connection().getAutoCommit();
            if (this.toggleAutoCommit) {
                this.session.connection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Begin failed", (Throwable)e);
            throw new TransactionException("Begin failed with SQL exception: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HibernateException, SQLException {
        log.debug((Object)"commit");
        try {
            if (this.session.getFlushMode() != FlushMode.NEVER) {
                this.session.flush();
            }
            try {
                this.session.connection().commit();
                this.committed = true;
            }
            catch (SQLException e) {
                log.error((Object)"Commit failed", (Throwable)e);
                throw new TransactionException("Commit failed with SQL exception: ", e);
            }
            Object var3_2 = null;
            this.session.afterTransactionCompletion();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.session.afterTransactionCompletion();
            throw throwable;
        }
        this.toggleAutoCommit();
    }

    public void rollback() throws HibernateException {
        log.debug((Object)"rollback");
        try {
            try {
                this.session.connection().rollback();
                this.rolledBack = true;
            }
            catch (SQLException e) {
                log.error((Object)"Rollback failed", (Throwable)e);
                throw new TransactionException("Rollback failed with SQL exception: ", e);
            }
            Object var3_1 = null;
            this.session.afterTransactionCompletion();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.session.afterTransactionCompletion();
            throw throwable;
        }
        this.toggleAutoCommit();
    }

    private void toggleAutoCommit() {
        try {
            if (this.toggleAutoCommit) {
                this.session.connection().setAutoCommit(true);
            }
        }
        catch (Exception sqle) {
            log.error((Object)"Could not toggle autocommit", (Throwable)sqle);
        }
    }

    public boolean wasRolledBack() {
        return this.rolledBack;
    }

    public boolean wasCommitted() {
        return this.committed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

