/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.test;

import cirrus.hibernate.Query;
import cirrus.hibernate.Session;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.sql.DB2Dialect;
import cirrus.hibernate.sql.InterbaseDialect;
import cirrus.hibernate.sql.MySQLDialect;
import cirrus.hibernate.sql.SybaseDialect;
import cirrus.hibernate.test.Simple;
import cirrus.hibernate.test.TestCase;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SQLFunctionsTest
extends TestCase {
    static /* synthetic */ Class class$cirrus$hibernate$test$SQLFunctionsTest;

    public SQLFunctionsTest(String arg0) {
        super(arg0);
    }

    public void testSetProperties() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Simple simple = new Simple();
        simple.setName("Simple 1");
        s.save(simple, new Long(10L));
        Query q = s.createQuery("from s in class Simple where s.name=:name and s.count=:count");
        q.setProperties(simple);
        Assert.assertTrue((q.list().get(0) == simple ? 1 : 0) != 0);
        s.delete(simple);
        t.commit();
        s.close();
    }

    public void testSQLFunctions() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Simple simple = new Simple();
        simple.setName("Simple 1");
        s.save(simple, new Long(10L));
        if (TestCase.dialect instanceof DB2Dialect) {
            s.find("from s in class Simple where repeat('foo', 3) = 'foofoofoo'");
            s.find("from s in class Simple where repeat(s.name, 3) = 'foofoofoo'");
            s.find("from s in class Simple where repeat( lower(s.name), 3 + (1-1) / 2) = 'foofoofoo'");
        }
        Assert.assertTrue((s.find("from s in class Simple where upper( s.name ) ='SIMPLE 1'").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from s in class Simple where not( upper( s.name ) ='yada' or 1=2 or 'foo'='bar' or not('foo'='foo') or 'foo' like 'bar' )").size() == 1 ? 1 : 0) != 0);
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof SybaseDialect || TestCase.dialect instanceof InterbaseDialect)) {
            Assert.assertTrue((s.find("from s in class Simple where lower( s.name || ' foo' ) ='simple 1 foo'").size() == 1 ? 1 : 0) != 0);
        }
        if (TestCase.dialect instanceof SybaseDialect) {
            Assert.assertTrue((s.find("from s in class Simple where lower( s.name + ' foo' ) ='simple 1 foo'").size() == 1 ? 1 : 0) != 0);
        }
        Simple other = new Simple();
        other.setName("Simple 2");
        other.setCount(12);
        simple.setOther(other);
        s.save(other, new Long(20L));
        Assert.assertTrue((s.find("from s in class Simple where upper( s.other.name ) ='SIMPLE 2'").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from s in class Simple where not ( upper( s.other.name ) ='SIMPLE 2' )").size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select distinct s from s in class Simple where ( ( s.other.count + 3 ) = (15*2)/2 and s.count = 69) or ( ( s.other.count + 2 ) / 7 ) = 2").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select s from s in class Simple where ( ( s.other.count + 3 ) = (15*2)/2 and s.count = 69) or ( ( s.other.count + 2 ) / 7 ) = 2 order by s.other.count").size() == 1 ? 1 : 0) != 0);
        Simple min = new Simple();
        min.setCount(-1);
        s.save(min, new Long(30L));
        if (!(TestCase.dialect instanceof MySQLDialect)) {
            Assert.assertTrue((s.find("from s in class Simple where s.count > ( select min(sim.count) from sim in class cirrus.hibernate.test.Simple )").size() == 2 ? 1 : 0) != 0);
            t.commit();
            t = s.beginTransaction();
            Assert.assertTrue((s.find("from s in class Simple where s = some( select sim from sim in class cirrus.hibernate.test.Simple where sim.count>=0 ) and s.count >= 0").size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((s.find("from s in class Simple where s = some( select sim from sim in class cirrus.hibernate.test.Simple where sim.other.count=s.other.count ) and s.other.count > 0").size() == 1 ? 1 : 0) != 0);
        }
        Iterator iter = s.iterate("select sum(s.count) from s in class Simple group by s.count having sum(s.count) > 10");
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertTrue((boolean)new Integer(12).equals((Integer)iter.next()));
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        if (!(TestCase.dialect instanceof MySQLDialect)) {
            iter = s.iterate("select s.count from s in class Simple group by s.count having s.count = 12");
            Assert.assertTrue((boolean)iter.hasNext());
        }
        s.iterate("select s.id, s.count, count(t), max(t.date) from s in class Simple, t in class Simple where s.count = t.count group by s.id, s.count order by s.count");
        Query q = s.createQuery("from s in class Simple");
        q.setMaxResults(10);
        Assert.assertTrue((q.list().size() == 3 ? 1 : 0) != 0);
        q = s.createQuery("from s in class Simple");
        q.setMaxResults(1);
        q = s.createQuery("from s in class Simple where s.name = ?");
        q.setString(0, "Simple 1");
        Assert.assertTrue((q.list().size() == 1 ? 1 : 0) != 0);
        q = s.createQuery("from s in class Simple where s.name = ? and upper(s.name) = ?");
        q.setString(1, "SIMPLE 1");
        q.setString(0, "Simple 1");
        q.setFirstResult(0);
        Assert.assertTrue((boolean)q.iterate().hasNext());
        q = s.createQuery("from s in class Simple where s.name = :foo and upper(s.name) = :bar or s.count=:count or s.count=:count + 1");
        q.setParameter("bar", (Object)"SIMPLE 1");
        q.setString("foo", "Simple 1");
        q.setInteger("count", 69);
        q.setFirstResult(0);
        Assert.assertTrue((boolean)q.iterate().hasNext());
        q = s.createQuery("select s.id from s in class Simple");
        q.setFirstResult(1);
        q.setMaxResults(2);
        iter = q.iterate();
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)(iter.next() instanceof Long));
            ++i;
        }
        Assert.assertTrue((i == 2 ? 1 : 0) != 0);
        q = s.createQuery("select all s, s.other from s in class Simple where s = :s");
        q.setParameter("s", (Object)simple);
        Assert.assertTrue((q.list().size() == 1 ? 1 : 0) != 0);
        q = s.createQuery("from s in class Simple where s.name in (:name_list) and s.count > :count");
        HashSet<String> set = new HashSet<String>();
        set.add("Simple 1");
        set.add("foo");
        q.setParameterList("name_list", set);
        q.setParameter("count", (Object)new Integer(-1));
        Assert.assertTrue((q.list().size() == 1 ? 1 : 0) != 0);
        s.delete(other);
        s.delete(simple);
        s.delete(min);
        t.commit();
        s.close();
    }

    public static Test suite() throws Exception {
        TestCase.exportSchema(new String[]{"Simple.hbm.xml"});
        return new TestSuite(class$cirrus$hibernate$test$SQLFunctionsTest == null ? (class$cirrus$hibernate$test$SQLFunctionsTest = SQLFunctionsTest.class$("cirrus.hibernate.test.SQLFunctionsTest")) : class$cirrus$hibernate$test$SQLFunctionsTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

