/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.test;

import cirrus.hibernate.ObjectNotFoundException;
import cirrus.hibernate.Query;
import cirrus.hibernate.Session;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.sql.HSQLDialect;
import cirrus.hibernate.sql.MySQLDialect;
import cirrus.hibernate.sql.SAPDBDialect;
import cirrus.hibernate.sql.SybaseDialect;
import cirrus.hibernate.test.BasicNameable;
import cirrus.hibernate.test.Category;
import cirrus.hibernate.test.Custom;
import cirrus.hibernate.test.Detail;
import cirrus.hibernate.test.Master;
import cirrus.hibernate.test.Nameable;
import cirrus.hibernate.test.Several;
import cirrus.hibernate.test.Single;
import cirrus.hibernate.test.SubDetail;
import cirrus.hibernate.test.TestCase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MasterDetailTest
extends TestCase {
    static /* synthetic */ Class class$cirrus$hibernate$test$Single;
    static /* synthetic */ Class class$cirrus$hibernate$test$Several;
    static /* synthetic */ Class class$cirrus$hibernate$test$Master;
    static /* synthetic */ Class class$cirrus$hibernate$test$Detail;
    static /* synthetic */ Class class$cirrus$hibernate$test$Category;
    static /* synthetic */ Class class$cirrus$hibernate$test$Custom;
    static /* synthetic */ Class class$cirrus$hibernate$test$Nameable;
    static /* synthetic */ Class class$cirrus$hibernate$test$MasterDetailTest;

    public MasterDetailTest(String arg0) {
        super(arg0);
    }

    public void testNonLazyBidirectional() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Single sin = new Single();
        sin.setId("asdfds");
        sin.setString("adsa asdfasd");
        Several sev = new Several();
        sev.setId("asdfasdfasd");
        sev.setString("asd ddd");
        sin.getSeveral().add(sev);
        sev.setSingle(sin);
        s.save(sin);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        sin = (Single)s.load(class$cirrus$hibernate$test$Single == null ? (class$cirrus$hibernate$test$Single = MasterDetailTest.class$("cirrus.hibernate.test.Single")) : class$cirrus$hibernate$test$Single, (Serializable)sin);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        sev = (Several)s.load(class$cirrus$hibernate$test$Several == null ? (class$cirrus$hibernate$test$Several = MasterDetailTest.class$("cirrus.hibernate.test.Several")) : class$cirrus$hibernate$test$Several, (Serializable)sev);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        s.find("from s in class Several");
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        s.find("from s in class Single");
        t.commit();
        s.close();
    }

    public void testCollectionQuery() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        if (!(TestCase.dialect instanceof MySQLDialect) && !(TestCase.dialect instanceof SAPDBDialect)) {
            s.iterate("FROM m IN CLASS Master WHERE NOT EXISTS ( FROM d IN m.details.elements WHERE NOT d.i=5 )");
            s.iterate("FROM m IN CLASS Master WHERE NOT 5 IN ( SELECT d.i FROM d IN m.details.elements )");
        }
        s.iterate("SELECT m FROM m IN CLASS cirrus.hibernate.test.Master, d IN m.details.elements WHERE d.i=5");
        s.find("SELECT m FROM m IN CLASS cirrus.hibernate.test.Master, d IN m.details.elements WHERE d.i=5");
        s.findIdentifiers("SELECT m FROM m IN CLASS cirrus.hibernate.test.Master, d IN m.details.elements WHERE d.i=5");
        t.commit();
        s.close();
    }

    public void testMasterDetail() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Master master = new Master();
        this.assertTrue(s.save(master) != null, "save returned native id");
        Serializable mid = s.getIdentifier(master);
        Detail d1 = new Detail();
        d1.setMaster(master);
        Serializable did = s.save(d1);
        Detail d2 = new Detail();
        d2.setMaster(master);
        this.assertTrue(s.save(d2) != null, "generated id returned");
        master.addDetail(d1);
        master.addDetail(d2);
        if (!(TestCase.dialect instanceof MySQLDialect) && !(TestCase.dialect instanceof SAPDBDialect)) {
            this.assertTrue(s.find("from d in class cirrus.hibernate.test.Detail, m in class cirrus.hibernate.test.Master where m = d.master and m.outgoing.size = 0 and m.incoming.size = 0").size() == 2, "query");
        }
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        master = (Master)s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid);
        Iterator iter = master.getDetails().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Detail d = (Detail)iter.next();
            this.assertTrue(d.getMaster() == master, "master-detail");
            ++i;
        }
        this.assertTrue(i == 2, "master-detail");
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        Detail dd = (Detail)s.load(class$cirrus$hibernate$test$Detail == null ? (class$cirrus$hibernate$test$Detail = MasterDetailTest.class$("cirrus.hibernate.test.Detail")) : class$cirrus$hibernate$test$Detail, did);
        master = dd.getMaster();
        this.assertTrue(master.getDetails().contains(dd), "detail-master");
        Assert.assertTrue((s.filter(master.getDetails(), "order by this.i desc").size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.filter(master.getDetails(), "select this where this.id > 0").size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.filter(master.getDetails(), "where this.id > 0").size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.filter(master.getDetails(), "select this.master where this.id > 0").size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.filter(master.getDetails(), "select m from m in class Master where this.id > 0 and this.master=m").size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.filter(master.getIncoming(), "where this.id > 0 and this.name is not null").size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(s.createFilter(master.getDetails(), "select max(this.i)").iterate().next() instanceof Integer));
        Assert.assertTrue((boolean)(s.createFilter(master.getDetails(), "select max(this.i) group by this.id").iterate().next() instanceof Integer));
        Assert.assertTrue((boolean)(s.createFilter(master.getDetails(), "select count(*)").iterate().next() instanceof Integer));
        Assert.assertTrue((s.createFilter(master.getDetails(), "select this.master").list().size() == 2 ? 1 : 0) != 0);
        iter = master.getDetails().iterator();
        i = 0;
        while (iter.hasNext()) {
            Detail d = (Detail)iter.next();
            this.assertTrue(d.getMaster() == master, "master-detail");
            s.delete(d);
            ++i;
        }
        this.assertTrue(i == 2, "master-detail");
        s.delete(master);
        t.commit();
        s.close();
    }

    public void testIncomingOutgoing() throws Exception {
        Session s = TestCase.sessions.openSession();
        Master master1 = new Master();
        Master master2 = new Master();
        Master master3 = new Master();
        s.save(master1);
        s.save(master2);
        s.save(master3);
        master1.addIncoming(master2);
        master2.addOutgoing(master1);
        master1.addIncoming(master3);
        master3.addOutgoing(master1);
        Serializable m1id = s.getIdentifier(master1);
        Assert.assertTrue((s.filter(master1.getIncoming(), "where this.id > 0 and this.name is not null").size() == 2 ? 1 : 0) != 0);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        master1 = (Master)s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, m1id);
        Iterator iter = master1.getIncoming().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Master m = (Master)iter.next();
            this.assertTrue(m.getOutgoing().size() == 1, "outgoing");
            this.assertTrue(m.getOutgoing().contains(master1), "outgoing");
            s.delete(m);
            ++i;
        }
        this.assertTrue(i == 2, "incoming-outgoing");
        s.delete(master1);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCascading() throws Exception {
        Session s = TestCase.sessions.openSession();
        Detail d1 = new Detail();
        Detail d2 = new Detail();
        Master m = new Master();
        Master m0 = new Master();
        Serializable m0id = s.save(m0);
        m0.addDetail(d1);
        m0.addDetail(d2);
        d1.setMaster(m0);
        d2.setMaster(m0);
        m.getMoreDetails().add(d1);
        m.getMoreDetails().add(d2);
        Serializable mid = s.save(m);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        m = (Master)s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid);
        this.assertTrue(m.getMoreDetails().size() == 2, "cascade save");
        this.assertTrue(((Detail)m.getMoreDetails().iterator().next()).getMaster().getDetails().size() == 2, "cascade save");
        s.delete(m);
        s.delete(s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, m0id));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testNamedQuery() throws Exception {
        Session s = TestCase.sessions.openSession();
        Query q = s.getNamedQuery("all_details");
        q.list();
        s.connection().commit();
        s.close();
    }

    public void testSerialization() throws Exception {
        Session s = TestCase.sessions.openSession();
        Master m = new Master();
        Detail d1 = new Detail();
        Detail d2 = new Detail();
        Serializable mid = s.save(m);
        d1.setMaster(m);
        d2.setMaster(m);
        m.addDetail(d1);
        m.addDetail(d2);
        if (TestCase.dialect instanceof SybaseDialect) {
            s.save(d1);
        } else if (TestCase.dialect instanceof HSQLDialect) {
            s.save(d1, new Integer(666));
        } else {
            s.save(d1, new Long(666L));
        }
        s.flush();
        s.connection().commit();
        s.disconnect();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        new ObjectOutputStream(os).writeObject(s);
        byte[] bytes = os.toByteArray();
        System.out.println(bytes.length);
        s = (Session)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        s.reconnect();
        Master m2 = (Master)s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid);
        this.assertTrue(m2.getDetails().size() == 2, "serialized state");
        Iterator iter = m2.getDetails().iterator();
        while (iter.hasNext()) {
            Detail d = (Detail)iter.next();
            this.assertTrue(d.getMaster() == m2, "deserialization");
            try {
                s.getIdentifier(d);
                s.delete(d);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        s.delete(m2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        mid = s.save(new Master());
        Serializable mid2 = s.save(new Master());
        s.flush();
        s.connection().commit();
        s.disconnect();
        os = new ByteArrayOutputStream();
        new ObjectOutputStream(os).writeObject(s);
        bytes = os.toByteArray();
        System.out.println(bytes.length);
        s = (Session)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        s.reconnect();
        s.delete(s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid));
        s.delete(s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid2));
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.connection();
        try {
            os = new ByteArrayOutputStream();
            new ObjectOutputStream(os).writeObject(s);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"illegal state", (boolean)(e instanceof IllegalStateException));
            s.connection().commit();
            s.close();
            return;
        }
        this.assertTrue(false, "serialization should have failed");
    }

    public void testUpdateLazyCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Master m = new Master();
        Detail d1 = new Detail();
        Detail d2 = new Detail();
        Serializable mid = s.save(m);
        d1.setMaster(m);
        d2.setMaster(m);
        m.addDetail(d1);
        m.addDetail(d2);
        if (TestCase.dialect instanceof SybaseDialect) {
            s.save(d1);
            s.save(d2);
        } else if (TestCase.dialect instanceof HSQLDialect) {
            s.save(d1, new Integer(666));
            s.save(d2, new Integer(667));
        } else {
            s.save(d1, new Long(666L));
            s.save(d2, new Long(667L));
        }
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        m = (Master)s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid);
        s.connection().commit();
        s.close();
        m.setName("New Name");
        s = TestCase.sessions.openSession();
        s.update(m, mid);
        Iterator iter = m.getDetails().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertTrue((iter.next() != null ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((i == 2 ? 1 : 0) != 0);
        iter = m.getDetails().iterator();
        while (iter.hasNext()) {
            s.delete(iter.next());
        }
        s.delete(m);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testMultiLevelCascade() throws Exception {
        Session s = TestCase.sessions.openSession();
        Detail detail = new Detail();
        SubDetail subdetail = new SubDetail();
        Master m = new Master();
        Master m0 = new Master();
        Serializable m0id = s.save(m0);
        m0.addDetail(detail);
        detail.setMaster(m0);
        m.getMoreDetails().add(detail);
        detail.setSubDetails(new HashSet());
        detail.getSubDetails().add(subdetail);
        Serializable mid = s.save(m);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        m = (Master)s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, mid);
        Assert.assertTrue((((Detail)m.getMoreDetails().iterator().next()).getSubDetails().size() != 0 ? 1 : 0) != 0);
        s.delete(m);
        Assert.assertTrue((s.find("from sd in class SubDetail").size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from d in class Detail").size() == 0 ? 1 : 0) != 0);
        s.delete(s.load(class$cirrus$hibernate$test$Master == null ? (class$cirrus$hibernate$test$Master = MasterDetailTest.class$("cirrus.hibernate.test.Master")) : class$cirrus$hibernate$test$Master, m0id));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCategories() throws Exception {
        Session s = TestCase.sessions.openSession();
        Category c = new Category();
        c.setName("/");
        Category c1 = new Category();
        Category c2 = new Category();
        Category c3 = new Category();
        c.getSubcategories().add(c1);
        c.getSubcategories().add(c2);
        c2.getSubcategories().add(null);
        c2.getSubcategories().add(c3);
        s.save(c);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        c = (Category)s.load(class$cirrus$hibernate$test$Category == null ? (class$cirrus$hibernate$test$Category = MasterDetailTest.class$("cirrus.hibernate.test.Category")) : class$cirrus$hibernate$test$Category, (Serializable)new Long(c.getId()));
        System.out.println(c.getSubcategories());
        Assert.assertTrue((c.getSubcategories().get(0) != null && c.getSubcategories().get(1) != null ? 1 : 0) != 0);
        List list = ((Category)c.getSubcategories().get(1)).getSubcategories();
        Assert.assertTrue((list.get(1) != null && list.get(0) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.iterate("from c in class Category where c.name = cirrus.hibernate.test.Category.ROOT_CATEGORY").hasNext());
        s.connection().commit();
        s.close();
    }

    public void testCustomPersister() throws Exception {
        Session s = TestCase.sessions.openSession();
        Custom c = new Custom();
        c.name = "foo";
        c.id = 100L;
        Long id = (Long)s.save(c);
        Assert.assertTrue((c == s.load(class$cirrus$hibernate$test$Custom == null ? (class$cirrus$hibernate$test$Custom = MasterDetailTest.class$("cirrus.hibernate.test.Custom")) : class$cirrus$hibernate$test$Custom, (Serializable)id) ? 1 : 0) != 0);
        s.flush();
        s.close();
        s = TestCase.sessions.openSession();
        c = (Custom)s.load(class$cirrus$hibernate$test$Custom == null ? (class$cirrus$hibernate$test$Custom = MasterDetailTest.class$("cirrus.hibernate.test.Custom")) : class$cirrus$hibernate$test$Custom, (Serializable)id);
        Assert.assertTrue((boolean)c.name.equals("foo"));
        c.name = "bar";
        s.flush();
        s.close();
        s = TestCase.sessions.openSession();
        c = (Custom)s.load(class$cirrus$hibernate$test$Custom == null ? (class$cirrus$hibernate$test$Custom = MasterDetailTest.class$("cirrus.hibernate.test.Custom")) : class$cirrus$hibernate$test$Custom, (Serializable)id);
        Assert.assertTrue((boolean)c.name.equals("bar"));
        s.delete(c);
        s.flush();
        s.close();
        s = TestCase.sessions.openSession();
        boolean none = false;
        try {
            s.load(class$cirrus$hibernate$test$Custom == null ? (class$cirrus$hibernate$test$Custom = MasterDetailTest.class$("cirrus.hibernate.test.Custom")) : class$cirrus$hibernate$test$Custom, (Serializable)id);
        }
        catch (ObjectNotFoundException onfe) {
            none = true;
        }
        Assert.assertTrue((boolean)none);
        s.close();
    }

    public void testInterface() throws Exception {
        Session s = TestCase.sessions.openSession();
        Serializable id = s.save(new BasicNameable());
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Nameable n = (Nameable)s.load(class$cirrus$hibernate$test$Nameable == null ? (class$cirrus$hibernate$test$Nameable = MasterDetailTest.class$("cirrus.hibernate.test.Nameable")) : class$cirrus$hibernate$test$Nameable, id);
        s.delete(n);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public static Test suite() throws Exception {
        TestCase.exportSchema(new String[]{"MasterDetail.hbm.xml", "Custom.hbm.xml", "Category.hbm.xml", "Nameable.hbm.xml", "SingleSeveral.hbm.xml"});
        return new TestSuite(class$cirrus$hibernate$test$MasterDetailTest == null ? (class$cirrus$hibernate$test$MasterDetailTest = MasterDetailTest.class$("cirrus.hibernate.test.MasterDetailTest")) : class$cirrus$hibernate$test$MasterDetailTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

