/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.sql;

import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.loader.OracleOuterJoinGenerator;
import cirrus.hibernate.loader.OuterJoinGenerator;
import cirrus.hibernate.sql.Dialect;

public class SAPDBDialect
extends Dialect {
    private final OuterJoinGenerator outerJoinGenerator;

    public SAPDBDialect() {
        this.register(-7, "BOOLEAN");
        this.register(-5, "FIXED(19,0)");
        this.register(5, "SMALLINT");
        this.register(-6, "FIXED(3,0)");
        this.register(4, "INT");
        this.register(1, "CHAR(1)");
        this.register(12, "VARCHAR($l)");
        this.register(6, "FLOAT");
        this.register(8, "DOUBLE PRECISION");
        this.register(91, "DATE");
        this.register(92, "TIME");
        this.register(93, "TIMESTAMP");
        this.register(-3, "LONG BYTE");
        this.register(2, "FIXED(19,$l)");
        this.register(2005, "LONG VARCHAR");
        this.register(2004, "LONG BYTE");
        this.outerJoinGenerator = new OracleOuterJoinGenerator();
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" foreign key ").append(constraintName).append(" (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    public String getNullColumnString() {
        return " null";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getQuerySequencesString() {
        return "select SEQUENCE_NAME from DOMAIN.SEQUENCES";
    }

    public OuterJoinGenerator getOuterJoinGenerator() {
        return this.outerJoinGenerator;
    }
}

