/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.sql;

import cirrus.hibernate.loader.OracleOuterJoinGenerator;
import cirrus.hibernate.loader.OuterJoinGenerator;
import cirrus.hibernate.sql.Dialect;

public class OracleDialect
extends Dialect {
    private final OuterJoinGenerator outerJoinGenerator;

    public OracleDialect() {
        this.register(-7, "NUMBER(1,0)");
        this.register(-5, "NUMBER(19,0)");
        this.register(5, "NUMBER(5,0)");
        this.register(-6, "NUMBER(3,0)");
        this.register(4, "NUMBER(10,0)");
        this.register(1, "CHAR(1)");
        this.register(12, "VARCHAR2($l)");
        this.register(6, "FLOAT");
        this.register(8, "DOUBLE PRECISION");
        this.register(91, "DATE");
        this.register(92, "DATE");
        this.register(93, "DATE");
        this.register(-3, "RAW($l)");
        this.register(2, "NUMBER(19, $l)");
        this.register(2004, "BLOB");
        this.register(2005, "CLOB");
        this.outerJoinGenerator = new OracleOuterJoinGenerator();
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public OuterJoinGenerator getOuterJoinGenerator() {
        return this.outerJoinGenerator;
    }

    public boolean supportsForUpdateNowait() {
        return true;
    }
}

