/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.query;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.persister.Queryable;
import cirrus.hibernate.query.Parser;
import cirrus.hibernate.query.PathExpressionParser;
import cirrus.hibernate.query.QueryTranslator;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.LiteralType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class WhereParser
implements Parser {
    private PathExpressionParser pathExpressionParser = new PathExpressionParser();
    private static final Set expressionTerminators = new HashSet();
    private static final Set expressionOpeners = new HashSet();
    private static final Set booleanOperators = new HashSet();
    private static final Map negations = new HashMap();
    private boolean quoted = false;
    private boolean betweenSpecialCase = false;
    private int bracketsSinceFunction = 0;
    private boolean negated = false;
    private boolean inSubselect = false;
    private int bracketsSinceSelect = 0;
    private StringBuffer subselect;
    private boolean expectingPathContinuation = false;
    private int expectingIndex = 0;
    private LinkedList nots = new LinkedList();
    private LinkedList joins = new LinkedList();
    private LinkedList booleanTests = new LinkedList();
    private String collectionJoin;

    private String getElementName(PathExpressionParser.CollectionElement element, QueryTranslator q) throws QueryException {
        String name;
        if (element.isOneToMany) {
            name = element.alias;
        } else {
            Type type = element.type;
            if (type.isEntityType()) {
                Class clazz = ((EntityType)type).getPersistentClass();
                name = this.pathExpressionParser.continueFromManyToMany(clazz, element.elementColumns, q);
            } else if (type.isPersistentCollectionType()) {
                String role = ((PersistentCollectionType)type).getRole();
                name = this.pathExpressionParser.continueFromSubcollection(role, element.elementColumns, q);
            } else {
                throw new QueryException("illegally dereferenced collection element");
            }
        }
        return name;
    }

    public void token(String token, QueryTranslator q) throws QueryException {
        String lcToken = token.toLowerCase();
        if (token.equals("[") && !this.expectingPathContinuation) {
            this.expectingPathContinuation = false;
            if (this.expectingIndex == 0) {
                throw new QueryException("unexpected [");
            }
            return;
        }
        if (token.equals("]")) {
            --this.expectingIndex;
            this.expectingPathContinuation = true;
            return;
        }
        if (this.expectingPathContinuation) {
            this.expectingPathContinuation = false;
            PathExpressionParser.CollectionElement element = this.pathExpressionParser.lastCollectionElement();
            if (token.startsWith(".")) {
                this.doPathExpression(this.getElementName(element, q) + token, q);
                this.addToCurrentJoin(element.join);
                this.addToCurrentJoin(element.indexValue.toString());
                return;
            }
            if (token.equals("[")) {
                this.doPathExpression(this.getElementName(element, q), q);
                this.addToCurrentJoin(element.join);
                this.addToCurrentJoin(element.indexValue.toString());
                return;
            }
            if (element.elementColumns.length != 1) {
                throw new QueryException("path expression ended in composite collection element");
            }
            this.appendToken(q, element.elementColumns[0]);
            this.addToCurrentJoin(element.join);
            this.addToCurrentJoin(element.indexValue.toString());
        }
        if (!this.inSubselect && (lcToken.equals("select") || lcToken.equals("from"))) {
            this.inSubselect = true;
            this.subselect = new StringBuffer(20);
        }
        if (this.inSubselect && token.equals(")")) {
            --this.bracketsSinceSelect;
            if (this.bracketsSinceSelect == -1) {
                QueryTranslator subq = new QueryTranslator();
                try {
                    subq.compile(q, this.subselect.toString());
                }
                catch (MappingException me) {
                    throw new QueryException("MappingException occurred compiling subquery", (Exception)((Object)me));
                }
                this.appendToken(q, subq.getScalarSelectSQL());
                this.inSubselect = false;
                this.bracketsSinceSelect = 0;
            }
        }
        if (this.inSubselect) {
            if (token.equals("(")) {
                ++this.bracketsSinceSelect;
            }
            this.subselect.append(token).append(' ');
            return;
        }
        this.specialCasesBefore(lcToken);
        if (!this.betweenSpecialCase && expressionTerminators.contains(lcToken)) {
            this.closeExpression(q, lcToken);
        }
        if (booleanOperators.contains(lcToken)) {
            this.booleanTests.removeLast();
            this.booleanTests.addLast(Boolean.TRUE);
        }
        if (lcToken.equals("not")) {
            this.nots.addLast(new Boolean((Boolean)this.nots.removeLast() == false));
            this.negated = !this.negated;
            return;
        }
        this.doToken(token, q);
        if (!this.betweenSpecialCase && expressionOpeners.contains(lcToken)) {
            this.openExpression(q, lcToken);
        }
        this.specialCasesAfter(lcToken);
    }

    public void start(QueryTranslator q) throws QueryException {
        this.token("(", q);
    }

    public void end(QueryTranslator q) throws QueryException {
        if (this.expectingPathContinuation) {
            this.expectingPathContinuation = false;
            PathExpressionParser.CollectionElement element = this.pathExpressionParser.lastCollectionElement();
            if (element.elementColumns.length != 1) {
                throw new QueryException("path expression ended in composite collection element");
            }
            this.appendToken(q, element.elementColumns[0]);
            this.addToCurrentJoin(element.join);
            this.addToCurrentJoin(element.indexValue.toString());
        }
        this.token(")", q);
    }

    private void closeExpression(QueryTranslator q, String lcToken) {
        if (((Boolean)this.booleanTests.removeLast()).booleanValue()) {
            if (this.booleanTests.size() > 0) {
                this.booleanTests.removeLast();
                this.booleanTests.addLast(Boolean.TRUE);
            }
            this.appendToken(q, ((StringBuffer)this.joins.removeLast()).toString());
        } else {
            StringBuffer join = (StringBuffer)this.joins.removeLast();
            ((StringBuffer)this.joins.getLast()).append(join.toString());
        }
        if (((Boolean)this.nots.removeLast()).booleanValue()) {
            boolean bl = this.negated = !this.negated;
        }
        if (!")".equals(lcToken)) {
            this.appendToken(q, ")");
        }
    }

    private void openExpression(QueryTranslator q, String lcToken) {
        this.nots.addLast(Boolean.FALSE);
        this.booleanTests.addLast(Boolean.FALSE);
        this.joins.addLast(new StringBuffer());
        if (!"(".equals(lcToken)) {
            this.appendToken(q, "(");
        }
    }

    private void doPathExpression(String token, QueryTranslator q) throws QueryException {
        StringTokenizer tokens = new StringTokenizer(token, ".", true);
        this.pathExpressionParser.start(q);
        while (tokens.hasMoreTokens()) {
            this.pathExpressionParser.token(tokens.nextToken(), q);
        }
        this.pathExpressionParser.end(q);
        if (this.pathExpressionParser.isCollectionValued()) {
            this.openExpression(q, "");
            this.appendToken(q, this.pathExpressionParser.getCollectionSubquery(this.collectionJoin));
            q.addIdentifierSpace((Serializable)((Object)this.pathExpressionParser.getCollectionTable()));
            this.closeExpression(q, "");
            this.collectionJoin = null;
        } else if (this.pathExpressionParser.isExpectingCollectionIndex()) {
            ++this.expectingIndex;
        } else {
            this.addToCurrentJoin(this.pathExpressionParser.getWhereJoin());
            this.appendToken(q, this.pathExpressionParser.getWhereColumn());
        }
    }

    private void doToken(String token, QueryTranslator q) throws QueryException {
        if (q.isName(StringHelper.root(token))) {
            this.doPathExpression(token, q);
        } else if (token.startsWith(":")) {
            q.addNamedParameter(token.substring(1));
            this.appendToken(q, "?");
        } else {
            Queryable p = q.getPersister(token);
            if (p != null) {
                this.appendToken(q, p.getDiscriminatorSQLString());
            } else {
                String negatedToken;
                Object constant;
                if (token.indexOf(46) > -1 && (constant = ReflectHelper.getConstantValue(token)) != null) {
                    Type type;
                    try {
                        type = TypeFactory.hueristicType(constant.getClass().getName());
                    }
                    catch (MappingException me) {
                        throw new QueryException((Exception)((Object)me));
                    }
                    if (type == null) {
                        throw new QueryException("Could not determine type of: " + token);
                    }
                    try {
                        this.appendToken(q, ((LiteralType)((Object)type)).objectToSQLString(constant));
                    }
                    catch (Exception e) {
                        throw new QueryException("Could not format constant value to SQL literal: " + token, e);
                    }
                }
                String string = negatedToken = this.negated ? (String)negations.get(token.toLowerCase()) : null;
                if (!(negatedToken == null || this.betweenSpecialCase && "or".equals(negatedToken))) {
                    this.appendToken(q, negatedToken);
                } else {
                    this.appendToken(q, token);
                }
            }
        }
    }

    private void addToCurrentJoin(String sql) {
        ((StringBuffer)this.joins.getLast()).append(sql);
    }

    private void specialCasesBefore(String lcToken) {
        if (lcToken.equals("between") || lcToken.equals("not between")) {
            this.betweenSpecialCase = true;
        }
    }

    private void specialCasesAfter(String lcToken) {
        if (this.betweenSpecialCase && lcToken.equals("and")) {
            this.betweenSpecialCase = false;
        }
    }

    void appendToken(QueryTranslator q, String token) {
        if (this.expectingIndex > 0) {
            this.pathExpressionParser.setLastCollectionElementIndexValue(token);
        } else {
            q.appendWhereToken(token);
        }
    }

    static {
        expressionTerminators.add("and");
        expressionTerminators.add("or");
        expressionTerminators.add(")");
        expressionOpeners.add("and");
        expressionOpeners.add("or");
        expressionOpeners.add("(");
        booleanOperators.add("<");
        booleanOperators.add("=");
        booleanOperators.add(">");
        booleanOperators.add("#");
        booleanOperators.add("~");
        booleanOperators.add("like");
        booleanOperators.add("is");
        booleanOperators.add("in");
        booleanOperators.add("any");
        booleanOperators.add("some");
        booleanOperators.add("all");
        booleanOperators.add("exists");
        booleanOperators.add("between");
        booleanOperators.add("<=");
        booleanOperators.add(">=");
        booleanOperators.add("=>");
        booleanOperators.add("=<");
        booleanOperators.add("!=");
        booleanOperators.add("<>");
        booleanOperators.add("!#");
        booleanOperators.add("!~");
        booleanOperators.add("!<");
        booleanOperators.add("!>");
        booleanOperators.add("is not");
        booleanOperators.add("not like");
        booleanOperators.add("not in");
        booleanOperators.add("not between");
        booleanOperators.add("not exists");
        negations.put("and", "or");
        negations.put("or", "and");
        negations.put("<", ">=");
        negations.put("=", "<>");
        negations.put(">", "<=");
        negations.put("#", "!#");
        negations.put("~", "!~");
        negations.put("like", "not like");
        negations.put("is", "is not");
        negations.put("in", "not in");
        negations.put("exists", "not exists");
        negations.put("between", "not between");
        negations.put("<=", ">");
        negations.put(">=", "<");
        negations.put("=>", "<");
        negations.put("=<", ">");
        negations.put("!=", "=");
        negations.put("<>", "=");
        negations.put("!#", "#");
        negations.put("!~", "~");
        negations.put("!<", ">=");
        negations.put("!>", "<=");
        negations.put("is not", "is");
        negations.put("not like", "like");
        negations.put("not in", "in");
        negations.put("not between", "between");
        negations.put("not exists", "exists");
    }
}

