/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.id.Assigned;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.ForeignKey;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Value {
    private final ArrayList columns = new ArrayList();
    private Type type;
    private IdentifierGenerator generator = Assigned.INSTANCE;
    private String nullValue;
    private Table table;

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public List getConstraintColumns() {
        return this.columns;
    }

    public Type getType() {
        return this.type;
    }

    void setType(Type type) {
        this.type = type;
        Iterator iter = this.getColumnIterator();
        int count = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            col.setType(type);
            col.setTypeIndex(count++);
        }
    }

    void setTable(Table table) {
        this.table = table;
    }

    protected Value() {
    }

    public Value(Type type, Table table, String columnName) {
        this.type = type;
        Column column = new Column(type, 0);
        column.setName(columnName);
        table.addColumn(column);
        this.addColumn(column);
    }

    public Value(Node node, String path, boolean isNullable, Table table, Root root) throws MappingException {
        this.table = table;
        NamedNodeMap atts = node.getAttributes();
        this.type = this.typeFromXML(node, path, root);
        Node columnName = atts.getNamedItem("column");
        if (columnName == null) {
            NodeList list = node.getChildNodes();
            int count = 0;
            int i = 0;
            while (i < list.getLength()) {
                Node subnode = list.item(i);
                String name = subnode.getNodeName();
                if ("column".equals(name)) {
                    Node uniqueNode;
                    Column col = new Column(subnode, isNullable, this.type, count++);
                    col.setName(subnode.getAttributes().getNamedItem("name").getNodeValue());
                    if (table != null) {
                        table.addColumn(col);
                    }
                    this.addColumn(col);
                    Node indexNode = subnode.getAttributes().getNamedItem("index");
                    if (indexNode != null && table != null) {
                        String iname = indexNode.getNodeValue();
                        table.getIndex(iname).addColumn(col);
                    }
                    if ((uniqueNode = subnode.getAttributes().getNamedItem("unique-key")) != null && table != null) {
                        String iname = uniqueNode.getNodeValue();
                        table.getUniqueKey(iname).addColumn(col);
                    }
                }
                ++i;
            }
        } else {
            Column col = new Column(node, isNullable, this.type, 0);
            col.setName(columnName.getNodeValue());
            if (table != null) {
                table.addColumn(col);
            }
            this.addColumn(col);
        }
    }

    public void createForeignKeys(Root root, Table table) {
    }

    public void createForeignKeyOfClass(Root root, Table table, Class persistentClass) {
        ForeignKey fk = table.createForeignKey(this.getConstraintColumns());
        fk.setReferencedClass(persistentClass);
    }

    public Value(Node node, String path, String defaultColumnName, boolean isNullable, Table table, Root root) throws MappingException {
        this(node, path, isNullable, table, root);
        if (this.getColumnSpan() == 0) {
            Column col = new Column(node, isNullable, this.type, 0);
            col.setName(defaultColumnName);
            table.addColumn(col);
            this.addColumn(col);
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node subnode = list.item(i);
            if ("generator".equals(subnode.getNodeName())) {
                try {
                    this.generator = root.createIDGenerator(subnode);
                }
                catch (Exception e) {
                    throw new MappingException("Error creating ID generator", e);
                }
                if (table != null) {
                    table.setIdentifierGenerator(this.generator);
                }
            }
            ++i;
        }
        Node nullValueNode = node.getAttributes().getNamedItem("unsaved-value");
        if (nullValueNode != null) {
            this.nullValue = nullValueNode.getNodeValue();
        }
    }

    protected Type typeFromXML(Node node, String path, Root root) throws MappingException {
        return Value.getTypeFromXML(node, path, root);
    }

    static Type getTypeFromXML(Node node, String path, Root root) throws MappingException {
        Type type;
        NamedNodeMap atts = node.getAttributes();
        Node roleNode = atts.getNamedItem("role");
        if (roleNode != null) {
            type = root.getCollectionType(path + '/' + roleNode.getNodeValue());
        } else {
            Node typeNode = atts.getNamedItem("type");
            if (typeNode == null) {
                return null;
            }
            type = TypeFactory.hueristicType(typeNode.getNodeValue());
            if (type == null) {
                throw new MappingException("Could not interpret type: " + typeNode.getNodeValue());
            }
        }
        return type;
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
        try {
            if (this.type == null) {
                this.type = ReflectHelper.reflectedPropertyType(propertyClass, propertyName);
                Iterator iter = this.getColumnIterator();
                int count = 0;
                while (iter.hasNext()) {
                    Column col = (Column)iter.next();
                    col.setType(this.type);
                    col.setTypeIndex(count++);
                }
            }
        }
        catch (HibernateException he) {
            throw new MappingException("Problem trying to set property type by reflection", (Throwable)((Object)he));
        }
    }

    public int enableJoinedFetch() {
        return 0;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.generator;
    }

    public boolean isComposite() {
        return false;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Table getTable() {
        return this.table;
    }
}

