/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.map.Association;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.type.AssociationType;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OneToOne
extends Association {
    private boolean constrained;
    private AssociationType.ForeignKeyType foreignKeyType;
    private Value identifier;

    public OneToOne(Node node, Value identifier, String path, boolean isNullable, Table table, Root root) throws MappingException {
        super(node, path, isNullable, table, root);
        this.identifier = identifier;
    }

    protected Type typeFromXML(Node node, String path, Root root) throws MappingException {
        NamedNodeMap atts = node.getAttributes();
        Node constrNode = atts.getNamedItem("constrained");
        this.constrained = constrNode != null && constrNode.getNodeValue().equals("true");
        this.foreignKeyType = this.constrained ? AssociationType.FOREIGN_KEY_FROM_PARENT : AssociationType.FOREIGN_KEY_TO_PARENT;
        Node typeNode = atts.getNamedItem("class");
        if (typeNode == null) {
            return null;
        }
        try {
            return TypeFactory.oneToOne(ReflectHelper.classForName(typeNode.getNodeValue()), this.foreignKeyType);
        }
        catch (Exception e) {
            throw new MappingException("Could not find class: " + typeNode.getNodeValue());
        }
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
        try {
            if (this.getType() == null) {
                this.setType(TypeFactory.oneToOne(ReflectHelper.getGetter(propertyClass, propertyName).getReturnType(), this.foreignKeyType));
            }
        }
        catch (HibernateException he) {
            throw new MappingException("Problem trying to set association type by reflection", (Throwable)((Object)he));
        }
    }

    public void createForeignKeys(Root root, Table table) {
        if (this.constrained) {
            this.createForeignKeyOfClass(root, table, ((EntityType)this.getType()).getPersistentClass());
        }
    }

    public List getConstraintColumns() {
        ArrayList list = new ArrayList();
        Iterator iter = this.identifier.getColumnIterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }
}

