/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.Environment;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.cache.CacheConcurrencyStrategy;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.map.Bag;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.Index;
import cirrus.hibernate.map.ManyToOne;
import cirrus.hibernate.map.OneToMany;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.type.PersistentCollectionType;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Collection {
    private static final String DEFAULT_ELEMENT_COLUMN_NAME = "elt";
    private static final String DEFAULT_KEY_COLUMN_NAME = "id";
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$map$Collection == null ? (class$cirrus$hibernate$map$Collection = Collection.class$("cirrus.hibernate.map.Collection")) : class$cirrus$hibernate$map$Collection));
    private Value key;
    private Value element;
    private Table table;
    private final String role;
    private boolean lazy;
    private boolean isOneToMany;
    private final boolean toplevel;
    private boolean readonly;
    private OneToMany oneToMany;
    private CacheConcurrencyStrategy cache;
    private String orderBy;
    protected Node node;
    private PersistentClass owner;
    protected Root root;
    private boolean doneSecondPass;
    static /* synthetic */ Class class$cirrus$hibernate$map$Collection;

    public boolean isSet() {
        return false;
    }

    public String getOrderByString() {
        return this.orderBy;
    }

    public Value getKey() {
        return this.key;
    }

    public Value getElement() {
        return this.element;
    }

    public boolean isIndexed() {
        return false;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Collection(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
        Node lazyNode;
        Node orderNode;
        this.node = node;
        this.owner = owner;
        this.root = root;
        NamedNodeMap atts = node.getAttributes();
        String barerole = atts.getNamedItem("role").getNodeValue();
        this.role = prefix + '/' + barerole;
        this.toplevel = owner == null;
        Node readonlyNode = atts.getNamedItem("readonly");
        if (readonlyNode != null) {
            this.readonly = StringHelper.booleanValue(readonlyNode.getNodeValue());
        }
        if ((orderNode = atts.getNamedItem("order-by")) != null) {
            if (Environment.jvmSupportsLinkedHashCollections() || this instanceof Bag) {
                this.orderBy = orderNode.getNodeValue();
            } else {
                log.warn((Object)"Attribute \"order-by\" ignored in JDK1.3 or less");
            }
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String name = list.item(i).getNodeName();
            if ("one-to-many".equals(name)) {
                this.isOneToMany = true;
                this.oneToMany = new OneToMany(list.item(i), owner);
            }
            ++i;
        }
        if (!this.isOneToMany) {
            Node tableNode = atts.getNamedItem("table");
            String tableName = tableNode != null ? tableNode.getNodeValue() : barerole;
            Node schemaNode = atts.getNamedItem("schema");
            String schema = schemaNode == null ? root.getSchemaName() : schemaNode.getNodeValue();
            this.table = root.addTable(schema, tableName);
        }
        if ((lazyNode = atts.getNamedItem("lazy")) != null) {
            this.lazy = StringHelper.booleanValue(lazyNode.getNodeValue());
        }
    }

    public void secondPassCompile(Map persistentClasses) throws MappingException {
        if (this.doneSecondPass) {
            return;
        }
        if (this.isOneToMany) {
            Class assocClass = this.getOneToMany().getType().getPersistentClass();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass.getName());
            }
            this.table = persistentClass.getTable();
        }
        NodeList list = this.node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node subnode = list.item(i);
            String name = subnode.getNodeName();
            if ("key".equals(name) || "generated-key".equals(name)) {
                this.key = new Value(subnode, null, DEFAULT_KEY_COLUMN_NAME, this.isOneToMany, this.table, this.root);
                if (!this.toplevel) {
                    this.key.setType(this.owner.getIdentifier().getType());
                }
                if (this.key.getType().returnedClass().isArray()) {
                    throw new MappingException("illegal use of an array as an identifier (arrays don't reimplement equals)");
                }
            } else if ("element".equals(name)) {
                this.element = new Value(subnode, "", DEFAULT_ELEMENT_COLUMN_NAME, true, this.table, this.root);
            } else if ("subcollection".equals(name)) {
                this.element = new Value(subnode, "", DEFAULT_ELEMENT_COLUMN_NAME, true, this.table, this.root);
            } else if ("many-to-many".equals(name)) {
                this.element = new ManyToOne(subnode, "", DEFAULT_ELEMENT_COLUMN_NAME, true, this.table, this.root);
            } else if ("composite-element".equals(name)) {
                this.element = new Component(subnode, null, "", null, true, this.table, this.root);
            } else if ("jcs-cache".equals(name)) {
                this.cache = this.root.createJCSCache(subnode, this.role, this.owner);
            }
            ++i;
        }
        if (!this.readonly) {
            if (!this.isOneToMany) {
                this.element.createForeignKeys(this.root, this.table);
            }
            if (!this.toplevel) {
                this.key.createForeignKeyOfClass(this.root, this.table, this.owner.getPersistentClass());
            }
        }
        if (!this.isIndexed()) {
            this.createIndex();
        }
        this.doneSecondPass = true;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getRole() {
        return this.role;
    }

    public abstract PersistentCollectionType getType();

    public abstract Class wrapperClass();

    public boolean isPrimitiveArray() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isOneToMany() {
        return this.isOneToMany;
    }

    public boolean isToplevel() {
        return this.toplevel;
    }

    public OneToMany getOneToMany() {
        return this.oneToMany;
    }

    public Index createIndex() {
        String name = "IX" + this.table.uniqueColumnString(this.getKey().getColumnIterator());
        Index index = this.table.getIndex(name);
        Iterator iter = this.getKey().getColumnIterator();
        while (iter.hasNext()) {
            index.addColumn((Column)iter.next());
        }
        return index;
    }

    public void createPrimaryKey() {
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

