/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.loader;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.helpers.ArrayHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.loader.Loader;
import cirrus.hibernate.loader.OuterJoinGenerator;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.persister.MultiTableEntityPersister;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.OneToOneType;
import cirrus.hibernate.type.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class OuterJoinLoader
extends Loader {
    public static final int EAGER = 1;
    public static final int AUTO = 0;
    public static final int LAZY = -1;
    protected static final Type[] NO_TYPES = new Type[0];
    protected static final String[][] NO_STRINGARRAYS = new String[0][];
    protected static final String[] NO_STRINGS = new String[0];
    protected static final Loadable[] NO_PERSISTERS = new Loadable[0];
    protected Loadable[] classPersisters;
    protected String sql;
    protected String[] suffixes;
    protected final OuterJoinGenerator outerJoinGenerator;

    public OuterJoinLoader(Dialect dialect) {
        this.outerJoinGenerator = dialect.getOuterJoinGenerator();
    }

    protected final List walkTree(Loadable persister, String alias, SessionFactoryImplementor session) throws MappingException {
        ArrayList associations = new ArrayList();
        this.walkTree(persister, alias, associations, new HashSet(), session);
        return associations;
    }

    protected final List walkTree(CollectionPersister persister, String alias, SessionFactoryImplementor session) throws MappingException {
        ArrayList associations = new ArrayList();
        if (session.enableJoinedFetch()) {
            Type type = persister.getElementType();
            String[] columns = StringHelper.prefix(persister.getElementColumnNames(), alias + '.');
            if (type.isEntityType()) {
                EntityType etype = (EntityType)type;
                if (this.autoEager(persister.enableJoinedFetch(), etype, session)) {
                    this.walkTree(etype, columns, (Object)persister, alias, associations, new HashSet(), session);
                }
            } else if (type.isComponentType()) {
                this.walkTree((AbstractComponentType)type, columns, (Object)persister, alias, associations, new HashSet(), session);
            }
        }
        return associations;
    }

    private final void walkTree(Loadable persister, String alias, List associations, Set classPersisters, SessionFactoryImplementor session) throws MappingException {
        if (!session.enableJoinedFetch()) {
            return;
        }
        int n = persister.countSubclassProperties();
        int i = 0;
        while (i < n) {
            block4: {
                Type type;
                block3: {
                    String[] columns;
                    EntityType etype;
                    block6: {
                        block5: {
                            type = persister.getSubclassPropertyType(i);
                            if (!type.isEntityType()) break block3;
                            etype = (EntityType)type;
                            if (!this.autoEager(persister.enableJoinedFetch(i), etype, session)) break block4;
                            if (!etype.isOneToOne()) break block5;
                            if (persister.isDefinedOnSubclass(i)) break block4;
                            columns = StringHelper.prefix(persister.getIdentifierColumnNames(), alias + '.');
                            break block6;
                        }
                        columns = persister.toColumns(alias, i);
                    }
                    this.walkTree(etype, columns, (Object)persister, alias, associations, classPersisters, session);
                    break block4;
                }
                if (type.isComponentType()) {
                    String[] columns = persister.getSubclassPropertyColumnNames(i);
                    this.walkTree((AbstractComponentType)type, columns, (Object)persister, alias, associations, classPersisters, session);
                }
            }
            ++i;
        }
    }

    private void walkTree(AbstractComponentType act, String[] cols, Object persister, String alias, List associations, Set classPersisters, SessionFactoryImplementor session) throws MappingException {
        if (!session.enableJoinedFetch() || persister instanceof MultiTableEntityPersister) {
            return;
        }
        Type[] types = act.getSubtypes();
        int begin = 0;
        int i = 0;
        while (i < types.length) {
            int length = types[i].getColumnSpan(session);
            String[] range = ArrayHelper.slice(cols, begin, length);
            if (types[i].isEntityType()) {
                EntityType etype = (EntityType)types[i];
                if (this.autoEager(act.enableJoinedFetch(i), etype, session)) {
                    this.walkTree(etype, range, persister, alias, associations, classPersisters, session);
                }
            } else if (types[i].isComponentType()) {
                this.walkTree((AbstractComponentType)types[i], range, persister, alias, associations, classPersisters, session);
            }
            begin += length;
            ++i;
        }
    }

    protected boolean autoEager(int config, EntityType type, SessionFactoryImplementor session) throws MappingException {
        if (config == 1) {
            return true;
        }
        if (config == -1) {
            return false;
        }
        ClassPersister persister = session.getPersister(type.getPersistentClass());
        return !persister.hasProxy() || type.isOneToOne() && ((OneToOneType)type).isNullable();
    }

    private void walkTree(EntityType type, String[] columns, Object persister, String alias, List associations, Set classPersisters, SessionFactoryImplementor session) throws MappingException {
        Loadable subpersister = (Loadable)session.getPersister(type.getPersistentClass());
        if (!classPersisters.contains(subpersister)) {
            String subalias;
            OuterJoinableAssociation assoc = new OuterJoinableAssociation();
            associations.add(assoc);
            classPersisters.add(persister);
            assoc.subpersister = subpersister;
            assoc.foreignKeyColumns = columns;
            assoc.subalias = subalias = OuterJoinLoader.alias(subpersister.getClassName(), associations.size());
            this.walkTree(subpersister, subalias, associations, classPersisters, session);
        }
    }

    public final String getSQLString() {
        return this.sql;
    }

    public final Loadable[] getPersisters() {
        return this.classPersisters;
    }

    protected final String selectString(List associations) {
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        while (i < associations.size()) {
            OuterJoinableAssociation join = (OuterJoinableAssociation)associations.get(i);
            OuterJoinLoader.appendSelectString(buf, join.subpersister, join.subalias, this.getSuffixes()[i]);
            if (i < associations.size() - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    protected static final String selectString(Loadable persister, String alias, String suffix) {
        StringBuffer buf = new StringBuffer(30);
        OuterJoinLoader.appendSelectString(buf, persister, alias, suffix);
        return buf.toString();
    }

    private static final void appendSelectString(StringBuffer buf, Loadable persister, String alias, String suffix) {
        String[] keyCols = persister.getIdentifierColumnNames();
        int j = 0;
        while (j < keyCols.length) {
            buf.append(alias).append('.').append(keyCols[j]).append(" AS ").append(OuterJoinLoader.aliasColumn(keyCols[j], suffix));
            if (j != keyCols.length - 1) {
                buf.append(", ");
            }
            ++j;
        }
        buf.append(persister.propertySelectClauseFragment(alias, suffix));
    }

    protected static final String whereString(String[] columns, String alias) {
        StringBuffer buf = new StringBuffer(20);
        int i = 0;
        while (i < columns.length) {
            buf.append(alias).append('.').append(columns[i]).append(" = ?");
            if (i < columns.length - 1) {
                buf.append(" and ");
            }
            ++i;
        }
        return buf.toString();
    }

    protected static final String selectCollectionString(CollectionPersister persister, String alias) {
        StringBuffer buf = new StringBuffer(20);
        String[] selectCols = persister.getElementColumnNames();
        int i = 0;
        while (i < selectCols.length) {
            buf.append(alias).append('.').append(selectCols[i]);
            if (i != selectCols.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        if (persister.hasIndex()) {
            String[] indexCols = persister.getIndexColumnNames();
            int i2 = 0;
            while (i2 < indexCols.length) {
                buf.append(", ").append(alias).append('.').append(indexCols[i2]);
                ++i2;
            }
        }
        return buf.toString();
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    protected static String alias(String tableName, int n) {
        return OuterJoinLoader.aliasCore((tableName = StringHelper.unqualify(tableName)).length() <= 5 ? tableName : tableName.substring(0, 5), Integer.toString(n));
    }

    protected static String aliasColumn(String columnName, String suffix) {
        return OuterJoinLoader.aliasCore(columnName, suffix);
    }

    private static String aliasCore(String name, String suffix) {
        boolean nameEscaped;
        char quote = name.charAt(0);
        boolean bl = nameEscaped = "`\"".indexOf(quote) > -1;
        if (nameEscaped) {
            name = name.substring(1, name.length() - 1);
        }
        StringBuffer aliasBuilder = new StringBuffer(name.length());
        if (nameEscaped) {
            aliasBuilder.append(quote);
        }
        aliasBuilder.append(name);
        aliasBuilder.append(suffix);
        if (nameEscaped) {
            aliasBuilder.append(quote);
        }
        return aliasBuilder.toString();
    }

    public static final class OuterJoinableAssociation {
        Loadable subpersister;
        String[] foreignKeyColumns;
        String subalias;
    }
}

