/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.loader;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.loader.CollectionInitializer;
import cirrus.hibernate.loader.Loader;
import cirrus.hibernate.loader.OuterJoinLoader;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final CollectionPersister collectionPersister;
    private final Type[] idType;
    private final boolean allowTwoPhaseLoad;

    public CollectionLoader(CollectionPersister persister, SessionFactoryImplementor session) throws MappingException {
        super(session.getDialect());
        this.allowTwoPhaseLoad = !persister.isSet();
        this.idType = new Type[]{persister.getKeyType()};
        String alias = OuterJoinLoader.alias(persister.getQualifiedTableName(), 0);
        List associations = this.walkTree(persister, alias, session);
        int joins = associations.size();
        this.suffixes = new String[joins];
        int i = 0;
        while (i < joins) {
            this.suffixes[i] = joins == 1 ? "" : Integer.toString(i);
            ++i;
        }
        this.sql = Loader.sqlSelect(OuterJoinLoader.selectCollectionString(persister, alias) + (joins == 0 ? "" : ", " + this.selectString(associations)), persister.getQualifiedTableName() + ' ' + alias, this.outerJoinGenerator.outerJoinStringAfterFrom(associations), OuterJoinLoader.whereString(persister.getKeyColumnNames(), alias), this.outerJoinGenerator.outerJoinStringAfterWhere(associations), persister.hasOrdering() ? persister.getSQLOrderByString(alias) : null);
        this.classPersisters = new Loadable[joins];
        int i2 = 0;
        while (i2 < joins) {
            this.classPersisters[i2] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i2)).subpersister;
            ++i2;
        }
        this.collectionPersister = persister;
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, PersistentCollection collection, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, new Object[]{id}, this.idType, collection, true);
    }

    protected boolean allowTwoPhaseLoad() {
        return this.allowTwoPhaseLoad;
    }
}

