/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.jmx;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.Databinder;
import cirrus.hibernate.Datastore;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Interceptor;
import cirrus.hibernate.LazyInitializationException;
import cirrus.hibernate.Session;
import cirrus.hibernate.SessionFactory;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.id.UUIDHexGenerator;
import cirrus.hibernate.impl.SessionFactoryObjectFactory;
import cirrus.hibernate.metadata.ClassMetadata;
import cirrus.hibernate.metadata.CollectionMetadata;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionFactoryStub
implements SessionFactory {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$jmx$SessionFactoryStub == null ? (class$cirrus$hibernate$jmx$SessionFactoryStub = SessionFactoryStub.class$("cirrus.hibernate.jmx.SessionFactoryStub")) : class$cirrus$hibernate$jmx$SessionFactoryStub));
    private static final IdentifierGenerator uuidgen = new UUIDHexGenerator();
    private transient SessionFactory impl;
    private transient String[] resources;
    private transient Properties properties;
    private String uuid;
    private String name;
    static /* synthetic */ Class class$cirrus$hibernate$jmx$SessionFactoryStub;
    static /* synthetic */ Class class$cirrus$hibernate$impl$SessionFactoryObjectFactory;

    SessionFactoryStub(String[] resources, Properties properties) {
        this.resources = resources;
        this.properties = properties;
        this.name = properties.getProperty("hibernate.session_factory_name");
        try {
            this.uuid = (String)((Object)uuidgen.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, properties);
    }

    public Session openSession() throws SQLException {
        return this.getImpl().openSession();
    }

    public Session openSession(Connection conn) {
        return this.getImpl().openSession(conn);
    }

    public Databinder openDatabinder() throws HibernateException {
        return this.getImpl().openDatabinder();
    }

    private synchronized SessionFactory getImpl() {
        if (this.impl == null) {
            try {
                Datastore ds = Hibernate.createDatastore();
                int i = 0;
                while (i < this.resources.length) {
                    ds.storeResource(this.resources[i], Thread.currentThread().getContextClassLoader());
                    ++i;
                }
                this.impl = ds.buildSessionFactory(this.properties);
            }
            catch (Exception e) {
                throw new LazyInitializationException(e);
            }
        }
        return this.impl;
    }

    Object readResolve() throws ObjectStreamException {
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a stub SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved stub SessionFactory by name");
        } else {
            log.debug((Object)"resolved stub SessionFactory by uid");
        }
        return result;
    }

    public Reference getReference() throws NamingException {
        return new Reference((class$cirrus$hibernate$jmx$SessionFactoryStub == null ? (class$cirrus$hibernate$jmx$SessionFactoryStub = SessionFactoryStub.class$("cirrus.hibernate.jmx.SessionFactoryStub")) : class$cirrus$hibernate$jmx$SessionFactoryStub).getName(), new StringRefAddr("uuid", this.uuid), (class$cirrus$hibernate$impl$SessionFactoryObjectFactory == null ? (class$cirrus$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryStub.class$("cirrus.hibernate.impl.SessionFactoryObjectFactory")) : class$cirrus$hibernate$impl$SessionFactoryObjectFactory).getName(), null);
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getImpl().getClassMetadata(persistentClass);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getImpl().getCollectionMetadata(roleName);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getImpl().openSession(connection, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws SQLException {
        return this.getImpl().openSession(interceptor);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getImpl().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getImpl().getAllCollectionMetadata();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

