/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.FlushMode;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Interceptor;
import cirrus.hibernate.Lifecycle;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.ObjectDeletedException;
import cirrus.hibernate.ObjectNotFoundException;
import cirrus.hibernate.PersistentObjectException;
import cirrus.hibernate.Query;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.ScrollableResults;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.TransientObjectException;
import cirrus.hibernate.Validatable;
import cirrus.hibernate.cache.CacheException;
import cirrus.hibernate.collections.ArrayHolder;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.Batcher;
import cirrus.hibernate.engine.Cascades;
import cirrus.hibernate.engine.Key;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.engine.Versioning;
import cirrus.hibernate.helpers.IdentityMap;
import cirrus.hibernate.helpers.JoinedIterator;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.impl.BatchingBatcher;
import cirrus.hibernate.impl.CacheEntry;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.impl.FilterImpl;
import cirrus.hibernate.impl.NonBatchingBatcher;
import cirrus.hibernate.impl.QueryImpl;
import cirrus.hibernate.impl.ScheduledCollectionRecreate;
import cirrus.hibernate.impl.ScheduledCollectionRemove;
import cirrus.hibernate.impl.ScheduledCollectionUpdate;
import cirrus.hibernate.impl.ScheduledDeletion;
import cirrus.hibernate.impl.ScheduledInsertion;
import cirrus.hibernate.impl.ScheduledUpdate;
import cirrus.hibernate.impl.SessionFactoryImpl;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.proxy.CGLIBLazyInitializer;
import cirrus.hibernate.proxy.HibernateProxy;
import cirrus.hibernate.proxy.HibernateProxyHelper;
import cirrus.hibernate.proxy.LazyInitializer;
import cirrus.hibernate.query.FilterTranslator;
import cirrus.hibernate.query.QueryTranslator;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionImpl
implements SessionImplementor {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$SessionImpl == null ? (class$cirrus$hibernate$impl$SessionImpl = SessionImpl.class$("cirrus.hibernate.impl.SessionImpl")) : class$cirrus$hibernate$impl$SessionImpl));
    private SessionFactoryImpl factory;
    private final boolean autoClose;
    private final long timestamp;
    private boolean closed = false;
    private FlushMode flushMode = FlushMode.AUTO;
    private boolean callAfterTransactionCompletionFromDisconnect = true;
    private final Map entitiesByKey;
    private final Map proxiesByKey;
    private final IdentityMap entries;
    private final IdentityMap arrayHolders;
    private final IdentityMap collections;
    private Set nullifiables = new HashSet();
    private Interceptor interceptor;
    private transient Connection connection;
    private transient boolean connect;
    private transient ArrayList insertions;
    private transient ArrayList deletions;
    private transient Map updates;
    private transient ArrayList collectionCreations;
    private transient ArrayList collectionUpdates;
    private transient ArrayList collectionRemovals;
    private transient ArrayList executions;
    private transient int dontFlushFromFind = 0;
    private transient boolean reentrantCallback = false;
    private transient Batcher batcher;
    private static final Status LOADED = new Status("LOADED");
    private static final Status DELETED = new Status("DELETED");
    private static final Status GONE = new Status("GONE");
    private static final Status LOADING = new Status("LOADING");
    private static final Status SAVING = new Status("SAVING");
    private static final Object[] NO_ARGS = new Object[0];
    private static final Type[] NO_TYPES = new Type[0];
    private transient Class lastClass;
    private transient ClassPersister lastResultForClass;
    static /* synthetic */ Class class$cirrus$hibernate$impl$SessionImpl;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing session");
        ois.defaultReadObject();
        this.initTransientCollections();
        Iterator<Object> iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                ((PersistentCollection)((Map.Entry)iter.next()).getKey()).setSession(this);
            }
            catch (HibernateException he) {
                throw new InvalidObjectException(he.getMessage());
            }
        }
        iter = this.proxiesByKey.values().iterator();
        while (iter.hasNext()) {
            Object proxy = iter.next();
            if (proxy instanceof HibernateProxy) {
                HibernateProxyHelper.getLazyInitializer((HibernateProxy)proxy).setSession(this);
                continue;
            }
            iter.remove();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot serialize a Session while connected");
        }
        if (this.insertions.size() != 0 || this.deletions.size() != 0) {
            throw new IllegalStateException("Cannot serialize a Session which has work waiting to be flushed");
        }
        log.trace((Object)"serializing session");
        oos.defaultWriteObject();
    }

    SessionImpl(Connection connection, SessionFactoryImpl factory, boolean autoclose, long timestamp, Interceptor interceptor) {
        this.connection = connection;
        this.connect = connection == null;
        this.interceptor = interceptor;
        this.autoClose = autoclose;
        this.timestamp = timestamp;
        this.factory = factory;
        this.entitiesByKey = new HashMap(50);
        this.proxiesByKey = new HashMap(10);
        this.entries = new IdentityMap();
        this.collections = new IdentityMap();
        this.arrayHolders = new IdentityMap();
        this.initTransientCollections();
        log.debug((Object)"opened session");
    }

    public Batcher getBatcher() {
        if (this.batcher == null) {
            this.batcher = this.factory.useJdbcBatch() ? new BatchingBatcher(this) : new NonBatchingBatcher(this);
        }
        return this.batcher;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() throws HibernateException, SQLException {
        log.trace((Object)"closing session");
        try {
            Connection connection = this.connection == null ? null : this.disconnect();
            Object var3_2 = null;
            this.cleanup();
            return connection;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void afterTransactionCompletion() {
        log.trace((Object)"transaction completion");
        Iterator iter = this.entries.values().iterator();
        while (iter.hasNext()) {
            ((EntityEntry)iter.next()).lockMode = LockMode.NONE;
        }
        iter = this.executions.iterator();
        while (iter.hasNext()) {
            try {
                ((Executable)iter.next()).afterTransactionCompletion();
            }
            catch (CacheException ce) {
                log.error((Object)"could not release a cache lock", (Throwable)((Object)ce));
            }
            catch (Exception e) {
                throw new AssertionFailure("Exception releasing cache locks", e);
            }
        }
        this.executions.clear();
        this.callAfterTransactionCompletionFromDisconnect = true;
    }

    private void initTransientCollections() {
        this.insertions = new ArrayList(20);
        this.deletions = new ArrayList(20);
        this.updates = new HashMap(20);
        this.collectionCreations = new ArrayList(20);
        this.collectionRemovals = new ArrayList(20);
        this.collectionUpdates = new ArrayList(20);
        this.executions = new ArrayList(50);
    }

    private void cleanup() {
        this.closed = true;
        this.entitiesByKey.clear();
        this.proxiesByKey.clear();
        this.entries.clear();
        this.arrayHolders.clear();
        this.collections.clear();
        this.nullifiables.clear();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        if (object instanceof HibernateProxy && (object = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.status != LOADED) {
            throw new ObjectDeletedException("The given object was deleted", e.id);
        }
        return e.lockMode;
    }

    private void addEntity(Key key, Object object) {
        this.entitiesByKey.put(key, object);
    }

    public Object getEntity(Key key) {
        return this.entitiesByKey.get(key);
    }

    private EntityEntry addEntry(Object object, Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, ClassPersister persister) {
        EntityEntry e = new EntityEntry(status, loadedState, id, version, lockMode, existsInDatabase, persister);
        this.entries.put(object, e);
        return e;
    }

    private EntityEntry getEntry(Object object) {
        return (EntityEntry)this.entries.get(object);
    }

    private boolean isEntryFor(Object object) {
        return this.entries.containsKey(object);
    }

    private void addCollectionEntry(PersistentCollection collection) {
        this.collections.put(collection, new CollectionEntry());
    }

    private CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return (CollectionEntry)this.collections.get(coll);
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public Serializable save(Object object) throws SQLException, HibernateException {
        if (object == null) {
            throw new NullPointerException("attempted to save null");
        }
        Serializable id = this.getPersister(object).getIdentifierGenerator().generate(this, object);
        return this.doSave(object, id);
    }

    public void save(Object object, Serializable id) throws SQLException, HibernateException {
        if (object == null) {
            throw new NullPointerException("attempted to insert null");
        }
        if (id == null) {
            throw new NullPointerException("null identifier passed to insert()");
        }
        this.doSave(object, id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Serializable doSave(Object object, Serializable id) throws SQLException, HibernateException {
        boolean identityCol;
        ClassPersister persister = this.getPersister(object);
        if (this.isEntryFor(object)) {
            throw new PersistentObjectException("attempted to save an instance of " + persister.getClassName() + " that was already associated with the Session");
        }
        Key key = null;
        if (id == null) {
            if (!persister.isIdentifierAssignedByInsert()) throw new AssertionFailure("null id");
            identityCol = true;
        } else {
            identityCol = false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("saving " + SessionImpl.infoString(persister, id)));
        }
        if (!identityCol) {
            key = new Key(id, persister);
            if (this.getEntity(key) != null) {
                throw new HibernateException("The generated ID is already in use" + SessionImpl.infoString(persister, id));
            }
            persister.setIdentifier(object, id);
        }
        if (persister.implementsLifecycle() && ((Lifecycle)object).onSave(this)) {
            return id;
        }
        if (persister.implementsValidatable()) {
            ((Validatable)object).validate();
        }
        this.addEntry(object, SAVING, null, id, null, LockMode.WRITE, identityCol, persister);
        Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_SAVE_UPDATE, 2);
        Object[] values = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.interceptor.onSave(object, id, values, persister.getPropertyNames(), types);
        boolean bl = substitute = persister.isVersioned() && Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType()) || substitute;
        if (this.wrap(values, persister.getPropertyTypes()) || substitute) {
            persister.setPropertyValues(object, values);
        }
        TypeFactory.deepCopy(values, types, values);
        this.nullifyTransientReferences(values, types, identityCol, object);
        if (identityCol) {
            id = persister.insert(values, object, this);
            key = new Key(id, persister);
            if (this.getEntity(key) != null) {
                throw new HibernateException("The natively generated ID is already in use " + SessionImpl.infoString(persister, id));
            }
            persister.setIdentifier(object, id);
        }
        this.addEntity(key, object);
        this.addEntry(object, LOADED, values, id, Versioning.getVersion(values, persister), LockMode.WRITE, identityCol, persister);
        if (!identityCol) {
            this.insertions.add(new ScheduledInsertion(id, values, object, persister, this));
        }
        Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_SAVE_UPDATE, 1);
        return id;
    }

    private void nullifyTransientReferences(Object[] values, Type[] types, boolean earlyInsert, Object self) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            values[i] = this.nullifyTransientReferences(values[i], types[i], earlyInsert, self);
            ++i;
        }
    }

    private Object nullifyTransientReferences(Object value, Type type, boolean earlyInsert, Object self) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (type.isEntityType()) {
            return this.isTransient(value, earlyInsert, self) ? null : value;
        }
        if (type.isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Object[] subvalues = actype.getPropertyValues(value);
            Type[] subtypes = actype.getSubtypes();
            boolean substitute = false;
            int i = 0;
            while (i < subvalues.length) {
                Object replacement = this.nullifyTransientReferences(subvalues[i], subtypes[i], earlyInsert, self);
                if (replacement != subvalues[i]) {
                    substitute = true;
                    subvalues[i] = replacement;
                }
                ++i;
            }
            if (substitute) {
                actype.setPropertyValues(value, subvalues);
            }
            return value;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTransient(Object object, boolean earlyInsert, Object self) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.getImplementation(this) == null) {
                return false;
            }
            try {
                object = li.getImplementation();
            }
            catch (SQLException sqle) {
                throw new AssertionFailure("Unexpected SQLException occurred in isTransient()", sqle);
            }
            catch (HibernateException he) {
                throw new AssertionFailure("Unexpected HibernateException occurred in isTransient()", (Throwable)((Object)he));
            }
        }
        if (object == self) {
            return false;
        }
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            ClassPersister persister = this.getPersister(object);
            if (!persister.hasIdentifierProperty()) return true;
            Serializable id = persister.getIdentifier(object);
            if (id == null) return true;
            e = this.getEntry(this.getEntity(new Key(id, persister)));
            if (e == null) {
                return persister.isUnsaved(id);
            }
        }
        if (e.status == SAVING) return true;
        if (earlyInsert) {
            if (e.existsInDatabase) return false;
            return true;
        } else if (!this.nullifiables.contains(new Key(e.id, e.persister))) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) throws SQLException, HibernateException {
        ClassPersister persister;
        if (object == null) {
            throw new NullPointerException("attempted to delete null");
        }
        EntityEntry entry = this.getEntry(object = HibernateProxyHelper.unproxy(object, this));
        if (entry == null) {
            log.trace((Object)"deleting a transient object");
            persister = this.getPersister(object);
            Serializable id = persister.getIdentifier(object);
            if (id == null) {
                throw new HibernateException("the transient instance passed to delete() had a null identifier");
            }
            this.removeCollectionsFor(persister, id, object);
            this.addEntity(new Key(id, persister), object);
            entry = this.addEntry(object, LOADED, persister.getPropertyValues(object), id, persister.getVersion(object), LockMode.NONE, true, persister);
        } else {
            persister = entry.persister;
        }
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to delete an object of immutable class: " + SessionImpl.infoString(persister));
        }
        if (entry.status != LOADED) {
            throw new ObjectDeletedException("Object was already deleted", entry.id);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleting " + SessionImpl.infoString(persister, entry.id)));
        }
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entry.getCurrentVersion();
        if (entry.loadedState == null) {
            entry.deletedState = persister.getPropertyValues(object);
        } else {
            entry.deletedState = new Object[entry.loadedState.length];
            TypeFactory.deepCopy(entry.loadedState, propTypes, entry.deletedState);
        }
        this.interceptor.onDelete(object, entry.id, entry.deletedState, persister.getPropertyNames(), propTypes);
        this.nullifyTransientReferences(entry.deletedState, propTypes, false, object);
        HashSet oldNullifiables = null;
        ArrayList oldDeletions = null;
        if (persister.hasCascades()) {
            oldNullifiables = new HashSet();
            oldNullifiables.addAll(this.nullifiables);
            oldDeletions = (ArrayList)this.deletions.clone();
        }
        this.nullifiables.add(new Key(entry.id, persister));
        entry.status = DELETED;
        ScheduledDeletion delete = new ScheduledDeletion(entry.id, version, object, persister, this);
        this.deletions.add(delete);
        try {
            if (persister.implementsLifecycle() && ((Lifecycle)object).onDelete(this)) {
                this.rollbackDeletion(entry, delete);
                return;
            }
            if (persister.hasCascades()) {
                int start = this.deletions.size();
                Set newNullifiables = this.nullifiables;
                this.nullifiables = oldNullifiables;
                try {
                    Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_DELETE, 1);
                    Object var12_12 = null;
                    newNullifiables.addAll(oldNullifiables);
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    newNullifiables.addAll(oldNullifiables);
                    this.nullifiables = newNullifiables;
                    throw throwable;
                }
                this.nullifiables = newNullifiables;
                int end = this.deletions.size();
                if (end != start) {
                    List middle = this.deletions.subList(oldDeletions.size(), start);
                    List tail = this.deletions.subList(start, end);
                    oldDeletions.addAll(tail);
                    oldDeletions.addAll(middle);
                    if (oldDeletions.size() != end) {
                        throw new AssertionFailure("Bug cascading collection deletions");
                    }
                    this.deletions = oldDeletions;
                }
            }
            Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_DELETE, 2);
        }
        catch (Exception e) {
            this.rollbackDeletion(entry, delete);
            SessionImpl.handle(e);
        }
    }

    private void rollbackDeletion(EntityEntry entry, ScheduledDeletion delete) {
        entry.status = LOADED;
        entry.deletedState = null;
        this.deletions.remove(delete);
    }

    private void removeCollectionsFor(ClassPersister persister, Serializable id, Object object) throws SQLException, HibernateException {
        if (persister.hasCollections()) {
            Type[] types = persister.getPropertyTypes();
            int i = 0;
            while (i < types.length) {
                this.removeCollectionsFor(types[i], id, persister.getPropertyValue(object, i));
                ++i;
            }
        }
    }

    private void removeCollectionsFor(Type type, Serializable id, Object value) throws SQLException, HibernateException {
        if (type.isPersistentCollectionType()) {
            CollectionPersister role = this.getCollectionPersister(((PersistentCollectionType)type).getRole());
            if (role.isToplevel()) {
                throw new HibernateException("Cant perform this operation on objects with toplevel collections");
            }
            if (role.hasSubcollections()) {
                throw new HibernateException("Cant perform this operation on objects with subcollections");
            }
            if (value != null && value instanceof PersistentCollection && !((PersistentCollection)value).wasInitialized()) {
                PersistentCollection coll = (PersistentCollection)value;
                if (coll.setSession(this)) {
                    this.addUninitializedCollection(coll, role, id);
                }
            } else {
                this.collectionRemovals.add(new ScheduledCollectionRemove(role, id, this));
            }
        } else if (type.isEntityType()) {
            ClassPersister persister;
            if (value != null && (persister = this.getPersister(((EntityType)type).getPersistentClass())).hasProxy() && value instanceof HibernateProxy) {
                HibernateProxyHelper.getLazyInitializer((HibernateProxy)value).setSession(this);
            }
        } else if (type.isComponentType() && value != null) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Type[] types = actype.getSubtypes();
            int i = 0;
            while (i < types.length) {
                this.removeCollectionsFor(types[i], id, actype.getPropertyValue(value, i));
                ++i;
            }
        }
    }

    public void update(Object obj) throws SQLException, HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        Object object = HibernateProxyHelper.unproxy(obj, this);
        ClassPersister persister = this.getPersister(object);
        if (persister.hasIdentifierProperty()) {
            if (!this.isEntryFor(object)) {
                Serializable id = persister.getIdentifier(object);
                if (id == null) {
                    throw new HibernateException("The given object has a null identifier property " + SessionImpl.infoString(persister));
                }
                this.doUpdate(object, obj, id);
            }
        } else {
            throw new HibernateException("The given object has no identifier property - you must supply an id " + SessionImpl.infoString(persister));
        }
    }

    public void saveOrUpdate(Object obj) throws SQLException, HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        Object object = HibernateProxyHelper.unproxy(obj, this);
        if (!this.isEntryFor(object)) {
            ClassPersister persister = this.getPersister(object);
            if (persister.hasIdentifierProperty()) {
                Serializable id = persister.getIdentifier(object);
                if (persister.isUnsaved(id)) {
                    this.save(object);
                } else {
                    this.doUpdate(object, obj, id);
                }
            } else {
                this.save(object);
            }
        }
    }

    public void update(Object obj, Serializable id) throws SQLException, HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        Object object = HibernateProxyHelper.unproxy(obj, this);
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            this.doUpdate(object, obj, id);
        } else if (!e.id.equals(id)) {
            throw new PersistentObjectException("The instance passed to update() was already persistent with a different id: " + e.id);
        }
    }

    private void doUpdate(Object object, Object proxy, Serializable id) throws SQLException, HibernateException {
        Key key;
        Object old;
        ClassPersister persister = this.getPersister(object);
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to update an object of immutable class: " + SessionImpl.infoString(persister));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("updating " + SessionImpl.infoString(persister, id)));
        }
        if ((old = this.getEntity(key = new Key(id, persister))) == object) {
            throw new AssertionFailure("Hibernate has a bug in update() ... or you are using an illegal id type" + SessionImpl.infoString(persister, id));
        }
        if (old != null) {
            throw new HibernateException("Another object was associated with this id (the object with the given id was already loaded) " + SessionImpl.infoString(persister, id));
        }
        if (persister.implementsLifecycle() && ((Lifecycle)object).onUpdate(this)) {
            return;
        }
        this.removeCollectionsFor(persister, id, object);
        this.addEntity(key, object);
        this.addEntry(object, LOADED, null, id, persister.getVersion(object), LockMode.NONE, true, persister);
        if (proxy != object) {
            this.proxiesByKey.put(key, proxy);
        }
        Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_SAVE_UPDATE, 0);
    }

    public List find(String query) throws SQLException, HibernateException {
        return this.find(query, NO_ARGS, NO_TYPES);
    }

    public List find(String query, Object value, Type type) throws SQLException, HibernateException {
        return this.find(query, new Object[]{value}, new Type[]{type});
    }

    public List find(String query, Object[] values, Type[] types) throws SQLException, HibernateException {
        return this.find(query, values, types, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List find(String query, Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("find: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        QueryTranslator[] q = this.getQueries(query, false);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        try {
            int i = 0;
            while (i < q.length) {
                List currentResults = q[i].find(this, values, types, true, selection, namedParams);
                currentResults.addAll(results);
                results = currentResults;
                ++i;
            }
            Object var11_10 = null;
            --this.dontFlushFromFind;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
        return results;
    }

    private QueryTranslator[] getQueries(String query, boolean scalar) throws HibernateException, SQLException {
        String[] concreteQueries = QueryTranslator.concreteQueries(query, this.factory);
        QueryTranslator[] q = new QueryTranslator[concreteQueries.length];
        HashSet qs = new HashSet();
        int i = 0;
        while (i < concreteQueries.length) {
            q[i] = scalar ? this.factory.getScalarQuery(concreteQueries[i]) : this.factory.getQuery(concreteQueries[i]);
            qs.addAll(q[i].getQuerySpaces());
            ++i;
        }
        this.autoFlushIfRequired(qs);
        return q;
    }

    public Iterator iterate(String query) throws HibernateException, SQLException {
        return this.iterate(query, NO_ARGS, NO_TYPES);
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException, SQLException {
        return this.iterate(query, new Object[]{value}, new Type[]{type});
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException, SQLException {
        return this.iterate(query, values, types, null, null);
    }

    public Iterator iterate(String query, Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams) throws HibernateException, SQLException {
        boolean many;
        QueryTranslator[] q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("iterate: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        if ((q = this.getQueries(query, true)).length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = q.length > 1;
        if (many) {
            results = new Iterator[q.length];
        }
        int i = 0;
        while (i < q.length) {
            result = q[i].iterate(values, types, selection, namedParams, this);
            if (many) {
                results[i] = result;
            }
            ++i;
        }
        return many ? new JoinedIterator(results) : result;
    }

    public ScrollableResults scroll(String query, Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams) throws HibernateException, SQLException {
        String[] concreteQueries;
        if (log.isTraceEnabled()) {
            log.trace((Object)("scroll: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        if ((concreteQueries = QueryTranslator.concreteQueries(query, this.factory)).length > 1) {
            throw new HibernateException("This query cannot be scrolled: " + query);
        }
        if (concreteQueries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + query);
        }
        QueryTranslator q = this.factory.getScalarQuery(concreteQueries[0]);
        this.autoFlushIfRequired(q.getQuerySpaces());
        return q.scroll(values, types, selection, namedParams, this);
    }

    public List findIdentifiers(String query) throws HibernateException, SQLException {
        return this.findIdentifiers(query, NO_ARGS, NO_TYPES);
    }

    public List findIdentifiers(String query, Object value, Type type) throws HibernateException, SQLException {
        return this.findIdentifiers(query, new Object[]{value}, new Type[]{type});
    }

    public List findIdentifiers(String query, Object[] values, Type[] types) throws HibernateException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("findIdentifiers: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        QueryTranslator[] q = this.getQueries(query, false);
        List result = Collections.EMPTY_LIST;
        int i = 0;
        while (i < q.length) {
            List currentResult = q[i].findIdentifiers(values, types, this);
            currentResult.addAll(result);
            result = currentResult;
            ++i;
        }
        return result;
    }

    public int delete(String query) throws HibernateException, SQLException {
        return this.delete(query, NO_ARGS, NO_TYPES);
    }

    public int delete(String query, Object value, Type type) throws HibernateException, SQLException {
        return this.delete(query, new Object[]{value}, new Type[]{type});
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("delete: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        List list = this.find(query, values, types);
        int size = list.size();
        int i = 0;
        while (i < size) {
            this.delete(list.get(i));
            ++i;
        }
        return size;
    }

    public void lock(Object object) throws SQLException, HibernateException {
        this.lock(object, LockMode.UPGRADE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object object, LockMode lockMode) throws SQLException, HibernateException {
        if (object == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        EntityEntry e = this.getEntry(object = HibernateProxyHelper.unproxy(object, this));
        if (e == null) {
            throw new TransientObjectException("attempted to lock a transient instance");
        }
        ClassPersister persister = e.persister;
        if (lockMode.greaterThan(e.lockMode)) {
            if (e.status != LOADED) {
                throw new TransientObjectException("attempted to lock a deleted instance");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("locking " + SessionImpl.infoString(persister, e.id) + " in mode: " + lockMode));
            }
            if (persister.hasCache()) {
                persister.getCache().lock(e.id);
            }
            try {
                persister.lock(e.id, e.lastVersion, object, lockMode, this);
                e.lockMode = lockMode;
                Object var6_5 = null;
                if (persister.hasCache()) {
                    persister.getCache().release(e.id);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (persister.hasCache()) {
                    persister.getCache().release(e.id);
                }
                throw throwable;
            }
        }
    }

    public Query createFilter(Object collection, String queryString) {
        return new FilterImpl(queryString, collection, this);
    }

    public Query createQuery(String queryString) {
        return new QueryImpl(queryString, this);
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        return this.createQuery(this.factory.getNamedQuery(queryName));
    }

    public void suspendFlushes() {
        this.setFlushMode(FlushMode.COMMIT);
    }

    public void resumeFlushes() {
        this.setFlushMode(FlushMode.AUTO);
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    private boolean autoFlushIfRequired(Set querySpaces) throws HibernateException, SQLException {
        if (this.flushMode == FlushMode.AUTO && this.dontFlushFromFind == 0) {
            int oldSize = this.collectionRemovals.size();
            this.flushEverything();
            if (this.areTablesToBeUpdated(querySpaces)) {
                log.trace((Object)"Need to execute flush");
                this.execute();
                this.postFlush();
                return true;
            }
            log.trace((Object)"Dont need to execute flush");
            this.collectionCreations.clear();
            this.collectionUpdates.clear();
            int i = this.collectionRemovals.size() - 1;
            while (i >= oldSize) {
                this.collectionRemovals.remove(i);
                --i;
            }
        }
        return false;
    }

    public Object narrowProxy(Object proxy, ClassPersister p, Key key, Object object) throws HibernateException {
        if (!p.getConcreteProxyClass().isAssignableFrom(proxy.getClass())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Narrowing proxy to " + p.getConcreteProxyClass() + " - this operation breaks =="));
            }
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            proxy = CGLIBLazyInitializer.getProxy(p.getMappedClass(), p.getProxyInterfaces(), p.getProxyGetIdentifierMethod(), key.getIdentifier(), this);
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return proxy;
    }

    public Object proxyFor(ClassPersister persister, Key key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, impl);
        }
        return impl;
    }

    public void addUninitializedEntity(Key key, Object object, LockMode lockMode) {
        this.addEntity(key, object);
        this.addEntry(object, LOADING, null, key.getIdentifier(), null, lockMode, true, null);
    }

    public void postHydrate(ClassPersister persister, Serializable id, Object[] values, Object object, LockMode lockMode) throws HibernateException {
        persister.setIdentifier(object, id);
        Object version = Versioning.getVersion(values, persister);
        this.addEntry(object, LOADED, values, id, version, lockMode, true, persister);
        if (log.isTraceEnabled() && version != null) {
            log.trace((Object)("Version: " + version));
        }
    }

    private void throwObjectNotFound(Object o, Serializable id, Class clazz) throws ObjectNotFoundException {
        if (o == null) {
            throw new ObjectNotFoundException("No row with the given identifier exists", id, clazz);
        }
    }

    public void load(Object object, Serializable id) throws SQLException, HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        this.doLoadByObject(object, id, true);
    }

    public Object load(Class clazz, Serializable id) throws SQLException, HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        Object result = this.doLoadByClass(clazz, id, true, true);
        this.throwObjectNotFound(result, id, clazz);
        return result;
    }

    public Object immediateLoad(Class clazz, Serializable id) throws SQLException, HibernateException {
        Object result = this.doLoad(clazz, id, null, LockMode.NONE, false);
        this.throwObjectNotFound(result, id, clazz);
        return result;
    }

    public Object internalLoadOneToOne(Class clazz, Serializable id) throws SQLException, HibernateException {
        return this.doLoadByClass(clazz, id, false, false);
    }

    public Object internalLoad(Class clazz, Serializable id) throws SQLException, HibernateException {
        Object result = this.doLoadByClass(clazz, id, false, true);
        this.throwObjectNotFound(result, id, clazz);
        return result;
    }

    private void doLoadByObject(Object object, Serializable id, boolean checkDeleted) throws SQLException, HibernateException {
        if (this.getEntry(object) != null) {
            throw new PersistentObjectException("attempted to load into an instance that was already associated with the Session");
        }
        Class<?> clazz = object.getClass();
        Object result = this.doLoad(clazz, id, object, LockMode.NONE, checkDeleted);
        this.throwObjectNotFound(result, id, clazz);
        if (result != object) {
            throw new HibernateException("The object with that id was already loaded by the Session: " + id);
        }
    }

    private Object doLoadByClass(Class clazz, Serializable id, boolean checkDeleted, boolean allowProxyCreation) throws SQLException, HibernateException {
        ClassPersister persister;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading " + SessionImpl.infoString(clazz, id)));
        }
        if (!(persister = this.getPersister(clazz)).hasProxy()) {
            return this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted);
        }
        Key key = new Key(id, persister);
        if (this.getEntity(key) != null) {
            return this.proxyFor(persister, key, this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted));
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, null);
        }
        if (allowProxyCreation) {
            if (persister.hasProxy()) {
                proxy = CGLIBLazyInitializer.getProxy(clazz, persister.getProxyInterfaces(), persister.getProxyGetIdentifierMethod(), id, this);
            }
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted);
    }

    public Object loadWithLock(Class clazz, Serializable id) throws SQLException, HibernateException {
        return this.load(clazz, id, LockMode.UPGRADE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Class clazz, Serializable id, LockMode lockMode) throws SQLException, HibernateException {
        Object result;
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for load()");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading " + SessionImpl.infoString(clazz, id) + " in lock mode: " + lockMode));
        }
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        ClassPersister persister = this.getPersister(clazz);
        if (persister.hasCache()) {
            persister.getCache().lock(id);
        }
        try {
            result = this.doLoad(clazz, id, null, lockMode, true);
            Object var7_6 = null;
            if (persister.hasCache()) {
                persister.getCache().release(id);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (persister.hasCache()) {
                persister.getCache().release(id);
            }
            throw throwable;
        }
        this.throwObjectNotFound(result, id, persister.getMappedClass());
        return this.proxyFor(persister, new Key(id, persister), result);
    }

    private Object doLoad(Class theClass, Serializable id, Object optionalObject, LockMode lockMode, boolean checkDeleted) throws SQLException, HibernateException {
        Object finalResult;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to resolve " + SessionImpl.infoString(theClass, id)));
        }
        boolean isOptionalObject = optionalObject != null;
        ClassPersister persister = this.getPersister(theClass);
        Key key = new Key(id, persister);
        Object old = this.getEntity(key);
        if (old != null) {
            Status status = this.getEntry((Object)old).status;
            if (checkDeleted && (status == DELETED || status == GONE)) {
                throw new ObjectDeletedException("The object with that id was deleted", id);
            }
            this.lock(old, lockMode);
            finalResult = old;
        } else {
            CacheEntry entry;
            CacheEntry cacheEntry = entry = persister.hasCache() ? (CacheEntry)persister.getCache().get(id, this.timestamp) : null;
            if (entry != null) {
                ClassPersister subclassPersister = this.getPersister(entry.getSubclass());
                finalResult = isOptionalObject ? optionalObject : subclassPersister.instantiate(id);
                this.addEntry(finalResult, LOADING, null, id, null, LockMode.NONE, true, subclassPersister);
                this.addEntity(new Key(id, persister), finalResult);
                Object[] values = entry.assemble(finalResult, id, subclassPersister, this);
                Type[] types = subclassPersister.getPropertyTypes();
                TypeFactory.deepCopy(values, types, values);
                Object version = Versioning.getVersion(values, subclassPersister);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cached Version: " + version));
                }
                this.addEntry(finalResult, LOADED, values, id, version, LockMode.NONE, true, subclassPersister);
                this.lock(finalResult, lockMode);
            } else {
                finalResult = persister.load(id, optionalObject, lockMode, this);
            }
        }
        return finalResult;
    }

    public void initializeEntity(Object object) throws HibernateException, SQLException {
        EntityEntry e = this.getEntry(object);
        ClassPersister persister = e.persister;
        Serializable id = e.id;
        Object[] hydratedState = e.loadedState;
        Type[] types = persister.getPropertyTypes();
        this.interceptor.onLoad(object, id, hydratedState, persister.getPropertyNames(), types);
        int i = 0;
        while (i < hydratedState.length) {
            hydratedState[i] = types[i].resolveIdentifier(hydratedState[i], this);
            ++i;
        }
        persister.setPropertyValues(object, hydratedState);
        TypeFactory.deepCopy(hydratedState, persister.getPropertyTypes(), hydratedState);
        if (persister.hasCache()) {
            persister.getCache().put(id, new CacheEntry(object, persister, this), this.timestamp);
        }
        this.reentrantCallback = true;
        if (persister.implementsLifecycle()) {
            ((Lifecycle)object).onLoad(this, id);
        }
        this.reentrantCallback = false;
    }

    public Transaction beginTransaction() throws HibernateException {
        this.callAfterTransactionCompletionFromDisconnect = false;
        return this.factory.getTransactionFactory().beginTransaction(this);
    }

    public void flush() throws SQLException, HibernateException {
        this.flushEverything();
        this.execute();
        this.postFlush();
    }

    private void flushEverything() throws HibernateException, SQLException {
        log.trace((Object)"flushing session");
        this.interceptor.preFlush(this.entitiesByKey.values().iterator());
        this.preFlushEntities();
        this.preFlushCollections();
        this.flushEntities();
        this.flushCollections();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushed: " + this.insertions.size() + " insertions, " + this.updates.size() + " updates, " + this.deletions.size() + " deletions to " + this.entries.size() + " objects"));
            log.debug((Object)("Flushed: " + this.collectionCreations.size() + " (re)creations, " + this.collectionUpdates.size() + " updates, " + this.collectionRemovals.size() + " removals to " + this.collections.size() + " collections"));
        }
    }

    private boolean areTablesToBeUpdated(Set tables) {
        return this.areTablesToUpdated(this.updates.values().iterator(), tables) || this.areTablesToUpdated(this.insertions.iterator(), tables) || this.areTablesToUpdated(this.deletions.iterator(), tables) || this.areTablesToUpdated(this.collectionUpdates.iterator(), tables) || this.areTablesToUpdated(this.collectionCreations.iterator(), tables) || this.areTablesToUpdated(this.collectionRemovals.iterator(), tables);
    }

    private boolean areTablesToUpdated(Iterator iter, Set set) {
        while (iter.hasNext()) {
            Serializable[] spaces = ((Executable)iter.next()).getPropertySpaces();
            int i = 0;
            while (i < spaces.length) {
                if (set.contains(spaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void execute() throws SQLException, HibernateException {
        log.trace((Object)"Executing");
        this.executeAll(this.insertions.iterator());
        this.executeAll(this.updates.values().iterator());
        this.executeAll(this.collectionRemovals.iterator());
        this.executeAll(this.collectionUpdates.iterator());
        this.executeAll(this.collectionCreations.iterator());
        this.executeAll(this.deletions.iterator());
    }

    public void postInsert(Object obj) {
        this.getEntry((Object)obj).existsInDatabase = true;
    }

    public void postDelete(Object obj) {
        this.getEntry((Object)obj).existsInDatabase = false;
    }

    private void executeAll(Iterator iter) throws SQLException, HibernateException {
        while (iter.hasNext()) {
            Executable e = (Executable)iter.next();
            this.executions.add(e);
            e.execute();
            iter.remove();
        }
        if (this.batcher != null) {
            this.batcher.executeBatch();
        }
    }

    private void flushEntities() throws HibernateException, SQLException {
        log.trace((Object)"Flushing entities and processing referenced collections");
        Iterator iter = this.entries.entrySet().iterator();
        while (iter.hasNext()) {
            Serializable oid;
            Map.Entry me = (Map.Entry)iter.next();
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.status;
            if (status == LOADING || status == GONE) continue;
            Object object = me.getKey();
            ClassPersister persister = entry.persister;
            if (persister.hasIdentifierProperty() && !entry.id.equals(oid = persister.getIdentifier(object))) {
                throw new HibernateException("identifier of an instance of " + persister.getClassName() + " altered from " + entry.id + " to " + oid);
            }
            Object[] values = status == DELETED ? entry.deletedState : persister.getPropertyValues(object);
            Type[] types = persister.getPropertyTypes();
            boolean substitute = this.wrap(values, types);
            boolean noCleanState = entry.loadedState == null;
            int[] dirtyProperties = !noCleanState ? persister.findDirty(values, entry.loadedState, object, this) : null;
            if (noCleanState || dirtyProperties != null || status == LOADED && persister.isVersioned() && persister.hasCollections() && this.searchForDirtyCollections(values, types)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Updating entity: " + SessionImpl.infoString(persister, entry.id)));
                }
                boolean bl = substitute = this.interceptor.onFlushDirty(object, entry.id, values, entry.loadedState, persister.getPropertyNames(), types) || substitute;
                if (status == LOADED) {
                    if (persister.implementsValidatable()) {
                        ((Validatable)object).validate();
                    }
                    Object[] copiedValues = new Object[values.length];
                    TypeFactory.deepCopy(values, types, copiedValues);
                    entry.loadedState = copiedValues;
                    entry.nextLockMode = LockMode.WRITE;
                }
                if (persister.isVersioned()) {
                    if (status != DELETED) {
                        entry.nextVersion = Versioning.increment(entry.lastVersion, persister.getVersionType());
                    }
                    Versioning.setVersion(values, entry.getCurrentVersion(), persister);
                }
                this.updates.put(new Key(entry.id, persister), new ScheduledUpdate(entry.id, values, dirtyProperties, entry.lastVersion, object, persister, this));
            }
            if (status == DELETED) {
                entry.status = GONE;
                continue;
            }
            if (substitute) {
                persister.setPropertyValues(object, values);
            }
            this.updateReachables(values, types, object);
        }
    }

    private void preFlushEntities() throws HibernateException, SQLException {
        Iterator iter = this.entries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = (Map.Entry)iter.next();
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.status;
            if (status == LOADING || status == GONE || status == DELETED) continue;
            Object object = me.getKey();
            Cascades.cascade((SessionImplementor)this, entry.persister, object, Cascades.ACTION_SAVE_UPDATE, 0);
        }
    }

    private ClassPersister getPersister(Class theClass) throws MappingException {
        if (this.lastClass != theClass) {
            this.lastResultForClass = this.factory.getPersister(theClass);
            this.lastClass = theClass;
        }
        return this.lastResultForClass;
    }

    public ClassPersister getPersister(Object object) throws MappingException {
        return this.getPersister(object.getClass());
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.id;
    }

    public Serializable getID(Object object) {
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        return entry != null ? entry.id : null;
    }

    private void flushCollections() throws HibernateException, SQLException {
        log.trace((Object)"Processing unreferenced collections");
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            if (((CollectionEntry)e.getValue()).reached) continue;
            this.updateUnreachableCollection((PersistentCollection)e.getKey());
        }
        log.trace((Object)"Scheduling collection removes/(re)creates/updates");
        iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = (Map.Entry)iter.next();
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.dorecreate) {
                this.collectionCreations.add(new ScheduledCollectionRecreate(coll, ce.currentPersister, ce.currentID, this));
            }
            if (ce.doremove) {
                this.collectionRemovals.add(new ScheduledCollectionRemove(ce.loadedPersister, ce.loadedID, this));
            }
            if (!ce.doupdate) continue;
            this.collectionUpdates.add(new ScheduledCollectionUpdate(coll, ce.loadedPersister, ce.loadedID, this));
        }
    }

    private void postFlush() throws HibernateException {
        Map.Entry me;
        log.trace((Object)"post flush");
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            me = (Map.Entry)iter.next();
            ((CollectionEntry)me.getValue()).postFlush((PersistentCollection)me.getKey());
        }
        iter = this.entries.entrySet().iterator();
        while (iter.hasNext()) {
            me = (Map.Entry)iter.next();
            EntityEntry entry = (EntityEntry)me.getValue();
            Object object = me.getKey();
            entry.postFlush(object);
        }
        this.interceptor.postFlush(this.entitiesByKey.values().iterator());
    }

    private void preFlushCollections() throws HibernateException {
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            ((CollectionEntry)e.getValue()).preFlush((PersistentCollection)e.getKey());
        }
    }

    private boolean wrap(Object[] fields, Type[] types) throws HibernateException {
        boolean substitute = false;
        int i = 0;
        while (i < fields.length) {
            Object result = this.wrap(fields[i], types[i]);
            if (result != fields[i]) {
                fields[i] = result;
                substitute = true;
            }
            ++i;
        }
        return substitute;
    }

    private Object wrap(Object obj, Type type) throws HibernateException {
        AbstractComponentType componentType;
        Object[] values;
        if (obj == null) {
            return null;
        }
        if (type.isComponentType() && this.wrap(values = (componentType = (AbstractComponentType)type).getPropertyValues(obj), componentType.getSubtypes())) {
            componentType.setPropertyValues(obj, values);
        }
        if (type.isPersistentCollectionType()) {
            PersistentCollection pc;
            if (obj instanceof PersistentCollection) {
                pc = (PersistentCollection)obj;
                if (pc.setSession(this)) {
                    this.addCollectionEntry(pc);
                }
            } else if (obj.getClass().isArray()) {
                ArrayHolder ah = this.getArrayHolder(obj);
                if (ah == null) {
                    ah = new ArrayHolder((SessionImplementor)this, obj);
                    this.addCollectionEntry(ah);
                    this.addArrayHolder(ah);
                }
            } else {
                pc = ((PersistentCollectionType)type).wrap(this, obj);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Wrapped collection in role: " + ((PersistentCollectionType)type).getRole()));
                }
                this.addCollectionEntry(pc);
                obj = pc;
            }
        }
        return obj;
    }

    private void updateReachableCollection(PersistentCollection coll, Type type, Object owner) throws HibernateException, SQLException {
        CollectionPersister persister;
        CollectionEntry ce = this.getCollectionEntry(coll);
        if (ce.reached) {
            throw new HibernateException("Found shared references to a collection");
        }
        ce.reached = true;
        ce.currentPersister = persister = this.getCollectionPersister(((PersistentCollectionType)type).getRole());
        ce.currentID = persister.updateID(owner, ce.loadedPersister, ce.loadedID, coll, this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collection found: " + SessionImpl.infoString(persister, ce.currentID) + ", was: " + SessionImpl.infoString(ce.loadedPersister, ce.loadedID)));
        }
        this.prepareCollectionForUpdate(coll, ce);
        this.updateReachableElements(coll, ce.currentPersister.getElementType(), null);
    }

    private void updateReachableElements(PersistentCollection coll, Type type, Object owner) throws HibernateException, SQLException {
        CollectionEntry ce = this.getCollectionEntry(coll);
        if (ce.initialized) {
            IdentityMap replacements = null;
            Iterator iter = coll.elements();
            while (iter.hasNext()) {
                Object object = iter.next();
                Type eltType = ce.currentPersister.getElementType();
                Object result = this.wrap(object, eltType);
                this.updateReachable(result, eltType, null);
                if (result == object) continue;
                if (replacements == null) {
                    replacements = new IdentityMap();
                }
                replacements.put(object, result);
            }
            if (replacements != null) {
                coll.replaceElements(replacements);
            }
        }
    }

    private void updateReachable(Object obj, Type type, Object owner) throws HibernateException, SQLException {
        if (obj != null) {
            if (type.isPersistentCollectionType()) {
                if (obj.getClass().isArray()) {
                    this.updateReachableCollection(this.getArrayHolder(obj), type, owner);
                } else {
                    this.updateReachableCollection((PersistentCollection)obj, type, owner);
                }
            } else if (type.isComponentType()) {
                Type[] types;
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] values = componentType.getPropertyValues(obj);
                if (this.wrap(values, types = componentType.getSubtypes())) {
                    componentType.setPropertyValues(obj, values);
                }
                this.updateReachables(values, types, owner);
            }
        }
    }

    private void updateUnreachable(Object obj, Type type) throws HibernateException, SQLException {
        if (obj != null) {
            if (type.isPersistentCollectionType()) {
                if (obj.getClass().isArray()) {
                    this.updateUnreachableCollection(this.getArrayHolder(obj));
                } else if (obj instanceof PersistentCollection) {
                    this.updateUnreachableCollection((PersistentCollection)obj);
                }
            } else if (type.isComponentType()) {
                Type[] types;
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] values = componentType.getPropertyValues(obj);
                if (this.wrap(values, types = componentType.getSubtypes())) {
                    componentType.setPropertyValues(obj, values);
                }
                this.updateUnreachables(values, types);
            }
        }
    }

    private void updateUnreachableCollection(PersistentCollection coll) throws HibernateException, SQLException {
        CollectionEntry entry = this.getCollectionEntry(coll);
        if (log.isDebugEnabled() && entry.loadedPersister != null) {
            log.debug((Object)("Collection dereferenced: " + SessionImpl.infoString(entry.loadedPersister, entry.loadedID)));
        }
        entry.currentPersister = null;
        entry.currentID = null;
        boolean wasInitialized = entry.initialized;
        this.prepareCollectionForUpdate(coll, entry);
        if (entry.initialized && !wasInitialized) {
            Iterator iter = coll.elements();
            while (iter.hasNext()) {
                this.updateUnreachable(iter.next(), entry.loadedPersister.getElementType());
            }
        }
    }

    private void prepareCollectionForUpdate(PersistentCollection coll, CollectionEntry entry) throws HibernateException, SQLException {
        if (entry.processed) {
            throw new AssertionFailure("Hibernate has a bug processing collections");
        }
        entry.processed = true;
        if (entry.loadedPersister != null || entry.currentPersister != null) {
            if (entry.loadedPersister != entry.currentPersister || !entry.currentPersister.getKeyType().equals(entry.loadedID, entry.currentID)) {
                if (entry.currentPersister != null) {
                    entry.dorecreate = true;
                }
                if (entry.loadedPersister != null) {
                    entry.doremove = true;
                    if (entry.dorecreate || entry.loadedPersister.hasSubcollections()) {
                        log.trace((Object)"Forcing collection initialization");
                        coll.forceLoad();
                    }
                }
            } else if (entry.dirty) {
                entry.doupdate = true;
            }
        }
    }

    private void updateReachables(Object[] fields, Type[] types, Object owner) throws HibernateException, SQLException {
        int i = 0;
        while (i < types.length) {
            this.updateReachable(fields[i], types[i], owner);
            ++i;
        }
    }

    private void updateUnreachables(Object[] fields, Type[] types) throws HibernateException, SQLException {
        int i = 0;
        while (i < types.length) {
            this.updateUnreachable(fields[i], types[i]);
            ++i;
        }
    }

    private boolean searchForDirtyCollections(Object[] fields, Type[] types) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            if (this.searchForDirtyCollections(fields[i], types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean searchForDirtyCollections(PersistentCollection coll, Type type) throws HibernateException {
        CollectionEntry entry = this.getCollectionEntry(coll);
        if (!entry.initialized) {
            return false;
        }
        if (entry.dirty || coll.hasQueuedAdds()) {
            return true;
        }
        CollectionPersister persister = this.getCollectionPersister(((PersistentCollectionType)type).getRole());
        Type eltType = persister.getElementType();
        if (eltType.isPersistentCollectionType() || eltType.isComponentType()) {
            Iterator iter = coll.elements();
            while (iter.hasNext()) {
                if (!this.searchForDirtyCollections(iter.next(), eltType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchForDirtyCollections(Object obj, Type type) throws HibernateException {
        if (obj != null) {
            if (type.isPersistentCollectionType()) {
                if (obj.getClass().isArray()) {
                    ArrayHolder ah = this.getArrayHolder(obj);
                    return ah == null ? true : this.searchForDirtyCollections(ah, type);
                }
                return !(obj instanceof PersistentCollection) ? true : this.searchForDirtyCollections((PersistentCollection)obj, type);
            }
            if (type.isComponentType()) {
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] values = componentType.getPropertyValues(obj);
                Type[] types = componentType.getSubtypes();
                int i = 0;
                while (i < values.length) {
                    if (this.searchForDirtyCollections(values[i], types[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public void addUninitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) {
        this.collections.put(collection, new CollectionEntry(persister, id, false));
    }

    public void addInitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(persister, id, true);
        ce.postInitialize(collection);
        this.collections.put(collection, ce);
    }

    public ArrayHolder getArrayHolder(Object array) {
        return (ArrayHolder)this.arrayHolders.get(array);
    }

    public void addArrayHolder(ArrayHolder holder) {
        this.arrayHolders.put(holder.getArray(), holder);
    }

    private CollectionPersister getCollectionPersister(String role) throws MappingException {
        return this.factory.getCollectionPersister(role);
    }

    public void dirty(PersistentCollection coll) {
        this.getCollectionEntry((PersistentCollection)coll).dirty = true;
    }

    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).snapshot;
    }

    public Serializable getCurrentID(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).currentID;
    }

    public Serializable getLoadedID(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).loadedID;
    }

    public boolean isCollectionReadOnly(PersistentCollection collection) {
        CollectionEntry ce = this.getCollectionEntry(collection);
        return ce != null && ce.loadedPersister.isReadOnly();
    }

    public void initialize(PersistentCollection collection, boolean writing) throws HibernateException, SQLException {
        CollectionEntry ce = this.getCollectionEntry(collection);
        if (!ce.initialized) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("initializing collection " + SessionImpl.infoString(ce.loadedPersister, ce.loadedID)));
            }
            CollectionPersister p = ce.loadedPersister;
            collection.beforeInitialize(p);
            p.getInitializer().initialize(ce.loadedID, collection, this);
            ce.initialized = true;
            ce.postInitialize(collection);
            if (!writing) {
                ce.loadedPersister.cache(ce.loadedID, collection, this);
            }
        }
    }

    public Connection connection() throws HibernateException, SQLException {
        if (this.connection == null) {
            if (this.connect) {
                this.connection = this.factory.openConnection();
                this.connect = false;
            } else {
                throw new HibernateException("Session is currently disconnected");
            }
        }
        return this.connection;
    }

    public boolean isConnected() {
        return this.connection != null || this.connect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection disconnect() throws HibernateException, SQLException {
        Connection c;
        block10: {
            block9: {
                log.debug((Object)"disconnecting session");
                try {
                    if (!this.connect) break block9;
                    this.connect = false;
                    Connection connection = null;
                    Object var4_3 = null;
                    if (this.callAfterTransactionCompletionFromDisconnect) {
                        this.afterTransactionCompletion();
                    }
                    return connection;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var4_6 = null;
                        if (!this.callAfterTransactionCompletionFromDisconnect) break block11;
                        this.afterTransactionCompletion();
                    }
                    throw throwable;
                }
            }
            if (this.connection == null) {
                throw new HibernateException("Session already disconnected");
            }
            if (this.batcher != null) {
                this.batcher.closeStatements();
            }
            c = this.connection;
            this.connection = null;
            if (!this.autoClose) break block10;
            this.factory.closeConnection(c);
            Connection connection = null;
            Object var4_4 = null;
            if (this.callAfterTransactionCompletionFromDisconnect) {
                this.afterTransactionCompletion();
            }
            return connection;
        }
        Connection connection = c;
        Object var4_5 = null;
        if (this.callAfterTransactionCompletionFromDisconnect) {
            this.afterTransactionCompletion();
        }
        return connection;
    }

    public void reconnect() throws SQLException, HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Session already connected");
        }
        log.debug((Object)"reconnecting session");
        this.connect = true;
    }

    public void reconnect(Connection conn) throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Session already connected");
        }
        this.connection = conn;
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"Running Session.finalize()");
        if (this.connection != null) {
            this.afterTransactionCompletion();
            if (this.connection.isClosed()) {
                log.warn((Object)"Finalizing unclosed session with closed connection");
            } else {
                log.warn((Object)"Unclosed connection");
                if (this.autoClose) {
                    this.connection.close();
                }
            }
        }
    }

    public static void handle(Exception e) throws SQLException, HibernateException {
        if (e instanceof SQLException) {
            throw (SQLException)e;
        }
        if (e instanceof HibernateException) {
            throw (HibernateException)((Object)e);
        }
        log.error((Object)"Unexpected exception", (Throwable)e);
        throw new HibernateException("Unexpected exception", e);
    }

    public Collection filter(Object collection, String filter) throws SQLException, HibernateException {
        return this.filter(collection, filter, new Object[1], new Type[1], null, null);
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws SQLException, HibernateException {
        return this.filter(collection, filter, new Object[]{null, value}, new Type[]{null, type}, null, null);
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws SQLException, HibernateException {
        Object[] vals = new Object[values.length + 1];
        Type[] typs = new Type[types.length + 1];
        System.arraycopy(values, 0, vals, 1, values.length);
        System.arraycopy(types, 0, typs, 1, types.length);
        return this.filter(collection, filter, vals, typs, null, null);
    }

    private FilterTranslator getFilterTranslator(Object collection, String filter, Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams, boolean scalar) throws SQLException, HibernateException {
        FilterTranslator q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("filter: " + filter));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        if (!(collection instanceof PersistentCollection) && (collection = this.getArrayHolder(collection)) == null) {
            throw new TransientObjectException("Collection was not yet persistent");
        }
        PersistentCollection coll = (PersistentCollection)collection;
        CollectionEntry e = this.getCollectionEntry(coll);
        if (e == null) {
            throw new TransientObjectException("Collection was not persistent in this session");
        }
        CollectionPersister roleBeforeFlush = e.loadedPersister;
        if (roleBeforeFlush == null) {
            this.flush();
            if (e.loadedPersister == null) {
                throw new QueryException("The collection was unreferenced");
            }
            q = this.factory.getFilter(filter, e.loadedPersister.getRole(), scalar);
        } else {
            q = this.factory.getFilter(filter, roleBeforeFlush.getRole(), scalar);
            if (this.autoFlushIfRequired(q.getQuerySpaces()) && roleBeforeFlush != e.loadedPersister) {
                if (e.loadedPersister == null) {
                    throw new QueryException("The collection was dereferenced");
                }
                q = this.factory.getFilter(filter, e.loadedPersister.getRole(), scalar);
            }
        }
        values[0] = e.loadedID;
        types[0] = e.loadedPersister.getKeyType();
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List filter(Object collection, String filter, Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams) throws SQLException, HibernateException {
        String[] concreteFilters = QueryTranslator.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        int i = 0;
        while (i < concreteFilters.length) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], values, types, selection, namedParams, false);
            ++i;
        }
        ++this.dontFlushFromFind;
        List results = Collections.EMPTY_LIST;
        try {
            int i2 = 0;
            while (i2 < concreteFilters.length) {
                List currentResults = filters[i2].find(this, values, types, true, selection, namedParams);
                currentResults.addAll(results);
                results = currentResults;
                ++i2;
            }
            Object var14_13 = null;
            --this.dontFlushFromFind;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
        return results;
    }

    public Iterator iterateFilter(Object collection, String filter, Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams) throws SQLException, HibernateException {
        boolean many;
        String[] concreteFilters = QueryTranslator.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        int i = 0;
        while (i < concreteFilters.length) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], values, types, selection, namedParams, true);
            ++i;
        }
        if (filters.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = filters.length > 1;
        if (many) {
            results = new Iterator[filters.length];
        }
        int i2 = 0;
        while (i2 < filters.length) {
            result = filters[i2].iterate(values, types, selection, namedParams, this);
            if (many) {
                results[i2] = result;
            }
            ++i2;
        }
        return many ? new JoinedIterator(results) : result;
    }

    private static String infoString(ClassPersister persister, Serializable id) {
        StringBuffer s = new StringBuffer();
        s.append('[');
        if (persister == null) {
            s.append("<null ClassPersister>");
        } else {
            s.append(persister.getClassName());
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else {
            s.append(id);
        }
        s.append(']');
        return s.toString();
    }

    private static String infoString(Class clazz, Serializable id) {
        StringBuffer s = new StringBuffer();
        s.append('[');
        if (clazz == null) {
            s.append("<null Class>");
        } else {
            s.append(clazz.getName());
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else {
            s.append(id);
        }
        s.append(']');
        return s.toString();
    }

    private static String infoString(ClassPersister persister) {
        StringBuffer s = new StringBuffer();
        s.append('[');
        if (persister == null) {
            s.append("<null ClassPersister>");
        } else {
            s.append(persister.getClassName());
        }
        s.append(']');
        return s.toString();
    }

    private static String infoString(CollectionPersister persister, Serializable id) {
        StringBuffer s = new StringBuffer();
        s.append('[');
        if (persister == null) {
            s.append("<unreferenced>");
        } else {
            s.append(persister.getRole());
            s.append('#');
            if (id == null) {
                s.append("<null>");
            } else {
                s.append(id);
            }
        }
        s.append(']');
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class CollectionEntry
    implements Serializable {
        boolean dirty = false;
        transient boolean reached;
        transient boolean processed;
        transient boolean doupdate;
        transient boolean doremove;
        transient boolean dorecreate;
        boolean initialized;
        CollectionPersister currentPersister;
        CollectionPersister loadedPersister;
        Serializable currentID;
        Serializable loadedID;
        Serializable snapshot;

        CollectionEntry() {
            this.initialized = true;
        }

        CollectionEntry(CollectionPersister loadedPersister, Serializable loadedID, boolean initialized) {
            this.initialized = initialized;
            this.loadedID = loadedID;
            this.loadedPersister = loadedPersister;
        }

        boolean isDirty(PersistentCollection coll) throws HibernateException {
            if (this.dirty || !coll.isArrayHolder() && !this.loadedPersister.getElementType().isMutable()) {
                return this.dirty;
            }
            return !coll.equalsSnapshot(this.loadedPersister.getElementType());
        }

        void preFlush(PersistentCollection collection) throws HibernateException {
            boolean bl = this.dirty = this.initialized && this.loadedPersister != null && this.isDirty(collection);
            if (log.isDebugEnabled() && this.dirty && this.loadedPersister != null) {
                log.debug((Object)("Collection dirty: " + SessionImpl.infoString(this.loadedPersister, this.loadedID)));
            }
            this.doupdate = false;
            this.doremove = false;
            this.dorecreate = false;
            this.reached = false;
            this.processed = false;
        }

        void postInitialize(PersistentCollection collection) throws HibernateException {
            this.snapshot = collection.getSnapshot(this.loadedPersister);
        }

        void postFlush(PersistentCollection collection) throws HibernateException {
            if (!this.processed) {
                throw new AssertionFailure("Hibernate has a bug processing collections");
            }
            this.loadedID = this.currentID;
            this.loadedPersister = this.currentPersister;
            this.dirty = false;
            if (this.initialized && (this.doremove || this.dorecreate || this.doupdate)) {
                this.snapshot = collection.getSnapshot(this.loadedPersister);
            }
        }
    }

    final class EntityEntry
    implements Serializable {
        LockMode lockMode;
        LockMode nextLockMode;
        Status status;
        Serializable id;
        Object[] loadedState;
        Object[] deletedState;
        boolean existsInDatabase;
        Object lastVersion;
        Object nextVersion;
        ClassPersister persister;

        EntityEntry(Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, ClassPersister persister) {
            this.status = status;
            this.loadedState = loadedState;
            this.id = id;
            this.existsInDatabase = existsInDatabase;
            this.lastVersion = version;
            this.lockMode = lockMode;
            this.persister = persister;
        }

        void postFlush(Object object) throws HibernateException {
            if (this.nextVersion != null) {
                this.lastVersion = this.nextVersion;
                Versioning.setVersion(this.loadedState, this.nextVersion, this.persister);
                this.persister.setPropertyValue(object, this.persister.getVersionProperty(), this.nextVersion);
                this.nextVersion = null;
            }
            if (this.nextLockMode != null) {
                this.lockMode = this.nextLockMode;
                this.nextLockMode = null;
            }
        }

        Object getCurrentVersion() {
            return this.nextVersion == null ? this.lastVersion : this.nextVersion;
        }
    }

    static interface Executable {
        public void execute() throws SQLException, HibernateException;

        public void afterTransactionCompletion() throws HibernateException;

        public Serializable[] getPropertySpaces();
    }

    static final class Status
    implements Serializable {
        private String name;

        Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        Object readResolve() throws ObjectStreamException {
            if (this.name.equals(LOADED.name)) {
                return LOADED;
            }
            if (this.name.equals(DELETED.name)) {
                return DELETED;
            }
            if (this.name.equals(GONE.name)) {
                return GONE;
            }
            if (this.name.equals(LOADING.name)) {
                return LOADING;
            }
            throw new InvalidObjectException("invalid Status");
        }
    }
}

