/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.cache.CacheConcurrencyStrategy;
import cirrus.hibernate.cache.CacheException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.impl.DatastoreImpl;
import cirrus.hibernate.loader.CollectionInitializer;
import cirrus.hibernate.loader.CollectionLoader;
import cirrus.hibernate.loader.OneToManyLoader;
import cirrus.hibernate.map.Array;
import cirrus.hibernate.map.Collection;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.IndexedCollection;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.metadata.CollectionMetadata;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.Type;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CollectionPersister
implements Serializable,
CollectionMetadata {
    private final transient String sqlSelectString;
    private final transient String sqlDeleteString;
    private final transient String sqlInsertRowString;
    private final transient String sqlUpdateRowString;
    private final transient String sqlDeleteRowString;
    private final transient String sqlOrderByString;
    private final transient boolean hasOrder;
    private final transient boolean isSet;
    private final transient IdentifierGenerator idgen;
    private final transient Type keyType;
    private final transient Type indexType;
    private final transient Type elementType;
    private final transient String[] keyColumnNames;
    private final transient String[] indexColumnNames;
    private final transient String[] unquotedIndexColumnNames;
    private final transient String[] elementColumnNames;
    private final transient String[] unquotedElementColumnNames;
    private final transient String[] rowSelectColumnNames;
    private final transient Type rowSelectType;
    private final transient boolean primitiveArray;
    private final transient boolean array;
    private final transient boolean isOneToMany;
    private final transient String qualifiedTableName;
    private final transient boolean hasIndex;
    private final transient boolean isLazy;
    private final transient boolean isToplevel;
    private final transient boolean isReadonly;
    private final transient boolean hasSubcollections;
    private final transient Class elementClass;
    private final transient CacheConcurrencyStrategy cache;
    private final transient PersistentCollectionType collectionType;
    private final transient int enableJoinedFetch;
    private final transient CollectionInitializer loader;
    private final String role;
    private final SessionFactoryImplementor factory;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$CollectionPersister == null ? (class$cirrus$hibernate$impl$CollectionPersister = CollectionPersister.class$("cirrus.hibernate.impl.CollectionPersister")) : class$cirrus$hibernate$impl$CollectionPersister));
    static /* synthetic */ Class class$cirrus$hibernate$impl$CollectionPersister;

    public CollectionPersister(Collection collection, DatastoreImpl datastore, String defaultSchema, SessionFactoryImplementor factory) throws MappingException, CacheException {
        this.collectionType = collection.getType();
        this.role = collection.getRole();
        this.factory = factory;
        this.hasOrder = collection.getOrderByString() != null;
        this.sqlOrderByString = collection.getOrderByString();
        this.cache = collection.getCache();
        this.isToplevel = collection.isToplevel();
        this.keyType = collection.getKey().getType();
        Iterator iter = collection.getKey().getColumnIterator();
        int span = collection.getKey().getColumnSpan();
        this.keyColumnNames = new String[span];
        int k = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.keyColumnNames[k] = col.getName();
            ++k;
        }
        this.idgen = this.isToplevel ? collection.getKey().getIdentifierGenerator() : null;
        this.isSet = collection.isSet();
        this.isOneToMany = collection.isOneToMany();
        this.primitiveArray = collection.isPrimitiveArray();
        this.array = collection.isArray();
        if (this.isOneToMany) {
            EntityType type = collection.getOneToMany().getType();
            this.elementType = type;
            PersistentClass associatedClass = datastore.getPersistentClass(type.getPersistentClass());
            span = associatedClass.getIdentifier().getColumnSpan();
            this.elementColumnNames = new String[span];
            iter = associatedClass.getKey().getColumnIterator();
            int j = 0;
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                this.elementColumnNames[j] = col.getName();
                ++j;
            }
            Table table = associatedClass.getTable();
            this.qualifiedTableName = table.getQualifiedName(defaultSchema);
            this.enableJoinedFetch = 1;
        } else {
            Table table = collection.getTable();
            this.qualifiedTableName = table.getQualifiedName(defaultSchema);
            this.elementType = collection.getElement().getType();
            span = collection.getElement().getColumnSpan();
            this.elementColumnNames = new String[span];
            this.enableJoinedFetch = collection.getElement().enableJoinedFetch();
            iter = collection.getElement().getColumnIterator();
            int i = 0;
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                this.elementColumnNames[i] = col.getName();
                ++i;
            }
        }
        this.unquotedElementColumnNames = StringHelper.unQuote(this.elementColumnNames);
        this.hasIndex = collection.isIndexed();
        if (this.hasIndex) {
            IndexedCollection indexedMap = (IndexedCollection)collection;
            this.indexType = indexedMap.getIndex().getType();
            int indexSpan = indexedMap.getIndex().getColumnSpan();
            iter = indexedMap.getIndex().getColumnIterator();
            this.indexColumnNames = new String[indexSpan];
            int i = 0;
            while (iter.hasNext()) {
                Column indexCol = (Column)iter.next();
                this.indexColumnNames[i++] = indexCol.getName();
            }
            this.rowSelectColumnNames = this.indexColumnNames;
            this.rowSelectType = this.indexType;
            this.unquotedIndexColumnNames = StringHelper.unQuote(this.indexColumnNames);
        } else {
            this.indexType = null;
            this.indexColumnNames = null;
            this.unquotedIndexColumnNames = null;
            this.rowSelectColumnNames = this.elementColumnNames;
            this.rowSelectType = this.elementType;
        }
        this.sqlSelectString = this.sqlSelectString();
        this.sqlDeleteString = this.sqlDeleteString();
        this.sqlInsertRowString = this.sqlInsertRowString();
        this.sqlUpdateRowString = this.sqlUpdateRowString();
        this.sqlDeleteRowString = this.sqlDeleteRowString();
        this.isLazy = collection.isLazy();
        this.isReadonly = collection.isReadOnly();
        this.hasSubcollections = CollectionPersister.hasSubcollections(this.elementType);
        this.elementClass = collection.isArray() ? ((Array)collection).getElementClass() : null;
        this.loader = this.createCollectionQuery(factory);
    }

    public CollectionInitializer getInitializer() {
        return this.loader;
    }

    private CollectionInitializer createCollectionQuery(SessionFactoryImplementor factory) throws MappingException {
        return this.isOneToMany() ? new OneToManyLoader(this, factory) : new CollectionLoader(this, factory);
    }

    public void cache(Serializable id, PersistentCollection coll, SessionImplementor s) throws HibernateException {
        if (this.cache != null) {
            this.cache.put(id, coll.disassemble(this), s.getTimestamp());
        }
    }

    public PersistentCollection getCachedCollection(Serializable id, SessionImplementor s) throws HibernateException, SQLException {
        if (this.cache == null) {
            return null;
        }
        Serializable cached = (Serializable)this.cache.get(id, s.getTimestamp());
        if (cached == null) {
            return null;
        }
        PersistentCollection coll = this.collectionType.wrap(s, cached);
        coll.assemble(this);
        return coll;
    }

    public void softlock(Serializable id) throws CacheException {
        if (this.cache != null) {
            this.cache.lock(id);
        }
    }

    public void releaseSoftlock(Serializable id) throws CacheException {
        if (this.cache != null) {
            this.cache.release(id);
        }
    }

    public String getSQLOrderByString() {
        return this.sqlOrderByString;
    }

    public String getSQLOrderByString(String alias) {
        StringTokenizer tokens = new StringTokenizer(this.sqlOrderByString, ",");
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            result.append(alias).append('.').append(tokens.nextToken().trim());
            if (!tokens.hasMoreTokens()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public int enableJoinedFetch() {
        return this.enableJoinedFetch;
    }

    public boolean hasOrdering() {
        return this.hasOrder;
    }

    private String getSQLSelectString() {
        return this.sqlSelectString;
    }

    private String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    private String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    private String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    private String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.idgen;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object readElement(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object element = this.getElementType().nullSafeGet(rs, this.unquotedElementColumnNames, session, null);
        return element;
    }

    public Object readIndex(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        return this.getIndexType().nullSafeGet(rs, this.unquotedIndexColumnNames, session, null);
    }

    public void writeElement(PreparedStatement st, Object elt, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(st, elt, 1 + (writeOrder ? 0 : this.keyColumnNames.length + (this.hasIndex ? this.indexColumnNames.length : 0)), session);
    }

    public void writeIndex(PreparedStatement st, Object idx, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getIndexType().nullSafeSet(st, idx, 1 + this.keyColumnNames.length + (writeOrder ? this.elementColumnNames.length : 0), session);
    }

    private void writeRowSelect(PreparedStatement st, Object idx, SessionImplementor session) throws HibernateException, SQLException {
        this.rowSelectType.nullSafeSet(st, idx, 1 + this.keyColumnNames.length, session);
    }

    public void writeKey(PreparedStatement st, Serializable id, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        if (id == null) {
            throw new NullPointerException("Null Collection Key");
        }
        this.getKeyType().nullSafeSet(st, id, 1 + (writeOrder ? this.elementColumnNames.length : 0), session);
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    public boolean isArray() {
        return this.array;
    }

    private String sqlSelectString() {
        boolean appendIndex = true;
        StringBuffer buf = new StringBuffer("select ");
        int i = 0;
        while (i < this.elementColumnNames.length) {
            buf.append(this.elementColumnNames[i]);
            if (i < this.elementColumnNames.length - 1) {
                buf.append(", ");
            }
            if (this.hasIndex && this.indexColumnNames.length == 1 && this.elementColumnNames[i].equals(this.indexColumnNames[0])) {
                appendIndex = false;
            }
            ++i;
        }
        if (this.hasIndex && appendIndex) {
            int i2 = 0;
            while (i2 < this.indexColumnNames.length) {
                buf.append(", ").append(this.indexColumnNames[i2]);
                ++i2;
            }
        }
        buf.append(" from ").append(this.qualifiedTableName).append(" where ").append(StringHelper.join(" = ? and ", this.keyColumnNames)).append(" = ?");
        if (this.hasOrder) {
            buf.append(" order by ").append(this.sqlOrderByString);
        }
        return buf.toString();
    }

    private String sqlDeleteString() {
        if (this.isOneToMany) {
            StringBuffer buf = new StringBuffer("update ").append(this.qualifiedTableName).append(" set ").append(StringHelper.join(" = null, ", this.keyColumnNames)).append(" = null");
            if (this.hasIndex) {
                buf.append(", ").append(StringHelper.join(" = null, ", this.indexColumnNames)).append(" = null");
            }
            buf.append(" where ").append(StringHelper.join(" = ? and ", this.keyColumnNames)).append(" = ?");
            return buf.toString();
        }
        return "delete from " + this.qualifiedTableName + " where " + StringHelper.join(" = ? and ", this.keyColumnNames) + " = ?";
    }

    private String sqlInsertRowString() {
        if (this.isOneToMany) {
            StringBuffer buf = new StringBuffer("update ").append(this.qualifiedTableName).append(" set ").append(StringHelper.join(" = ?, ", this.keyColumnNames)).append(" = ?");
            if (this.hasIndex) {
                buf.append(", ").append(StringHelper.join(" = ?, ", this.indexColumnNames)).append(" = ?");
            }
            buf.append(" where ").append(StringHelper.join(" = ? and ", this.elementColumnNames)).append(" = ?");
            return buf.toString();
        }
        StringBuffer buf = new StringBuffer("insert into ").append(this.qualifiedTableName).append(" ( ").append(StringHelper.join(", ", this.keyColumnNames));
        if (this.hasIndex) {
            buf.append(", ").append(StringHelper.join(", ", this.indexColumnNames));
        }
        int i = 0;
        while (i < this.elementColumnNames.length) {
            buf.append(", ").append(this.elementColumnNames[i]);
            ++i;
        }
        buf.append(" ) values ( ?");
        buf.append(StringHelper.repeat(", ?", this.elementColumnNames.length + this.keyColumnNames.length - 1 + (this.hasIndex ? this.indexColumnNames.length : 0)));
        return buf.append(" )").toString();
    }

    private String sqlUpdateRowString() {
        if (this.isOneToMany) {
            return null;
        }
        return "update " + this.qualifiedTableName + " set " + StringHelper.join(" = ?, ", this.elementColumnNames) + " = ? where " + StringHelper.join(" = ? and ", this.keyColumnNames) + " = ? and " + StringHelper.join(" = ? and ", this.rowSelectColumnNames) + " = ?";
    }

    private String sqlDeleteRowString() {
        return this.sqlDeleteString() + " and " + StringHelper.join(" = ? and ", this.rowSelectColumnNames) + " = ?";
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public boolean isOneToMany() {
        return this.isOneToMany;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isToplevel() {
        return this.isToplevel;
    }

    public Serializable updateID(Object owner, CollectionPersister lastRole, Serializable lastID, PersistentCollection coll, SessionImplementor session) throws HibernateException, SQLException {
        if (this.isToplevel()) {
            if (this == lastRole) {
                return lastID;
            }
            Serializable id = this.getIdentifierGenerator().generate(session, coll);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generated new collection ID " + id + " for role " + this.role));
            }
            return id;
        }
        return session.getID(owner);
    }

    public boolean isReadOnly() {
        return this.isReadonly;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public final void remove(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isReadonly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting collection: " + this.role + "#" + id));
            }
            PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteString());
            try {
                this.writeKey(st, id, false, session);
                session.getBatcher().addToBatch(-1);
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
        }
    }

    public final void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isReadonly) {
            Iterator entries;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting collection: " + this.role + "#" + id));
            }
            if ((entries = collection.entries()).hasNext()) {
                PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                int i = 0;
                try {
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        if (!this.isOneToMany || entry != null) {
                            this.writeKey(st, id, false, session);
                            collection.writeTo(st, this, entry, i, false);
                            session.getBatcher().addToBatch(1);
                        }
                        ++i;
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
            }
        }
    }

    public final void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isReadonly) {
            Iterator entries;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting rows of collection: " + this.role + "#" + id));
            }
            if ((entries = collection.getDeletes(this.elementType)).hasNext()) {
                PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                try {
                    while (entries.hasNext()) {
                        this.writeKey(st, id, false, session);
                        this.writeRowSelect(st, entries.next(), session);
                        session.getBatcher().addToBatch(-1);
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
            }
        }
    }

    private final void update(Serializable id, PersistentCollection collection, SessionImplementor session) throws SQLException, HibernateException {
        PreparedStatement st = null;
        Iterator entries = collection.entries();
        int i = 0;
        try {
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsUpdating(entry, i, this.elementType)) {
                    if (st == null) {
                        st = session.getBatcher().prepareBatchStatement(this.getSQLUpdateRowString());
                    }
                    this.writeKey(st, id, true, session);
                    collection.writeTo(st, this, entry, i, true);
                    session.getBatcher().addToBatch(1);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    private final void updateOneToMany(Serializable id, PersistentCollection collection, SessionImplementor session) throws SQLException, HibernateException {
        PreparedStatement rmvst = null;
        int i = 0;
        Iterator entries = collection.entries();
        try {
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsUpdating(entry, i, this.elementType)) {
                    if (rmvst == null) {
                        rmvst = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                    }
                    this.writeKey(rmvst, id, false, session);
                    this.writeIndex(rmvst, collection.getIndex(entry, i), false, session);
                    session.getBatcher().addToBatch(-1);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        PreparedStatement insst = null;
        i = 0;
        entries = collection.entries();
        try {
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (entry != null || collection.needsUpdating(entry, i, this.elementType)) {
                    if (insst == null) {
                        insst = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                    }
                    this.writeKey(insst, id, false, session);
                    collection.writeTo(insst, this, entry, i, false);
                    session.getBatcher().addToBatch(1);
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public final void updateRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isReadonly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating rows of collection: " + this.role + "#" + id));
            }
            if (this.isOneToMany) {
                this.updateOneToMany(id, collection, session);
            } else {
                this.update(id, collection, session);
            }
        }
    }

    public final void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        if (!this.isReadonly) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting rows of collection: " + this.role + "#" + id));
            }
            Iterator entries = collection.entries();
            PreparedStatement st = null;
            int i = 0;
            try {
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.needsInserting(entry, i, this.elementType) && (!this.isOneToMany || entry != null)) {
                        if (st == null) {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                        }
                        this.writeKey(st, id, false, session);
                        collection.writeTo(st, this, entry, i, false);
                        session.getBatcher().addToBatch(1);
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
        }
    }

    public boolean hasSubcollections() {
        return this.hasSubcollections;
    }

    private static boolean hasSubcollections(Type type) {
        if (type.isPersistentCollectionType()) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] subtypes = ((AbstractComponentType)type).getSubtypes();
            int i = 0;
            while (i < subtypes.length) {
                if (CollectionPersister.hasSubcollections(subtypes[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public String getRole() {
        return this.role;
    }

    Object readResolve() throws ObjectStreamException {
        try {
            return this.factory.getCollectionPersister(this.role);
        }
        catch (MappingException me) {
            throw new InvalidObjectException(me.getMessage());
        }
    }

    public boolean isSet() {
        return this.isSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

