/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.engine.Batcher;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BatcherImpl
implements Batcher {
    public static int open;
    protected static final Log log;
    protected final SessionImplementor session;
    protected final SessionFactoryImplementor factory;
    private PreparedStatement batchUpdate;
    private String batchUpdateSQL;
    private HashSet statementsToClose = new HashSet();
    static /* synthetic */ Class class$cirrus$hibernate$impl$BatcherImpl;

    public BatcherImpl(SessionImplementor session) {
        this.session = session;
        this.factory = session.getFactory();
    }

    protected PreparedStatement getStatement() {
        return this.batchUpdate;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException, HibernateException {
        this.executeBatch();
        BatcherImpl.logOpen();
        return this.factory.getPreparedStatement(this.session.connection(), sql, false);
    }

    public PreparedStatement prepareQueryStatement(String sql, boolean scrollable) throws SQLException, HibernateException {
        BatcherImpl.logOpen();
        PreparedStatement ps = this.factory.getPreparedStatement(this.session.connection(), sql, scrollable);
        this.factory.setFetchSize(ps);
        this.statementsToClose.add(ps);
        return ps;
    }

    public void closeQueryStatement(PreparedStatement ps) throws SQLException {
        this.statementsToClose.remove(ps);
        BatcherImpl.logClose();
        this.factory.closePreparedStatement(ps);
    }

    public void closeStatement(PreparedStatement ps) throws SQLException {
        BatcherImpl.logClose();
        this.factory.closePreparedStatement(ps);
    }

    public PreparedStatement prepareBatchStatement(String sql) throws SQLException, HibernateException {
        if (!sql.equals(this.batchUpdateSQL)) {
            this.batchUpdate = this.prepareStatement(sql);
            this.batchUpdateSQL = sql;
        }
        return this.batchUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException, HibernateException {
        if (this.batchUpdate != null) {
            PreparedStatement ps = this.batchUpdate;
            this.batchUpdate = null;
            this.batchUpdateSQL = null;
            try {
                this.doExecuteBatch(ps);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.closeStatement(ps);
                throw throwable;
            }
            this.closeStatement(ps);
            {
            }
        }
    }

    public void closeStatements() {
        Iterator iter = this.statementsToClose.iterator();
        while (iter.hasNext()) {
            try {
                this.closeStatement((PreparedStatement)iter.next());
            }
            catch (SQLException e) {
                log.warn((Object)"Could not close a JDBC statement", (Throwable)e);
            }
            iter.remove();
        }
        this.statementsToClose.clear();
    }

    protected abstract void doExecuteBatch(PreparedStatement var1) throws SQLException, HibernateException;

    private static void logOpen() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(++open + " open PreparedStatements"));
        }
    }

    private static void logClose() {
        if (log.isTraceEnabled()) {
            --open;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$BatcherImpl == null ? (class$cirrus$hibernate$impl$BatcherImpl = BatcherImpl.class$("cirrus.hibernate.impl.BatcherImpl")) : class$cirrus$hibernate$impl$BatcherImpl));
    }
}

