/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.helpers;

import cirrus.hibernate.helpers.DTDEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLHelper {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$helpers$XMLHelper == null ? (class$cirrus$hibernate$helpers$XMLHelper = XMLHelper.class$("cirrus.hibernate.helpers.XMLHelper")) : class$cirrus$hibernate$helpers$XMLHelper));
    private static final EntityResolver dtdResolver = new DTDEntityResolver();
    static /* synthetic */ Class class$cirrus$hibernate$helpers$XMLHelper;

    private XMLHelper() {
    }

    public static Document parseFile(String fileName) throws IOException, SAXException, ParserConfigurationException {
        return XMLHelper.parseInputSource(new InputSource(fileName));
    }

    public static Document parseInputSource(InputSource source) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(dtdResolver);
        final String file = source.getSystemId() == null ? "unknown system id" : source.getSystemId();
        log.info((Object)("Parsing XML: " + file));
        builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException error) {
                log.error((Object)("Error parsing XML: " + file + '(' + error.getLineNumber() + ')'), (Throwable)error);
            }

            public void fatalError(SAXParseException error) {
                this.error(error);
            }

            public void warning(SAXParseException error) {
                log.warn((Object)("Warning parsing XML: " + file + '(' + error.getLineNumber() + ')'), (Throwable)error);
            }
        });
        return builder.parse(source).getDocumentElement().getOwnerDocument();
    }

    public static Document parseString(String xml) throws IOException, SAXException, ParserConfigurationException {
        return XMLHelper.parseInputSource(new InputSource(new ByteArrayInputStream(xml.getBytes())));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

