/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.connection;

import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DBCPConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private Integer isolation;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$connection$DBCPConnectionProvider == null ? (class$cirrus$hibernate$connection$DBCPConnectionProvider = DBCPConnectionProvider.class$("cirrus.hibernate.connection.DBCPConnectionProvider")) : class$cirrus$hibernate$connection$DBCPConnectionProvider));
    static /* synthetic */ Class class$cirrus$hibernate$connection$DBCPConnectionProvider;

    public Connection getConnection() throws SQLException {
        try {
            Connection c = this.ds.getConnection();
            if (this.isolation != null) {
                c.setTransactionIsolation(this.isolation);
            }
            c.setAutoCommit(false);
            return c;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public boolean isStatementCache() {
        return true;
    }

    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderFactory.getJdbcConnectionProperties(props);
        log.info((Object)("DBCP using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
        log.info((Object)("Connection properties: " + connectionProps));
        if (jdbcDriverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "JDBC Driver class not found: " + jdbcDriverClass;
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
        }
        try {
            GenericObjectPool connectionPool = new GenericObjectPool(null, Integer.parseInt(props.getProperty("hibernate.dbcp.maxActive")), Byte.parseByte(props.getProperty("hibernate.dbcp.whenExhaustedAction")), Long.parseLong(props.getProperty("hibernate.dbcp.maxWait")), Integer.parseInt(props.getProperty("hibernate.dbcp.maxIdle")));
            GenericKeyedObjectPoolFactory statementPool = new GenericKeyedObjectPoolFactory(null, Integer.parseInt(props.getProperty("hibernate.dbcp.ps.maxActive")), Byte.parseByte(props.getProperty("hibernate.dbcp.ps.whenExhaustedAction")), Long.parseLong(props.getProperty("hibernate.dbcp.ps.maxWait")), Integer.parseInt(props.getProperty("hibernate.dbcp.ps.maxIdle")));
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcUrl, connectionProps);
            String validationQuery = props.getProperty("hibernate.dbcp.validationQuery");
            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, (KeyedObjectPoolFactory)statementPool, validationQuery, false, false);
            this.ds = new PoolingDataSource((ObjectPool)connectionPool);
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate DBCP connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate DBCP connection pool", e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

