/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.cfg;

import cirrus.hibernate.Datastore;
import cirrus.hibernate.Environment;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.SessionFactory;
import cirrus.hibernate.helpers.XMLHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Configuration {
    private Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$cfg$Configuration == null ? (class$cirrus$hibernate$cfg$Configuration = Configuration.class$("cirrus.hibernate.cfg.Configuration")) : class$cirrus$hibernate$cfg$Configuration));
    private String resource;
    static /* synthetic */ Class class$cirrus$hibernate$cfg$Configuration;
    static /* synthetic */ Class class$cirrus$hibernate$Environment;

    protected Configuration() {
    }

    public Configuration(String resource) {
        this.resource = resource;
    }

    protected InputStream getConfigurationInputStream() throws HibernateException {
        this.log.info((Object)("Configuration resource: " + this.resource));
        InputStream stream = (class$cirrus$hibernate$Environment == null ? (class$cirrus$hibernate$Environment = Configuration.class$("cirrus.hibernate.Environment")) : class$cirrus$hibernate$Environment).getResourceAsStream(this.resource);
        if (stream == null) {
            this.log.warn((Object)(this.resource + " not found"));
            throw new HibernateException(this.resource + " not found");
        }
        return stream;
    }

    private void addProperties(Node parent, Properties properties) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeName().equals("property")) {
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                String value = node.getFirstChild().getNodeValue();
                this.log.debug((Object)(name + "=" + value));
                properties.setProperty(name, value);
                if (!name.startsWith("hibernate")) {
                    properties.setProperty("hibernate." + name, value);
                }
            }
            ++i;
        }
        Environment.verifyProperties(properties);
    }

    public SessionFactory[] configure() throws HibernateException {
        Document doc;
        ArrayList<SessionFactory> factories = new ArrayList<SessionFactory>();
        InputStream stream = this.getConfigurationInputStream();
        try {
            doc = XMLHelper.parseInputSource(new InputSource(stream));
        }
        catch (Exception e) {
            this.log.error((Object)("Problem parsing configuration " + this.resource), (Throwable)e);
            throw new HibernateException("Problem parsing configuration " + this.resource + ": " + e);
        }
        Properties topLevelProps = new Properties();
        topLevelProps.putAll((Map<?, ?>)Environment.getProperties());
        this.addProperties(doc.getDocumentElement(), topLevelProps);
        NodeList sfElements = doc.getDocumentElement().getElementsByTagName("session-factory");
        int i = 0;
        while (i < sfElements.getLength()) {
            Node sfNode = sfElements.item(i);
            Properties props = (Properties)topLevelProps.clone();
            String name = sfNode.getAttributes().getNamedItem("name").getNodeValue();
            props.put("hibernate.session_factory_name", name);
            this.addProperties(sfNode, props);
            Datastore ds = Hibernate.createDatastore();
            NodeList mapElements = sfNode.getChildNodes();
            int j = 0;
            while (j < mapElements.getLength()) {
                Node mapElement = mapElements.item(j);
                if (mapElement.getNodeName().equals("mapping")) {
                    NamedNodeMap atts = mapElement.getAttributes();
                    Node resource = atts.getNamedItem("resource");
                    Node file = atts.getNamedItem("file");
                    Node jar = atts.getNamedItem("jar");
                    if (resource != null) {
                        this.log.debug((Object)(name + "<-" + resource));
                        try {
                            ds.storeResource(resource.getNodeValue(), Thread.currentThread().getContextClassLoader());
                        }
                        catch (MappingException me) {
                            ds.storeResource(resource.getNodeValue(), (class$cirrus$hibernate$Environment == null ? Configuration.class$("cirrus.hibernate.Environment") : class$cirrus$hibernate$Environment).getClassLoader());
                        }
                    } else if (jar != null) {
                        this.log.debug((Object)(name + "<-" + jar));
                        ds.storeJar(jar.getNodeValue());
                    } else {
                        if (file == null) {
                            throw new HibernateException("<mapping> element in configuration specifies no attributes");
                        }
                        this.log.debug((Object)(name + "<-" + file));
                        ds.storeFile(file.getNodeValue());
                    }
                }
                ++j;
            }
            factories.add(ds.buildSessionFactory(props));
            this.log.info((Object)("Configured SessionFactory: " + name));
            this.log.debug((Object)("properties: " + props));
            ++i;
        }
        this.log.debug((Object)"Configuration successful");
        return factories.toArray(new SessionFactory[factories.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

