/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.cache;

import cirrus.hibernate.cache.Timestamper;
import java.io.Serializable;

public final class CachedItem
implements Serializable {
    private long freshTimestamp;
    private boolean fresh;
    private long unlockTimestamp;
    private int lock;
    private Object value;

    public CachedItem(Object value) {
        this.value = value;
        this.freshTimestamp = Timestamper.next();
        this.fresh = true;
        this.unlockTimestamp = -1L;
    }

    public long getFreshTimestamp() {
        return this.freshTimestamp;
    }

    public long getUnlockTimestamp() {
        return this.unlockTimestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public void lock() {
        if (0 == this.lock++) {
            this.fresh = false;
            this.value = null;
        }
    }

    public void unlock() {
        if (--this.lock == 0) {
            this.unlockTimestamp = Timestamper.next();
        }
    }

    public boolean isUnlocked() {
        return this.lock == 0;
    }
}

