/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class LockMode
implements Serializable {
    private final int level;
    private final String name;
    private static final Map instances = new HashMap();
    public static final LockMode NONE = new LockMode(0, "NONE");
    public static final LockMode READ = new LockMode(5, "READ");
    public static final LockMode UPGRADE = new LockMode(10, "UPGRADE");
    public static final LockMode UPGRADE_NOWAIT = new LockMode(10, "UPGRADE_NOWAIT");
    public static final LockMode WRITE = new LockMode(10, "WRITE");

    private LockMode(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean greaterThan(LockMode mode) {
        return this.level > mode.level;
    }

    public boolean lessThan(LockMode mode) {
        return this.level < mode.level;
    }

    Object readResolve() {
        return instances.get(new Integer(this.level));
    }

    static {
        instances.put(new Integer(LockMode.NONE.level), NONE);
        instances.put(new Integer(LockMode.READ.level), READ);
        instances.put(new Integer(LockMode.UPGRADE.level), UPGRADE);
        instances.put(new Integer(LockMode.UPGRADE_NOWAIT.level), UPGRADE_NOWAIT);
        instances.put(new Integer(LockMode.WRITE.level), WRITE);
    }
}

