/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate;

import cirrus.hibernate.helpers.PropertiesHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Environment {
    private static final String VERSION = "1.2.2";
    public static final String CONNECTION_PROVIDER = "hibernate.connection.provider_class";
    public static final String DRIVER = "hibernate.connection.driver_class";
    public static final String ISOLATION = "hibernate.connection.isolation";
    public static final String URL = "hibernate.connection.url";
    public static final String USER = "hibernate.connection.username";
    public static final String PASS = "hibernate.connection.password";
    public static final String POOL_SIZE = "hibernate.connection.pool_size";
    public static final String DATASOURCE = "hibernate.connection.datasource";
    public static final String CONNECTION_PREFIX = "hibernate.connection";
    public static final String STATEMENT_CACHE_SIZE = "hibernate.statement_cache.size";
    public static final String JNDI_CLASS = "hibernate.jndi.class";
    public static final String JNDI_URL = "hibernate.jndi.url";
    public static final String JNDI_PREFIX = "hibernate.jndi";
    public static final String SESSION_FACTORY_NAME = "hibernate.session_factory_name";
    public static final String DIALECT = "hibernate.dialect";
    public static final String DEFAULT_SCHEMA = "hibernate.default_schema";
    public static final String SHOW_SQL = "hibernate.show_sql";
    public static final String OUTER_JOIN = "hibernate.use_outer_join";
    public static final String USE_STREAMS_FOR_BINARY = "hibernate.jdbc.use_streams_for_binary";
    public static final String USE_SCROLLABLE_RESULTSET = "hibernate.jdbc.use_scrollable_resultset";
    public static final String STATEMENT_FETCH_SIZE = "hibernate.jdbc.fetch_size";
    public static final String STATEMENT_BATCH_SIZE = "hibernate.jdbc.batch_size";
    public static final String OUTPUT_STYLESHEET = "hibernate.xml.output_stylesheet";
    public static final String C3P0_MAX_SIZE = "hibernate.c3p0.max_size";
    public static final String C3P0_MIN_SIZE = "hibernate.c3p0.min_size";
    public static final String C3P0_TIMEOUT = "hibernate.c3p0.timeout";
    public static final String C3P0_MAX_STATEMENTS = "hibernate.c3p0.max_statements";
    public static final String C3P0_VALIDATE_CONNECTION = "hibernate.c3p0.validate";
    public static final String DBCP_MAXACTIVE = "hibernate.dbcp.maxActive";
    public static final String DBCP_MAXIDLE = "hibernate.dbcp.maxIdle";
    public static final String DBCP_MAXWAIT = "hibernate.dbcp.maxWait";
    public static final String DBCP_WHENEXHAUSTED = "hibernate.dbcp.whenExhaustedAction";
    public static final String DBCP_VALIDATION_QUERY = "hibernate.dbcp.validationQuery";
    public static final String DBCP_PS_MAXACTIVE = "hibernate.dbcp.ps.maxActive";
    public static final String DBCP_PS_MAXIDLE = "hibernate.dbcp.ps.maxIdle";
    public static final String DBCP_PS_MAXWAIT = "hibernate.dbcp.ps.maxWait";
    public static final String DBCP_PS_WHENEXHAUSTED = "hibernate.dbcp.ps.whenExhaustedAction";
    public static final String TRANSACTION_STRATEGY = "hibernate.transaction.factory_class";
    public static final String TRANSACTION_MANAGER_STRATEGY = "hibernate.transaction.manager_lookup_class";
    public static final String USER_TRANSACTION = "jta.UserTransaction";
    public static final String QUERY_SUBSTITUTIONS = "hibernate.query.substitutions";
    public static final String QUERY_IMPORTS = "hibernate.query.imports";
    private static final String OUTPUT_STYLESHEET_OLD = "hibernate.output_stylesheet";
    private static final String CONNECTION_PROVIDER_OLD = "hibernate.connection_provider";
    private static final String DRIVER_OLD = "hibernate.driver";
    private static final String ISOLATION_OLD = "hibernate.isolation";
    private static final String USER_OLD = "hibernate.username";
    private static final String PASS_OLD = "hibernate.password";
    private static final String POOL_SIZE_OLD = "hibernate.pool_size";
    private static final String STATEMENT_CACHE_SIZE_OLD = "hibernate.statement_cache_size";
    private static final String DATASOURCE_OLD = "hibernate.datasource";
    private static final String TRANSACTION_STRATEGY_OLD = "hibernate.transaction_factory";
    private static final String URL_OLD = "hibernate.url";
    private static final String USE_STREAMS_FOR_BINARY_OLD = "hibernate.use_streams_for_binary";
    private static final String STATEMENT_FETCH_SIZE_OLD = "hibernate.statement.fetch_size";
    private static final String USE_SCROLLABLE_RESULTSET_OLD = "hibernate.use_scrollable_resultset";
    public static final String USE_JDBC_BATCH = "hibernate.use_jdbc_batch";
    private static final boolean jvmSupportsProxies;
    private static final boolean useStreamsForBinary;
    private static final boolean jvmSupportsLinkedHashCollections;
    private static final Properties properties;
    private static final HashMap isolationLevels;
    private static final Map obsoleteProperties;
    private static final Log log;
    static /* synthetic */ Class class$cirrus$hibernate$Environment;

    public static void verifyProperties(Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            Object oldProp = iter.next();
            Object newProp = obsoleteProperties.get(oldProp);
            if (newProp == null) continue;
            log.warn((Object)("Usage of obsolete property: " + oldProp + " no longer supported, use: " + newProp));
        }
    }

    public static boolean jvmSupportsProxies() {
        return true;
    }

    public static boolean jvmSupportsLinkedHashCollections() {
        return jvmSupportsLinkedHashCollections;
    }

    public static boolean useStreamsForBinary() {
        return useStreamsForBinary;
    }

    private Environment() {
        throw new UnsupportedOperationException();
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String isolationLevelToString(int isolation) {
        return (String)isolationLevels.get(new Integer(isolation));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean linkedHashSupport;
        boolean proxySupport;
        isolationLevels = new HashMap();
        obsoleteProperties = new HashMap();
        log = LogFactory.getLog((Class)(class$cirrus$hibernate$Environment == null ? (class$cirrus$hibernate$Environment = Environment.class$("cirrus.hibernate.Environment")) : class$cirrus$hibernate$Environment));
        log.info((Object)"Hibernate 1.2.2");
        isolationLevels.put(new Integer(0), "NONE");
        isolationLevels.put(new Integer(1), "READ_UNCOMMITTED");
        isolationLevels.put(new Integer(2), "READ_COMMITTED");
        isolationLevels.put(new Integer(4), "REPEATABLE_READ");
        isolationLevels.put(new Integer(8), "SERIALIZABLE");
        obsoleteProperties.put(CONNECTION_PROVIDER_OLD, CONNECTION_PROVIDER);
        obsoleteProperties.put(DRIVER_OLD, DRIVER);
        obsoleteProperties.put(ISOLATION_OLD, ISOLATION);
        obsoleteProperties.put(URL_OLD, URL);
        obsoleteProperties.put(PASS_OLD, PASS);
        obsoleteProperties.put(USER_OLD, USER);
        obsoleteProperties.put(POOL_SIZE_OLD, POOL_SIZE);
        obsoleteProperties.put(STATEMENT_CACHE_SIZE_OLD, STATEMENT_CACHE_SIZE);
        obsoleteProperties.put(DATASOURCE_OLD, DATASOURCE);
        obsoleteProperties.put(TRANSACTION_STRATEGY_OLD, TRANSACTION_STRATEGY);
        obsoleteProperties.put(OUTPUT_STYLESHEET_OLD, OUTPUT_STYLESHEET);
        obsoleteProperties.put(USE_JDBC_BATCH, STATEMENT_BATCH_SIZE);
        obsoleteProperties.put(USE_SCROLLABLE_RESULTSET_OLD, USE_SCROLLABLE_RESULTSET);
        obsoleteProperties.put(USE_STREAMS_FOR_BINARY_OLD, USE_STREAMS_FOR_BINARY);
        obsoleteProperties.put(STATEMENT_FETCH_SIZE_OLD, STATEMENT_FETCH_SIZE);
        properties = new Properties();
        InputStream stream = (class$cirrus$hibernate$Environment == null ? (class$cirrus$hibernate$Environment = Environment.class$("cirrus.hibernate.Environment")) : class$cirrus$hibernate$Environment).getResourceAsStream("/hibernate.properties");
        if (stream == null) {
            log.info((Object)"hibernate.properties not found");
        } else {
            try {
                properties.load(stream);
                log.info((Object)"loaded properties from resource hibernate.properties");
            }
            catch (Exception e) {
                log.error((Object)"problem loading properties from hibernate.properties");
            }
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        Environment.verifyProperties(properties);
        useStreamsForBinary = PropertiesHelper.getBoolean(USE_STREAMS_FOR_BINARY, properties);
        if (useStreamsForBinary) {
            log.info((Object)"using java.io streams to persist binary types");
        }
        try {
            Class.forName("java.lang.reflect.Proxy");
            proxySupport = true;
        }
        catch (ClassNotFoundException cnfe) {
            proxySupport = false;
        }
        log.info((Object)("JVM proxy support: " + proxySupport));
        jvmSupportsProxies = proxySupport;
        try {
            Class.forName("java.util.LinkedHashSet");
            linkedHashSupport = true;
        }
        catch (ClassNotFoundException cnfe) {
            linkedHashSupport = false;
        }
        jvmSupportsLinkedHashCollections = linkedHashSupport;
    }
}

