/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    private Address local_addr = null;
    private long timeout = 2000L;
    private int num_msgs = 1;
    final Hashtable suspects = new Hashtable();
    private Thread timer = null;
    static final String name = "VERIFY_SUSPECT";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_msgs")) != null) {
            this.num_msgs = Integer.parseInt(str);
            if (this.num_msgs <= 0) {
                if (this.warn) {
                    this.log.warn((Object)("num_msgs is invalid (" + this.num_msgs + "): setting it to 1"));
                }
                this.num_msgs = 1;
            }
            props.remove("num_msgs");
        }
        if (props.size() > 0) {
            this.log.error((Object)("VERIFY_SUSPECT.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                if (suspected_mbr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"suspected member is null");
                    }
                    return;
                }
                this.suspect(suspected_mbr);
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(name);
                if (obj == null || !(obj instanceof VerifyHeader)) break;
                VerifyHeader hdr = (VerifyHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"ARE_YOU_DEAD: hdr.from is null");
                            }
                        } else {
                            for (int i = 0; i < this.num_msgs; ++i) {
                                Message rsp = new Message(hdr.from, null, null);
                                rsp.putHeader(name, new VerifyHeader(2, this.local_addr));
                                this.passDown(new Event(1, rsp));
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"I_AM_NOT_DEAD: hdr.from is null");
                            }
                            return;
                        }
                        this.unsuspect(hdr.from);
                        return;
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.timer != null && Thread.currentThread().equals(this.timer) && this.suspects.size() > 0) {
            long diff = 0L;
            Hashtable hashtable = this.suspects;
            synchronized (hashtable) {
                Enumeration e = this.suspects.keys();
                while (e.hasMoreElements()) {
                    Address mbr = (Address)e.nextElement();
                    long val = (Long)this.suspects.get(mbr);
                    long curr_time = System.currentTimeMillis();
                    diff = curr_time - val;
                    if (diff >= this.timeout) {
                        if (this.trace) {
                            this.log.trace((Object)("diff=" + diff + ", mbr " + mbr + " is dead (passing up SUSPECT event)"));
                        }
                        this.passUp(new Event(9, mbr));
                        this.suspects.remove(mbr);
                        continue;
                    }
                    diff = Math.max(diff, this.timeout - diff);
                }
            }
            if (diff <= 0L) continue;
            Util.sleep(diff);
        }
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        Hashtable hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                return;
            }
            this.suspects.put(mbr, new Long(System.currentTimeMillis()));
            if (this.trace) {
                this.log.trace((Object)("verifying that " + mbr + " is dead"));
            }
            for (int i = 0; i < this.num_msgs; ++i) {
                Message msg = new Message(mbr, null, null);
                msg.putHeader(name, new VerifyHeader(1, this.local_addr));
                this.passDown(new Event(1, msg));
            }
        }
        if (this.timer == null) {
            this.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        Hashtable hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                if (this.trace) {
                    this.log.trace((Object)("member " + mbr + " is not dead !"));
                }
                this.suspects.remove(mbr);
                this.passDown(new Event(51, mbr));
                this.passUp(new Event(51, mbr));
            }
        }
    }

    void startTimer() {
        if (this.timer == null || !this.timer.isAlive()) {
            this.timer = new Thread((Runnable)this, "VERIFY_SUSPECT.TimerThread");
            this.timer.setDaemon(true);
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
        this.timer = null;
    }

    public static class VerifyHeader
    extends Header
    implements Streamable {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from = null;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.type);
            out.writeObject(this.from);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = (Address)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }
    }
}

