/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.protocols.AUTOCONF;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedBufferedInputStream;
import org.jgroups.util.ExposedBufferedOutputStream;
import org.jgroups.util.ExposedByteArrayInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public abstract class TP
extends Protocol {
    Address local_addr = null;
    String channel_name = null;
    InetAddress bind_addr = null;
    boolean use_local_host = false;
    boolean bind_to_all_interfaces = false;
    boolean receive_on_all_interfaces = false;
    List receive_interfaces = null;
    boolean send_on_all_interfaces = false;
    List send_interfaces = null;
    int bind_port = 0;
    int port_range = 1;
    final Vector members = new Vector(11);
    View view = null;
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(1024);
    final ExposedBufferedOutputStream buf_out_stream = new ExposedBufferedOutputStream(this.out_stream, 1024);
    final ExposedDataOutputStream dos = new ExposedDataOutputStream(this.buf_out_stream);
    final ExposedByteArrayInputStream in_stream = new ExposedByteArrayInputStream(new byte[]{48});
    final ExposedBufferedInputStream buf_in_stream = new ExposedBufferedInputStream(this.in_stream);
    final DataInputStream dis = new DataInputStream(this.buf_in_stream);
    boolean loopback = false;
    boolean discard_incompatible_packets = false;
    boolean use_incoming_packet_handler = false;
    Queue incoming_packet_queue = null;
    IncomingPacketHandler incoming_packet_handler = null;
    Queue incoming_msg_queue = null;
    IncomingMessageHandler incoming_msg_handler;
    boolean use_outgoing_packet_handler = false;
    BoundedLinkedQueue outgoing_queue = null;
    int outgoing_queue_max_size = 2000;
    OutgoingPacketHandler outgoing_packet_handler = null;
    byte[] additional_data = null;
    int max_bundle_size = AUTOCONF.senseMaxFragSizeStatic();
    long max_bundle_timeout = 20L;
    boolean enable_bundling = false;
    Bundler bundler = null;
    TimeScheduler timer = null;
    DiagnosticsHandler diag_handler = null;
    boolean enable_diagnostics = true;
    String diagnostics_addr = "224.0.0.75";
    int diagnostics_port = 7500;
    HashMap addr_translation_table = new HashMap();
    boolean use_addr_translation = false;
    TpHeader header;
    final String name = this.getName();
    static final byte LIST = 1;
    static final byte MULTICAST = 2;
    long num_msgs_sent = 0L;
    long num_msgs_received = 0L;
    long num_bytes_sent = 0L;
    long num_bytes_received = 0L;
    static transient NumberFormat f = NumberFormat.getNumberInstance();

    protected TP() {
    }

    public String toString() {
        return this.name + "(local address: " + this.local_addr + ')';
    }

    public void resetStats() {
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "null";
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        this.bind_addr = InetAddress.getByName(bind_addr);
    }

    public boolean getBindToAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public void setBindToAllInterfaces(boolean flag) {
        this.receive_on_all_interfaces = flag;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public boolean isSendOnAllInterfaces() {
        return this.send_on_all_interfaces;
    }

    public List getSendInterfaces() {
        return this.send_interfaces;
    }

    public boolean isDiscardIncompatiblePackets() {
        return this.discard_incompatible_packets;
    }

    public void setDiscardIncompatiblePackets(boolean flag) {
        this.discard_incompatible_packets = flag;
    }

    public boolean isEnableBundling() {
        return this.enable_bundling;
    }

    public void setEnableBundling(boolean flag) {
        this.enable_bundling = flag;
    }

    public int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    public void setMaxBundleSize(int size) {
        this.max_bundle_size = size;
    }

    public long getMaxBundleTimeout() {
        return this.max_bundle_timeout;
    }

    public void setMaxBundleTimeout(long timeout) {
        this.max_bundle_timeout = timeout;
    }

    public int getOutgoingQueueSize() {
        return this.outgoing_queue != null ? this.outgoing_queue.size() : 0;
    }

    public int getIncomingQueueSize() {
        return this.incoming_packet_queue != null ? this.incoming_packet_queue.size() : 0;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public String getChannelName() {
        return this.channel_name;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void setLoopback(boolean b) {
        this.loopback = b;
    }

    public boolean isUseIncomingPacketHandler() {
        return this.use_incoming_packet_handler;
    }

    public boolean isUseOutgoingPacketHandler() {
        return this.use_outgoing_packet_handler;
    }

    public int getOutgoingQueueMaxSize() {
        return this.outgoing_queue != null ? this.outgoing_queue_max_size : 0;
    }

    public void setOutgoingQueueMaxSize(int new_size) {
        if (this.outgoing_queue != null) {
            this.outgoing_queue.setCapacity(new_size);
            this.outgoing_queue_max_size = new_size;
        }
    }

    public Map dumpStats() {
        HashMap<String, Long> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, Long>();
        }
        retval.put("num_msgs_sent", new Long(this.num_msgs_sent));
        retval.put("num_msgs_received", new Long(this.num_msgs_received));
        retval.put("num_bytes_sent", new Long(this.num_bytes_sent));
        retval.put("num_bytes_received", new Long(this.num_bytes_received));
        return retval;
    }

    public abstract void sendToAllMembers(byte[] var1, int var2, int var3) throws Exception;

    public abstract void sendToSingleMember(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    public abstract void postUnmarshalling(Message var1, Address var2, Address var3, boolean var4);

    public abstract void postUnmarshallingList(Message var1, Address var2, boolean var3);

    private String _getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.channel_name).append(") ").append("\n");
        sb.append("local_addr=").append(this.local_addr).append("\n");
        sb.append("group_name=").append(this.channel_name).append("\n");
        sb.append("Version=").append("2.2.9.1").append(", cvs=\"").append("$Id: Version.java,v 1.27 2005/12/27 14:52:48 belaban Exp $").append("\"\n");
        sb.append("view: ").append(this.view).append('\n');
        sb.append(this.getInfo());
        return sb.toString();
    }

    private void handleDiagnosticProbe(SocketAddress sender, DatagramSocket sock, String request) {
        block10: {
            try {
                StringTokenizer tok = new StringTokenizer(request);
                String req = tok.nextToken();
                String info = "n/a";
                if (req.trim().toLowerCase().startsWith("query")) {
                    ArrayList<String> l = new ArrayList<String>(tok.countTokens());
                    while (tok.hasMoreTokens()) {
                        l.add(tok.nextToken().trim().toLowerCase());
                    }
                    info = this._getInfo();
                    if (l.contains("jmx")) {
                        Channel ch;
                        if (info == null) {
                            info = "";
                        }
                        if ((ch = this.stack.getChannel()) != null) {
                            Map m = ch.dumpStats();
                            StringBuffer sb = new StringBuffer();
                            sb.append("stats:\n");
                            Iterator it = m.entrySet().iterator();
                            while (it.hasNext()) {
                                sb.append(it.next()).append("\n");
                            }
                            info = info + sb.toString();
                        }
                    }
                    if (l.contains("props")) {
                        String p = this.stack.printProtocolSpecAsXML();
                        info = info + "\nprops:\n" + p;
                    }
                }
                byte[] diag_rsp = info.getBytes();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sending diag response to " + sender));
                }
                this.sendResponse(sock, sender, diag_rsp);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block10;
                this.log.error((Object)("failed sending diag rsp to " + sender), t);
            }
        }
    }

    private void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) throws IOException {
        DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
        sock.send(p);
    }

    public void start() throws Exception {
        this.timer = this.stack.timer;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.enable_diagnostics) {
            this.diag_handler = new DiagnosticsHandler();
            this.diag_handler.start();
        }
        if (this.use_incoming_packet_handler) {
            this.incoming_packet_queue = new Queue();
            this.incoming_packet_handler = new IncomingPacketHandler();
            this.incoming_packet_handler.start();
        }
        if (this.loopback) {
            this.incoming_msg_queue = new Queue();
            this.incoming_msg_handler = new IncomingMessageHandler();
            this.incoming_msg_handler.start();
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_queue = new BoundedLinkedQueue(this.outgoing_queue_max_size);
            this.outgoing_packet_handler = new OutgoingPacketHandler();
            this.outgoing_packet_handler.start();
        }
        if (this.enable_bundling) {
            this.bundler = new Bundler();
        }
        this.passUp(new Event(8, this.local_addr));
    }

    public void stop() {
        if (this.diag_handler != null) {
            this.diag_handler.stop();
            this.diag_handler = null;
        }
        if (this.outgoing_packet_handler != null) {
            this.outgoing_packet_handler.stop();
        }
        if (this.incoming_packet_handler != null) {
            this.incoming_packet_handler.stop();
        }
        if (this.incoming_msg_handler != null) {
            this.incoming_msg_handler.stop();
        }
    }

    public boolean setProperties(Properties props) {
        String tmp = null;
        super.setProperties(props);
        try {
            tmp = System.getProperty("bind.address");
            if (Util.isBindAddressPropertyIgnored()) {
                tmp = null;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String str = tmp != null ? tmp : props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("use_local_host")) != null) {
            this.use_local_host = new Boolean(str);
            props.remove("use_local_host");
        }
        if ((str = props.getProperty("bind_to_all_interfaces")) != null) {
            this.receive_on_all_interfaces = new Boolean(str);
            props.remove("bind_to_all_interfaces");
            this.log.warn((Object)"bind_to_all_interfaces has been deprecated; use receive_on_all_interfaces instead");
        }
        if ((str = props.getProperty("receive_on_all_interfaces")) != null) {
            this.receive_on_all_interfaces = new Boolean(str);
            props.remove("receive_on_all_interfaces");
        }
        if ((str = props.getProperty("receive_interfaces")) != null) {
            try {
                this.receive_interfaces = this.parseInterfaceList(str);
                props.remove("receive_interfaces");
            }
            catch (Exception e) {
                this.log.error((Object)("error determining interfaces (" + str + ")"), (Throwable)e);
                return false;
            }
        }
        if ((str = props.getProperty("send_on_all_interfaces")) != null) {
            this.send_on_all_interfaces = new Boolean(str);
            props.remove("send_on_all_interfaces");
        }
        if ((str = props.getProperty("send_interfaces")) != null) {
            try {
                this.send_interfaces = this.parseInterfaceList(str);
                props.remove("send_interfaces");
            }
            catch (Exception e) {
                this.log.error((Object)("error determining interfaces (" + str + ")"), (Throwable)e);
                return false;
            }
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("bind_port");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("discard_incompatible_packets")) != null) {
            this.discard_incompatible_packets = Boolean.valueOf(str);
            props.remove("discard_incompatible_packets");
        }
        if ((str = props.getProperty("use_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_packet_handler");
            if (this.warn) {
                this.log.warn((Object)"'use_packet_handler' is deprecated; use 'use_incoming_packet_handler' instead");
            }
        }
        if ((str = props.getProperty("use_incoming_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_incoming_packet_handler");
        }
        if ((str = props.getProperty("use_outgoing_packet_handler")) != null) {
            this.use_outgoing_packet_handler = Boolean.valueOf(str);
            props.remove("use_outgoing_packet_handler");
        }
        if ((str = props.getProperty("outgoing_queue_max_size")) != null) {
            this.outgoing_queue_max_size = Integer.parseInt(str);
            props.remove("outgoing_queue_max_size");
            if (this.outgoing_queue_max_size <= 0) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("outgoing_queue_max_size of " + this.outgoing_queue_max_size + " is invalid, setting it to 1"));
                }
                this.outgoing_queue_max_size = 1;
            }
        }
        if ((str = props.getProperty("max_bundle_size")) != null) {
            int bundle_size = Integer.parseInt(str);
            if (bundle_size > this.max_bundle_size) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is greater than largest TP fragmentation size (" + this.max_bundle_size + ')'));
                }
                return false;
            }
            if (bundle_size <= 0) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is <= 0"));
                }
                return false;
            }
            this.max_bundle_size = bundle_size;
            props.remove("max_bundle_size");
        }
        if ((str = props.getProperty("max_bundle_timeout")) != null) {
            this.max_bundle_timeout = Long.parseLong(str);
            if (this.max_bundle_timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_timeout of " + this.max_bundle_timeout + " is invalid"));
                }
                return false;
            }
            props.remove("max_bundle_timeout");
        }
        if ((str = props.getProperty("enable_bundling")) != null) {
            this.enable_bundling = Boolean.valueOf(str);
            props.remove("enable_bundling");
        }
        if ((str = props.getProperty("use_addr_translation")) != null) {
            this.use_addr_translation = Boolean.valueOf(str);
            props.remove("use_addr_translation");
        }
        if ((str = props.getProperty("enable_diagnostics")) != null) {
            this.enable_diagnostics = Boolean.valueOf(str);
            props.remove("enable_diagnostics");
        }
        if ((str = props.getProperty("diagnostics_addr")) != null) {
            this.diagnostics_addr = str;
            props.remove("diagnostics_addr");
        }
        if ((str = props.getProperty("diagnostics_port")) != null) {
            this.diagnostics_port = Integer.parseInt(str);
            props.remove("diagnostics_port");
        }
        if (this.enable_bundling) {
            // empty if block
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        block15: {
            Address dest;
            boolean multicast;
            if (evt.getType() != 1) {
                this.handleDownEvent(evt);
                return;
            }
            Message msg = (Message)evt.getArg();
            if (this.header != null) {
                msg.putHeader(this.name, this.header);
            }
            if (this.observer != null) {
                this.observer.passDown(evt);
            }
            this.setSourceAddress(msg);
            if (this.trace) {
                StringBuffer sb = new StringBuffer("sending msg to ").append(msg.getDest()).append(" (src=").append(msg.getSrc()).append("), headers are ").append(msg.getHeaders());
                this.log.trace((Object)sb.toString());
            }
            boolean bl = multicast = (dest = msg.getDest()) == null || dest.isMulticastAddress();
            if (this.loopback && (multicast || dest.equals(this.local_addr))) {
                Message copy = msg.copy();
                copy.setSrc(this.local_addr);
                if (this.trace) {
                    this.log.trace((Object)new StringBuffer("looping back message ").append(copy));
                }
                try {
                    this.incoming_msg_queue.add(copy);
                }
                catch (QueueClosedException e) {
                    // empty catch block
                }
                if (!multicast) {
                    return;
                }
            }
            try {
                if (this.use_outgoing_packet_handler) {
                    this.outgoing_queue.put((Object)msg);
                } else {
                    this.send(msg, dest, multicast);
                }
            }
            catch (QueueClosedException closed_ex) {
            }
            catch (InterruptedException interruptedEx) {
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) break block15;
                this.log.error((Object)"failed sending message", e);
            }
        }
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    protected final void receive(Address dest, Address sender, byte[] data, int offset, int length) {
        block6: {
            boolean mcast;
            if (data == null) {
                return;
            }
            boolean bl = mcast = dest == null || dest.isMulticastAddress();
            if (this.trace) {
                StringBuffer sb = new StringBuffer("received (");
                sb.append(mcast ? "mcast)" : "ucast) ").append(length).append(" bytes from ").append(sender);
                this.log.trace((Object)sb.toString());
            }
            try {
                if (this.use_incoming_packet_handler) {
                    byte[] tmp = new byte[length];
                    System.arraycopy(data, offset, tmp, 0, length);
                    this.incoming_packet_queue.add(new IncomingQueueEntry(dest, sender, tmp, offset, length));
                } else {
                    this.handleIncomingPacket(dest, sender, data, offset, length);
                }
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block6;
                this.log.error((Object)new StringBuffer("failed handling data from ").append(sender), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingPacket(Address dest, Address sender, byte[] data, int offset, int length) {
        block19: {
            Message msg = null;
            org.jgroups.util.List l = null;
            try {
                boolean multicast;
                boolean is_message_list;
                ExposedByteArrayInputStream exposedByteArrayInputStream = this.in_stream;
                synchronized (exposedByteArrayInputStream) {
                    byte flags;
                    this.in_stream.setData(data, offset, length);
                    this.buf_in_stream.reset(length);
                    short version = this.dis.readShort();
                    if (!Version.compareTo(version)) {
                        if (this.warn) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("packet from ").append(sender).append(" has different version (").append(version);
                            sb.append(") from ours (").append(Version.printVersion()).append("). ");
                            if (this.discard_incompatible_packets) {
                                sb.append("Packet is discarded");
                            } else {
                                sb.append("This may cause problems");
                            }
                            this.log.warn((Object)sb);
                        }
                        if (this.discard_incompatible_packets) {
                            return;
                        }
                    }
                    is_message_list = ((flags = this.dis.readByte()) & 1) == 1;
                    boolean bl = multicast = (flags & 2) == 2;
                    if (is_message_list) {
                        l = this.bufferToList(this.dis, dest, multicast);
                    } else {
                        msg = this.bufferToMessage(this.dis, dest, sender, multicast);
                    }
                }
                LinkedList msgs = new LinkedList();
                if (is_message_list) {
                    Enumeration en = l.elements();
                    while (en.hasMoreElements()) {
                        msgs.add(en.nextElement());
                    }
                } else {
                    msgs.add(msg);
                }
                Iterator it = msgs.iterator();
                while (it.hasNext()) {
                    msg = (Message)it.next();
                    Address src = msg.getSrc();
                    if (this.loopback) {
                        if (!multicast || src == null || !this.local_addr.equals(src)) continue;
                        it.remove();
                        continue;
                    }
                    this.handleIncomingMessage(msg);
                }
                if (this.incoming_msg_queue != null && msgs.size() > 0) {
                    this.incoming_msg_queue.addAll(msgs);
                }
            }
            catch (QueueClosedException closed_ex) {
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block19;
                this.log.error((Object)"failed unmarshalling message", t);
            }
        }
    }

    private void handleIncomingMessage(Message msg) {
        TpHeader hdr;
        if (this.stats) {
            ++this.num_msgs_received;
            this.num_bytes_received += (long)msg.getLength();
        }
        Event evt = new Event(1, msg);
        if (this.trace) {
            StringBuffer sb = new StringBuffer("message is ").append(msg).append(", headers are ").append(msg.getHeaders());
            this.log.trace((Object)sb);
        }
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if ((hdr = (TpHeader)msg.getHeader(this.name)) != null) {
            String ch_name = hdr.channel_name;
            if (ch_name != null && this.channel_name != null && !this.channel_name.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                if (this.warn) {
                    this.log.warn((Object)new StringBuffer("discarded message from different group \"").append(ch_name).append("\" (our group is \"").append(this.channel_name).append("\"). Sender was").append(msg.getSrc()));
                }
                return;
            }
        } else {
            if (this.trace) {
                this.log.trace((Object)new StringBuffer("message does not have a transport header, msg is ").append(msg).append(", headers are ").append(msg.getHeaders()).append(", will be discarded"));
            }
            return;
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message msg, Address dest, boolean multicast) throws Exception {
        if (this.enable_bundling) {
            this.bundler.send(msg, dest);
            return;
        }
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = this.out_stream;
        synchronized (exposedByteArrayOutputStream) {
            Buffer buf = this.messageToBuffer(msg, multicast);
            this.doSend(buf, dest, multicast);
        }
    }

    private void doSend(Buffer buf, Address dest, boolean multicast) throws Exception {
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        if (multicast) {
            this.sendToAllMembers(buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.sendToSingleMember(dest, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    private Buffer messageToBuffer(Message msg, boolean multicast) throws Exception {
        int flags = 0;
        this.out_stream.reset();
        this.buf_out_stream.reset(this.out_stream.getCapacity());
        this.dos.reset();
        this.dos.writeShort(2291);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        this.dos.writeByte(flags);
        msg.writeTo(this.dos);
        this.dos.flush();
        Buffer retval = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
        return retval;
    }

    private Message bufferToMessage(DataInputStream instream, Address dest, Address sender, boolean multicast) throws Exception {
        Message msg = new Message(false);
        msg.readFrom(instream);
        this.postUnmarshalling(msg, dest, sender, multicast);
        return msg;
    }

    private Buffer listToBuffer(org.jgroups.util.List l, boolean multicast) throws Exception {
        int flags = 0;
        int len = l != null ? l.size() : 0;
        boolean src_written = false;
        this.out_stream.reset();
        this.buf_out_stream.reset(this.out_stream.getCapacity());
        this.dos.reset();
        this.dos.writeShort(2291);
        flags = (byte)(flags + 1);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        this.dos.writeByte(flags);
        this.dos.writeInt(len);
        Enumeration en = l.elements();
        while (en.hasMoreElements()) {
            Message msg = (Message)en.nextElement();
            Address src = msg.getSrc();
            if (!src_written) {
                Util.writeAddress(src, this.dos);
                src_written = true;
            }
            msg.writeTo(this.dos);
        }
        this.dos.flush();
        Buffer retval = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.jgroups.util.List bufferToList(DataInputStream instream, Address dest, boolean multicast) throws Exception {
        org.jgroups.util.List l = new org.jgroups.util.List();
        InputStream in = null;
        try {
            int len = instream.readInt();
            Address src = Util.readAddress(instream);
            for (int i = 0; i < len; ++i) {
                Message msg = new Message(false);
                msg.readFrom(instream);
                this.postUnmarshallingList(msg, dest, multicast);
                msg.setSrc(src);
                l.add(msg);
            }
            org.jgroups.util.List list = l;
            return list;
        }
        finally {
            Util.closeInputStream(in);
        }
    }

    private List parseInterfaceList(String s) throws Exception {
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>(10);
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String interface_name = tok.nextToken();
            NetworkInterface intf = NetworkInterface.getByName(interface_name);
            if (intf == null) {
                intf = NetworkInterface.getByInetAddress(InetAddress.getByName(interface_name));
            }
            if (intf == null) {
                throw new Exception("interface " + interface_name + " not found");
            }
            if (interfaces.contains(intf)) {
                this.log.warn((Object)("did not add interface " + interface_name + " (already present in " + this.print(interfaces) + ")"));
                continue;
            }
            interfaces.add(intf);
        }
        return interfaces;
    }

    private String print(List interfaces) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = interfaces.iterator();
        while (it.hasNext()) {
            NetworkInterface intf = (NetworkInterface)it.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(intf.getName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.view = (View)evt.getArg();
                    this.members.clear();
                    Vector tmpvec = this.view.getMembers();
                    this.members.addAll(tmpvec);
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                this.header = new TpHeader(this.channel_name);
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    protected void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    private class DiagnosticsHandler
    implements Runnable {
        Thread t = null;
        MulticastSocket diag_sock = null;

        DiagnosticsHandler() {
        }

        void start() throws IOException {
            this.diag_sock = new MulticastSocket(TP.this.diagnostics_port);
            List interfaces = Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.diag_sock);
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "DiagnosticsHandler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (this.diag_sock != null) {
                this.diag_sock.close();
            }
            this.t = null;
        }

        public void run() {
            byte[] buf = new byte[1500];
            while (!this.diag_sock.isClosed() && Thread.currentThread().equals(this.t)) {
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                try {
                    this.diag_sock.receive(packet);
                    TP.this.handleDiagnosticProbe(packet.getSocketAddress(), this.diag_sock, new String(packet.getData(), packet.getOffset(), packet.getLength()));
                }
                catch (IOException iOException) {}
            }
        }

        private void bindToInterfaces(List interfaces, MulticastSocket s) throws IOException {
            InetSocketAddress group_addr = new InetSocketAddress(TP.this.diagnostics_addr, TP.this.diagnostics_port);
            Iterator it = interfaces.iterator();
            while (it.hasNext()) {
                NetworkInterface i = (NetworkInterface)it.next();
                try {
                    s.joinGroup(group_addr, i);
                    if (!TP.this.trace) continue;
                    TP.this.log.trace((Object)("joined " + group_addr + " on " + i.getName()));
                }
                catch (IOException e) {
                    TP.this.log.warn((Object)("failed to join " + group_addr + " on " + i.getName() + ": " + e));
                }
            }
        }
    }

    private class Bundler {
        final HashMap msgs = new HashMap(36);
        long count = 0L;
        int num_msgs = 0;
        long start = 0L;
        BundlingTimer bundling_timer = null;

        private Bundler() {
        }

        private synchronized void send(Message msg, Address dest) throws Exception {
            long length = msg.size();
            this.checkLength(length);
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            if (this.count + length >= (long)TP.this.max_bundle_size) {
                this.cancelTimer();
                this.bundleAndSend();
            }
            this.addMessage(msg, dest);
            this.count += length;
            this.startTimer();
        }

        private void startTimer() {
            if (this.bundling_timer == null || this.bundling_timer.cancelled()) {
                this.bundling_timer = new BundlingTimer();
                TP.this.timer.add(this.bundling_timer);
            }
        }

        private void cancelTimer() {
            if (this.bundling_timer != null) {
                this.bundling_timer.cancel();
                this.bundling_timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMessage(Message msg, Address dest) {
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                org.jgroups.util.List tmp = (org.jgroups.util.List)this.msgs.get(dest);
                if (tmp == null) {
                    tmp = new org.jgroups.util.List();
                    this.msgs.put(dest, tmp);
                }
                tmp.add(msg);
                ++this.num_msgs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void bundleAndSend() {
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                if (this.msgs.size() == 0) {
                    return;
                }
                try {
                    if (TP.this.trace) {
                        long stop = System.currentTimeMillis();
                        double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                        StringBuffer sb = new StringBuffer("sending ").append(this.num_msgs).append(" msgs (");
                        sb.append(this.count).append(" bytes (" + f.format(percentage) + "% of max_bundle_size), collected in " + (stop - this.start) + "ms) to ").append(this.msgs.size()).append(" destination(s)");
                        if (this.msgs.size() > 1) {
                            sb.append(" (dests=").append(this.msgs.keySet()).append(")");
                        }
                        TP.this.log.trace((Object)sb.toString());
                    }
                    Iterator it = this.msgs.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        org.jgroups.util.List l = (org.jgroups.util.List)entry.getValue();
                        if (l.size() == 0) continue;
                        Address dst = (Address)entry.getKey();
                        boolean multicast = dst == null || dst.isMulticastAddress();
                        ExposedByteArrayOutputStream exposedByteArrayOutputStream = TP.this.out_stream;
                        synchronized (exposedByteArrayOutputStream) {
                            block13: {
                                try {
                                    Buffer buffer = TP.this.listToBuffer(l, multicast);
                                    TP.this.doSend(buffer, dst, multicast);
                                }
                                catch (Throwable e) {
                                    if (!TP.this.log.isErrorEnabled()) break block13;
                                    TP.this.log.error((Object)"exception sending msg", e);
                                }
                            }
                        }
                    }
                    return;
                }
                finally {
                    this.msgs.clear();
                    this.num_msgs = 0;
                    this.start = 0L;
                    this.count = 0L;
                }
            }
        }

        private void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG and TP correctly");
            }
        }

        private class BundlingTimer
        implements TimeScheduler.Task {
            boolean cancelled = false;

            private BundlingTimer() {
            }

            void cancel() {
                this.cancelled = true;
            }

            public boolean cancelled() {
                return this.cancelled;
            }

            public long nextInterval() {
                return ((Bundler)Bundler.this).TP.this.max_bundle_timeout;
            }

            public void run() {
                Bundler.this.bundleAndSend();
                this.cancelled = true;
            }
        }
    }

    private class BundlingOutgoingPacketHandler
    extends OutgoingPacketHandler {
        final HashMap msgs;
        long count;
        int num_msgs;
        long start;
        long wait_time;

        private BundlingOutgoingPacketHandler() {
            this.msgs = new HashMap(11);
            this.count = 0L;
            this.num_msgs = 0;
            this.start = 0L;
            this.wait_time = 0L;
        }

        private void init() {
            this.count = 0L;
            this.start = 0L;
            this.wait_time = 0L;
        }

        void start() {
            this.init();
            super.start();
            this.t.setName("BundlingOutgoingPacketHandler");
        }

        void stop() {
            super.stop();
        }

        public void run() {
            while (this.t != null && Thread.currentThread().equals(this.t)) {
                try {
                    Message msg = (Message)TP.this.outgoing_queue.poll(this.wait_time);
                    if (msg == null) {
                        throw new TimeoutException();
                    }
                    long length = msg.size();
                    this.checkLength(length);
                    if (this.start == 0L) {
                        this.start = System.currentTimeMillis();
                    }
                    if (this.count + length >= (long)TP.this.max_bundle_size) {
                        this.bundleAndSend();
                        this.count = 0L;
                        this.start = System.currentTimeMillis();
                    }
                    this.addMessage(msg);
                    this.count += length;
                    this.wait_time = TP.this.max_bundle_timeout - (System.currentTimeMillis() - this.start);
                    if (this.wait_time > 0L) continue;
                    this.bundleAndSend();
                    this.init();
                }
                catch (QueueClosedException queue_closed_ex) {
                    this.bundleAndSend();
                    break;
                }
                catch (TimeoutException timeout_ex) {
                    this.bundleAndSend();
                    this.init();
                }
                catch (Throwable ex) {
                    TP.this.log.error((Object)"failure in bundling", ex);
                }
            }
            if (TP.this.trace) {
                TP.this.log.trace((Object)"BundlingOutgoingPacketHandler thread terminated");
            }
        }

        private void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG and TP correctly");
            }
        }

        private void addMessage(Message msg) {
            Address dst = msg.getDest();
            org.jgroups.util.List tmp = (org.jgroups.util.List)this.msgs.get(dst);
            if (tmp == null) {
                tmp = new org.jgroups.util.List();
                this.msgs.put(dst, tmp);
            }
            tmp.add(msg);
            ++this.num_msgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void bundleAndSend() {
            long stop_time = System.currentTimeMillis();
            if (this.msgs.size() == 0) {
                return;
            }
            try {
                if (TP.this.trace) {
                    StringBuffer sb = new StringBuffer("sending ").append(this.num_msgs).append(" msgs (");
                    sb.append(this.count).append(" bytes, ").append(stop_time - this.start).append("ms)");
                    sb.append(" to ").append(this.msgs.size()).append(" destination(s)");
                    if (this.msgs.size() > 1) {
                        sb.append(" (dests=").append(this.msgs.keySet()).append(")");
                    }
                    TP.this.log.trace((Object)sb.toString());
                }
                Iterator it = this.msgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    org.jgroups.util.List l = (org.jgroups.util.List)entry.getValue();
                    if (l.size() == 0) continue;
                    Address dst = (Address)entry.getKey();
                    boolean multicast = dst == null || dst.isMulticastAddress();
                    ExposedByteArrayOutputStream exposedByteArrayOutputStream = TP.this.out_stream;
                    synchronized (exposedByteArrayOutputStream) {
                        block11: {
                            try {
                                Buffer buffer = TP.this.listToBuffer(l, multicast);
                                TP.this.doSend(buffer, dst, multicast);
                            }
                            catch (Throwable e) {
                                if (!TP.this.log.isErrorEnabled()) break block11;
                                TP.this.log.error((Object)"exception sending msg", e);
                            }
                        }
                    }
                }
                return;
            }
            finally {
                this.msgs.clear();
                this.num_msgs = 0;
            }
        }
    }

    class OutgoingPacketHandler
    implements Runnable {
        Thread t = null;
        byte[] buf;
        DatagramPacket packet;

        OutgoingPacketHandler() {
        }

        void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "OutgoingPacketHandler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            Thread tmp = this.t;
            this.t = null;
            if (tmp != null) {
                tmp.interrupt();
            }
        }

        public void run() {
            while (this.t != null && Thread.currentThread().equals(this.t)) {
                Message msg;
                block6: {
                    try {
                        msg = (Message)TP.this.outgoing_queue.take();
                        this.handleMessage(msg);
                    }
                    catch (QueueClosedException closed_ex) {
                        break;
                    }
                    catch (InterruptedException interruptedEx) {
                    }
                    catch (Throwable th) {
                        if (!TP.this.log.isErrorEnabled()) break block6;
                        TP.this.log.error((Object)"exception sending packet", th);
                    }
                }
                msg = null;
            }
            if (TP.this.trace) {
                TP.this.log.trace((Object)"outgoing message handler terminating");
            }
        }

        protected void handleMessage(Message msg) throws Throwable {
            Address dest;
            TP.this.send(msg, dest, (dest = msg.getDest()) == null || dest.isMulticastAddress());
        }
    }

    class IncomingMessageHandler
    implements Runnable {
        Thread t;
        int i = 0;

        IncomingMessageHandler() {
        }

        public void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "IncomingMessageHandler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            TP.this.incoming_msg_queue.close(true);
            this.t = null;
        }

        public void run() {
            while (!TP.this.incoming_msg_queue.closed() && Thread.currentThread().equals(this.t)) {
                try {
                    Message msg = (Message)TP.this.incoming_msg_queue.remove();
                    TP.this.handleIncomingMessage(msg);
                }
                catch (QueueClosedException closed_ex) {
                    break;
                }
                catch (Throwable ex) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error((Object)"error processing incoming message", ex);
                }
            }
            if (TP.this.trace) {
                TP.this.log.trace((Object)"incoming message handler terminating");
            }
        }
    }

    class IncomingPacketHandler
    implements Runnable {
        Thread t = null;

        IncomingPacketHandler() {
        }

        void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "IncomingPacketHandler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            TP.this.incoming_packet_queue.close(true);
            this.t = null;
        }

        public void run() {
            while (!TP.this.incoming_packet_queue.closed() && Thread.currentThread().equals(this.t)) {
                try {
                    IncomingQueueEntry entry = (IncomingQueueEntry)TP.this.incoming_packet_queue.remove();
                    TP.this.handleIncomingPacket(entry.dest, entry.sender, entry.buf, entry.offset, entry.length);
                }
                catch (QueueClosedException closed_ex) {
                    break;
                }
                catch (Throwable ex) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error((Object)"error processing incoming packet", ex);
                }
            }
            if (TP.this.trace) {
                TP.this.log.trace((Object)"incoming packet handler terminating");
            }
        }
    }

    class IncomingQueueEntry {
        Address dest = null;
        Address sender = null;
        byte[] buf;
        int offset;
        int length;

        IncomingQueueEntry(Address dest, Address sender, byte[] buf, int offset, int length) {
            this.dest = dest;
            this.sender = sender;
            this.buf = buf;
            this.offset = offset;
            this.length = length;
        }
    }
}

