/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.PoolBackedDataSourceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.DataSource;

public final class PSLoadPoolBackedDataSource {
    static final String INSERT_STMT = "INSERT INTO testpbds VALUES ( ? , ? )";
    static final String SELECT_STMT = "SELECT count(*) FROM testpbds";
    static Random random = new Random();
    static DataSource ds;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            block8: {
                ds = PoolBackedDataSourceFactory.create("org.postgresql.Driver", "jdbc:postgresql://localhost/test", "swaldman", "test", 3, 15, 5, 30, 6);
                Connection connection = null;
                Statement statement = null;
                try {
                    Object var5_4;
                    try {
                        connection = ds.getConnection();
                        statement = connection.createStatement();
                        statement.executeUpdate("CREATE TABLE testpbds ( a varchar(16), b varchar(16) )");
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        System.err.println("relation testpbds already exists, or something bad happened.");
                        var5_4 = null;
                        StatementUtils.attemptClose(statement);
                        ConnectionUtils.attemptClose(connection);
                        break block8;
                    }
                    var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    StatementUtils.attemptClose(statement);
                    ConnectionUtils.attemptClose(connection);
                    throw throwable;
                }
                StatementUtils.attemptClose(statement);
                ConnectionUtils.attemptClose(connection);
            }
            int n = 0;
            while (true) {
                if (n >= 50) {
                    return;
                }
                ChurnThread churnThread = new ChurnThread();
                churnThread.start();
                System.out.println("THREAD MADE [" + n + "]");
                Thread.sleep(1000L);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void executeInsert(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(INSERT_STMT);
            preparedStatement.setInt(1, random.nextInt());
            preparedStatement.setInt(2, random.nextInt());
            preparedStatement.executeUpdate();
            System.out.println("INSERTION");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            StatementUtils.attemptClose(preparedStatement);
            throw throwable;
        }
        StatementUtils.attemptClose(preparedStatement);
    }

    static void executeSelect(Connection connection) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_STMT);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            System.out.println("SELECT [count=" + resultSet.getInt(1) + ", time=" + (System.currentTimeMillis() - l) + " msecs]");
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(preparedStatement);
            throw throwable;
        }
        ResultSetUtils.attemptClose(resultSet);
        StatementUtils.attemptClose(preparedStatement);
    }

    static class ChurnThread
    extends Thread {
        ChurnThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object var4_4;
                    Connection connection = null;
                    try {
                        connection = ds.getConnection();
                        boolean bl = random.nextBoolean();
                        if (bl) {
                            PSLoadPoolBackedDataSource.executeSelect(connection);
                        } else {
                            PSLoadPoolBackedDataSource.executeInsert(connection);
                        }
                        var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        var4_4 = null;
                        ConnectionUtils.attemptClose(connection);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

