/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.PoolBackedDataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.DataSource;

public final class LoadPoolBackedDataSource {
    static Random random = new Random();
    static DataSource ds;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            block8: {
                ds = PoolBackedDataSourceFactory.create("org.postgresql.Driver", "jdbc:postgresql://localhost/test", "swaldman", "test");
                Connection connection = null;
                Statement statement = null;
                try {
                    Object var5_4;
                    try {
                        connection = ds.getConnection();
                        statement = connection.createStatement();
                        statement.executeUpdate("CREATE TABLE testpbds ( a varchar(16), b varchar(16) )");
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        System.err.println("relation testpbds already exists, or something bad happened.");
                        var5_4 = null;
                        StatementUtils.attemptClose(statement);
                        ConnectionUtils.attemptClose(connection);
                        break block8;
                    }
                    var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    StatementUtils.attemptClose(statement);
                    ConnectionUtils.attemptClose(connection);
                    throw throwable;
                }
                StatementUtils.attemptClose(statement);
                ConnectionUtils.attemptClose(connection);
            }
            int n = 0;
            while (true) {
                if (n >= 50) {
                    return;
                }
                ChurnThread churnThread = new ChurnThread();
                churnThread.start();
                System.out.println("THREAD MADE [" + n + "]");
                Thread.sleep(1000L);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void executeInsert(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("INSERT INTO testpbds VALUES ('" + random.nextInt() + "', '" + random.nextInt() + "')");
            System.out.println("INSERTION");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            StatementUtils.attemptClose(statement);
            throw throwable;
        }
        StatementUtils.attemptClose(statement);
    }

    static void executeSelect(Connection connection) throws SQLException {
        long l = System.currentTimeMillis();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT count(*) FROM testpbds");
            resultSet.next();
            System.out.println("SELECT [count=" + resultSet.getInt(1) + ", time=" + (System.currentTimeMillis() - l) + " msecs]");
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(statement);
            throw throwable;
        }
        ResultSetUtils.attemptClose(resultSet);
        StatementUtils.attemptClose(statement);
    }

    static class ChurnThread
    extends Thread {
        ChurnThread() {
        }

        public void run() {
            try {
                while (true) {
                    Object var4_4;
                    Connection connection = null;
                    try {
                        connection = ds.getConnection();
                        boolean bl = random.nextBoolean();
                        if (bl) {
                            LoadPoolBackedDataSource.executeSelect(connection);
                        } else {
                            LoadPoolBackedDataSource.executeInsert(connection);
                        }
                        var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        var4_4 = null;
                        ConnectionUtils.attemptClose(connection);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(connection);
                    Thread.sleep(random.nextInt(1000));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

