/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public final class GooGooStatementCache {
    HashMap cxnToStmtSets = new HashMap();
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    TreeMap longsToStmts = new TreeMap();
    HashMap stmtsToLongs = new HashMap();
    HashSet checkedOut = new HashSet();
    long last_long = -1L;
    int stmt_count;
    AsynchronousRunner blockingTaskAsyncRunner;
    int max_statements;

    public GooGooStatementCache(AsynchronousRunner asynchronousRunner, int n) {
        this.blockingTaskAsyncRunner = asynchronousRunner;
        this.max_statements = n;
    }

    public synchronized Object checkoutStatement(Connection connection, Method method, Object[] objectArray) throws SQLException {
        Object object = null;
        StatementCacheKey statementCacheKey = StatementCacheKey.find(connection, method, objectArray);
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        if (linkedList == null || linkedList.isEmpty()) {
            object = this.acquireStatement(connection, method, objectArray);
            int n = this.countCachedStatements();
            if (n < this.max_statements || n == this.max_statements && this.cullFromDeathmarch()) {
                this.assimilateNewCheckedOutStatement(statementCacheKey, connection, object);
            }
        } else {
            object = linkedList.get(0);
            linkedList.remove(0);
            this.undeathmarchStatement(object);
            if (!this.checkedOut.add(object)) {
                throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
            }
        }
        return object;
    }

    public synchronized void checkinStatement(Object object) throws SQLException {
        if (!this.checkedOut.remove(object)) {
            if (!this.ourResource(object)) {
                this.destroyStatement(object);
            }
            return;
        }
        try {
            this.refreshStatement((PreparedStatement)object);
        }
        catch (Exception exception) {
            System.err.println("Problem with checked-in Statement, discarding.");
            exception.printStackTrace();
            this.removeStatement(object, true);
            return;
        }
        StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.get(object);
        if (statementCacheKey == null) {
            throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
        }
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        linkedList.add(object);
        this.deathmarchStatement(object);
    }

    public synchronized void checkinAll(Connection connection) throws SQLException {
        HashSet hashSet = this.connectionSet(connection);
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.checkedOut.contains(e)) continue;
                this.checkinStatement(e);
            }
        }
    }

    public synchronized void closeAll(Connection connection) throws SQLException {
        HashSet hashSet = this.connectionSet(connection);
        if (hashSet != null) {
            HashSet hashSet2 = (HashSet)hashSet.clone();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.removeStatement(e, true);
            }
        }
    }

    public synchronized void close() throws SQLException {
        Iterator iterator = this.stmtToKey.keySet().iterator();
        while (iterator.hasNext()) {
            this.destroyStatement(iterator.next());
        }
        this.cxnToStmtSets = null;
        this.stmtToKey = null;
        this.keyToKeyRec = null;
        this.longsToStmts = null;
        this.stmtsToLongs = null;
        this.checkedOut = null;
        this.stmt_count = -1;
    }

    private void destroyStatement(final Object object) {
        Runnable runnable = new Runnable(){

            public void run() {
                StatementUtils.attemptClose((PreparedStatement)object);
            }
        };
        this.blockingTaskAsyncRunner.postRunnable(runnable);
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey statementCacheKey, Connection connection, Object object) {
        this.stmtToKey.put(object, statementCacheKey);
        HashSet hashSet = this.keySet(statementCacheKey);
        if (hashSet == null) {
            this.keyToKeyRec.put(statementCacheKey, new KeyRec());
        }
        this.keySet(statementCacheKey).add(object);
        HashSet<Object> hashSet2 = this.connectionSet(connection);
        if (hashSet2 == null) {
            hashSet2 = new HashSet<Object>();
            this.cxnToStmtSets.put(connection, hashSet2);
        }
        hashSet2.add(object);
        ++this.stmt_count;
        this.checkedOut.add(object);
    }

    private void removeStatement(Object object, boolean bl) {
        StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.remove(object);
        this.removeFromKeySet(statementCacheKey, object);
        Connection connection = statementCacheKey.physicalConnection;
        this.removeFromConnectionSet(connection, object);
        --this.stmt_count;
        if (!this.checkedOut.contains(object)) {
            this.undeathmarchStatement(object);
            this.removeFromCheckoutQueue(statementCacheKey, object);
            this.destroyStatement(object);
        } else {
            this.checkedOut.remove(object);
            if (bl) {
                this.destroyStatement(object);
            }
        }
    }

    private boolean cullFromDeathmarch() {
        if (this.longsToStmts.isEmpty()) {
            return false;
        }
        Long l = (Long)this.longsToStmts.firstKey();
        Object v = this.longsToStmts.get(l);
        this.removeStatement(v, true);
        return true;
    }

    private Object acquireStatement(final Connection connection, final Method method, final Object[] objectArray) throws SQLException {
        try {
            final Object[] objectArray2 = new Object[1];
            final SQLException[] sQLExceptionArray = new SQLException[1];
            Runnable runnable = new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    GooGooStatementCache gooGooStatementCache;
                    try {
                        try {
                            objectArray2[0] = method.invoke((Object)connection, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getTargetException();
                            sQLExceptionArray[0] = throwable instanceof SQLException ? (SQLException)throwable : SqlUtils.toSQLException(throwable);
                            Object var4_2 = null;
                            GooGooStatementCache gooGooStatementCache3 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache3) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        catch (Exception exception) {
                            sQLExceptionArray[0] = SqlUtils.toSQLException(exception);
                            Object var4_3 = null;
                            GooGooStatementCache gooGooStatementCache4 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache4) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        Object var4_1 = null;
                        gooGooStatementCache = GooGooStatementCache.this;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        GooGooStatementCache gooGooStatementCache2 = GooGooStatementCache.this;
                        synchronized (gooGooStatementCache2) {
                            GooGooStatementCache.this.notifyAll();
                            throw throwable;
                        }
                    }
                    synchronized (gooGooStatementCache) {
                        GooGooStatementCache.this.notifyAll();
                        return;
                    }
                }
            };
            this.blockingTaskAsyncRunner.postRunnable(runnable);
            while (objectArray2[0] == null && sQLExceptionArray[0] == null) {
                this.wait();
            }
            if (sQLExceptionArray[0] != null) {
                throw sQLExceptionArray[0];
            }
            Object object = objectArray2[0];
            return object;
        }
        catch (InterruptedException interruptedException) {
            throw SqlUtils.toSQLException(interruptedException);
        }
    }

    private HashSet connectionSet(Connection connection) {
        return (HashSet)this.cxnToStmtSets.get(connection);
    }

    private boolean removeFromConnectionSet(Connection connection, Object object) {
        boolean bl;
        HashSet hashSet = (HashSet)this.cxnToStmtSets.get(connection);
        if (hashSet != null) {
            bl = hashSet.remove(object);
            if (hashSet.isEmpty()) {
                this.cxnToStmtSets.remove(connection);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private KeyRec keyRec(StatementCacheKey statementCacheKey) {
        return (KeyRec)this.keyToKeyRec.get(statementCacheKey);
    }

    private HashSet keySet(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey statementCacheKey, Object object) {
        HashSet hashSet = this.keySet(statementCacheKey);
        boolean bl = hashSet.remove(object);
        if (hashSet.isEmpty() && this.checkoutQueue(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private LinkedList checkoutQueue(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey statementCacheKey, Object object) {
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        boolean bl = linkedList.remove(object);
        if (linkedList.isEmpty() && this.keySet(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private void deathmarchStatement(Object object) {
        Long l = (Long)this.stmtsToLongs.get(object);
        if (l != null) {
            throw new RuntimeException("Internal inconsistency: A checking-in statement is already in deathmarch.");
        }
        l = this.getNextLong();
        this.stmtsToLongs.put(object, l);
        this.longsToStmts.put(l, object);
    }

    private void undeathmarchStatement(Object object) {
        Long l = (Long)this.stmtsToLongs.remove(object);
        if (l == null) {
            throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
        }
        Object v = this.longsToStmts.remove(l);
        if (l == null) {
            throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
        }
    }

    private boolean isCheckedIn(Object object) {
        return this.stmtsToLongs.keySet().contains(object);
    }

    private boolean ourResource(Object object) {
        return this.stmtToKey.keySet().contains(object);
    }

    private void refreshStatement(PreparedStatement preparedStatement) throws Exception {
        preparedStatement.clearParameters();
    }

    private int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private Long getNextLong() {
        return new Long(++this.last_long);
    }

    private void printStats() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.stmtsToLongs.size();
        int n4 = this.longsToStmts.size();
        int n5 = this.cxnToStmtSets.size();
        int n6 = this.keyToKeyRec.size();
        System.err.println("GooGooStatementCache stats:");
        System.err.println("\ttotal size: " + n);
        System.err.println("\tchecked out: " + n2);
        System.err.println("\tchecked in (deathmarch stmts): " + n3);
        System.err.println("\tchecked in (deathmarch longs): " + n4);
        System.err.println("\tnum connections: " + n5);
        System.err.println("\tnum keys: " + n6);
        if (n != n2 + n3 || n3 != n4) {
            throw new RuntimeException("Inconsistency!");
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }
}

