/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.util.ClosableResource;
import com.mchange.v2.c3p0.impl.C3P0CallableStatement;
import com.mchange.v2.c3p0.impl.C3P0PreparedStatement;
import com.mchange.v2.c3p0.impl.C3P0Statement;
import com.mchange.v2.c3p0.impl.SetManagedDatabaseMetaData;
import com.mchange.v2.c3p0.impl.SetManagedResultSet;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class C3P0PooledConnection
implements PooledConnection,
ClosableResource {
    static final ClassLoader CL = (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection).getClassLoader();
    static final Class[] PROXY_CTOR_ARGS = new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = C3P0PooledConnection.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler};
    static final Constructor CON_PROXY_CTOR;
    static final Constructor STMT_PROXY_CTOR;
    static final Constructor PSTMT_PROXY_CTOR;
    static final Constructor CSTMT_PROXY_CTOR;
    static final Constructor RS_PROXY_CTOR;
    static final Method RS_CLOSE_METHOD;
    static final Method STMT_CLOSE_METHOD;
    static final Object[] CLOSE_ARGS;
    final ConnectionEventSupport ces = new ConnectionEventSupport(this);
    volatile Connection physicalConnection;
    volatile ProxyConnection exposedProxy;
    final Set uncachedActiveStatements = Collections.synchronizedSet(new HashSet());
    volatile GooGooStatementCache scache;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$java$sql$ResultSet;

    private static Constructor createProxyConstructor(Class clazz) throws NoSuchMethodException {
        Class[] classArray = new Class[]{clazz};
        Class<?> clazz2 = Proxy.getProxyClass(CL, classArray);
        return clazz2.getConstructor(PROXY_CTOR_ARGS);
    }

    public C3P0PooledConnection(Connection connection) {
        this.physicalConnection = connection;
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    boolean isClosed() throws SQLException {
        return this.physicalConnection == null;
    }

    void initStatementCache(GooGooStatementCache gooGooStatementCache) {
        this.scache = gooGooStatementCache;
    }

    public Connection getConnection() throws SQLException {
        if (this.exposedProxy != null) {
            return this.exposedProxy;
        }
        try {
            this.ensureOkay();
            this.exposedProxy = this.createProxyConnection();
            return this.exposedProxy;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("Failed to acquire connection!");
        }
    }

    public void closeAll() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    public void close() throws SQLException {
        if (this.physicalConnection != null) {
            try {
                Exception exception = this.cleanupUncachedActiveStatements();
                if (exception != null) {
                    exception.printStackTrace();
                }
                try {
                    if (this.exposedProxy != null) {
                        this.exposedProxy.close();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    exception = exception2;
                }
                try {
                    this.closeAll();
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                    exception = exception3;
                }
                try {
                    this.physicalConnection.close();
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                    exception = exception4;
                }
                if (exception != null) {
                    throw new SQLException("At least one error occurred while attempting to close() the PooledConnection: " + exception);
                }
                Object var4_6 = null;
                this.physicalConnection = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.physicalConnection = null;
                throw throwable;
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.addConnectionEventListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.removeConnectionEventListener(connectionEventListener);
    }

    private void reset() throws SQLException {
        this.ensureOkay();
        if (!this.physicalConnection.getAutoCommit()) {
            this.physicalConnection.rollback();
            this.physicalConnection.setAutoCommit(true);
        }
    }

    boolean closeAndRemoveResultSets(Set set) {
        boolean bl = true;
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object var8_7;
                ResultSet resultSet = (ResultSet)iterator.next();
                try {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        bl = false;
                        var8_7 = null;
                        iterator.remove();
                        continue;
                    }
                    var8_7 = null;
                    iterator.remove();
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    iterator.remove();
                    throw throwable;
                }
            }
        }
        return bl;
    }

    void ensureOkay() throws SQLException {
        if (this.physicalConnection == null) {
            throw new SQLException("Connection is broken");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean closeAndRemoveResourcesInSet(Set set, Method method) {
        HashSet hashSet;
        boolean bl = true;
        Set set2 = set;
        synchronized (set2) {
            hashSet = new HashSet(set);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object var11_10;
            Object e = iterator.next();
            try {
                try {
                    method.invoke(e, CLOSE_ARGS);
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)exception).getTargetException();
                    }
                    throwable.printStackTrace();
                    bl = false;
                    var11_10 = null;
                    set.remove(e);
                    continue;
                }
                var11_10 = null;
                set.remove(e);
            }
            catch (Throwable throwable) {
                var11_10 = null;
                set.remove(e);
                throw throwable;
            }
        }
        return bl;
    }

    private SQLException cleanupUncachedActiveStatements() {
        boolean bl = this.closeAndRemoveResourcesInSet(this.uncachedActiveStatements, STMT_CLOSE_METHOD);
        if (bl) {
            return null;
        }
        return new SQLException("An exception occurred while trying to clean up orphaned resources.");
    }

    ProxyConnection createProxyConnection() throws Exception {
        ProxyConnectionInvocationHandler proxyConnectionInvocationHandler = new ProxyConnectionInvocationHandler();
        return (ProxyConnection)CON_PROXY_CTOR.newInstance(proxyConnectionInvocationHandler);
    }

    Statement createProxyStatement(Statement statement, Constructor constructor) throws Exception {
        return this.createProxyStatement(false, statement, constructor);
    }

    Statement createProxyStatement(final boolean bl, final Statement statement, Constructor constructor) throws Exception {
        final Set set = Collections.synchronizedSet(new HashSet());
        final SetManagedResultSet setManagedResultSet = new SetManagedResultSet(set);
        if (statement instanceof CallableStatement) {
            return new C3P0CallableStatement((CallableStatement)statement){
                WrapperStatementHelper wsh;
                {
                    class WrapperStatementHelper {
                        Statement wrappedStmt;
                        private final /* synthetic */ boolean val$inner_is_cached;
                        private final /* synthetic */ Set val$activeResultSets;
                        private final /* synthetic */ SetManagedResultSet val$mainResultSet;
                        private final /* synthetic */ Statement val$innerStmt;

                        public WrapperStatementHelper(boolean bl, Set set, SetManagedResultSet setManagedResultSet, Statement statement, Statement statement2) {
                            this.val$inner_is_cached = bl;
                            this.val$activeResultSets = set;
                            this.val$mainResultSet = setManagedResultSet;
                            this.val$innerStmt = statement;
                            this.wrappedStmt = statement2;
                            if (!bl) {
                                C3P0PooledConnection.this.uncachedActiveStatements.add(statement2);
                            }
                        }

                        private boolean closeAndRemoveActiveResultSets() {
                            return C3P0PooledConnection.this.closeAndRemoveResultSets(this.val$activeResultSets);
                        }

                        public ResultSet wrap(ResultSet resultSet) {
                            if (this.val$mainResultSet.getInner() == null) {
                                this.val$mainResultSet.setInner(resultSet);
                                return this.val$mainResultSet;
                            }
                            SetManagedResultSet setManagedResultSet = new SetManagedResultSet(this.val$activeResultSets);
                            setManagedResultSet.setInner(resultSet);
                            return setManagedResultSet;
                        }

                        public void doClose() throws SQLException {
                            boolean bl = this.closeAndRemoveActiveResultSets();
                            if (this.val$inner_is_cached) {
                                C3P0PooledConnection.this.scache.checkinStatement(this.val$innerStmt);
                            } else {
                                this.val$innerStmt.close();
                                C3P0PooledConnection.this.uncachedActiveStatements.remove(this.wrappedStmt);
                            }
                            if (!bl) {
                                throw new SQLException("Failed to close an orphaned ResultSet properly.");
                            }
                        }
                    }
                    this.wsh = new WrapperStatementHelper(bl, set, setManagedResultSet, statement, this);
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet executeQuery(String string) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(string));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            };
        }
        if (statement instanceof PreparedStatement) {
            return new C3P0PreparedStatement((PreparedStatement)statement){
                WrapperStatementHelper wsh;
                {
                    this.wsh = new WrapperStatementHelper(bl, set, setManagedResultSet, statement, this);
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet executeQuery(String string) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(string));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            };
        }
        return new C3P0Statement(statement){
            WrapperStatementHelper wsh;
            {
                this.wsh = new WrapperStatementHelper(bl, set, setManagedResultSet, statement, this);
            }

            public ResultSet getResultSet() throws SQLException {
                return this.wsh.wrap(super.getResultSet());
            }

            public ResultSet executeQuery(String string) throws SQLException {
                return this.wsh.wrap(super.executeQuery(string));
            }

            public void close() throws SQLException {
                this.wsh.doClose();
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            CON_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection$ProxyConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection);
            STMT_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$Statement == null ? (class$java$sql$Statement = C3P0PooledConnection.class$("java.sql.Statement")) : class$java$sql$Statement);
            PSTMT_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = C3P0PooledConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
            CSTMT_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = C3P0PooledConnection.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement);
            RS_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = C3P0PooledConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet);
            Class[] classArray = new Class[]{};
            RS_CLOSE_METHOD = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = C3P0PooledConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("close", classArray);
            STMT_CLOSE_METHOD = (class$java$sql$Statement == null ? (class$java$sql$Statement = C3P0PooledConnection.class$("java.sql.Statement")) : class$java$sql$Statement).getMethod("close", classArray);
            CLOSE_ARGS = new Object[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Something is very wrong, or this is a pre 1.3 JVM.We cannot set up dynamic proxies and/or methods!");
        }
    }

    static interface ProxyConnection
    extends Connection {
        public void silentClose() throws SQLException;
    }

    class ProxyConnectionInvocationHandler
    implements InvocationHandler {
        volatile Connection activeConnection;
        volatile DatabaseMetaData metaData;
        final Set activeMetaDataResultSets;

        ProxyConnectionInvocationHandler() {
            this.activeConnection = C3P0PooledConnection.this.physicalConnection;
            this.metaData = null;
            this.activeMetaDataResultSets = Collections.synchronizedSet(new HashSet());
        }

        private Exception doSilentClose(Object object) {
            if (C3P0PooledConnection.this.exposedProxy == object) {
                C3P0PooledConnection.this.exposedProxy = null;
            }
            this.activeConnection = null;
            Throwable throwable = null;
            Exception exception = null;
            SQLException sQLException = null;
            Throwable throwable2 = null;
            Exception exception2 = null;
            try {
                C3P0PooledConnection.this.reset();
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
                exception = exception3;
            }
            sQLException = C3P0PooledConnection.this.cleanupUncachedActiveStatements();
            if (sQLException != null) {
                sQLException.printStackTrace();
            }
            if (!C3P0PooledConnection.this.closeAndRemoveResultSets(this.activeMetaDataResultSets)) {
                throwable2 = new SQLException("Failed to close some DatabaseMetaData Result Sets.");
            }
            if (throwable2 != null) {
                throwable2.printStackTrace();
            }
            if (C3P0PooledConnection.this.scache != null) {
                try {
                    C3P0PooledConnection.this.scache.checkinAll(C3P0PooledConnection.this.physicalConnection);
                }
                catch (Exception exception4) {
                    exception2 = exception4;
                }
                if (exception2 != null) {
                    exception2.printStackTrace();
                }
            }
            if (exception != null) {
                throwable = exception;
            } else if (sQLException != null) {
                throwable = sQLException;
            } else if (throwable2 != null) {
                throwable = throwable2;
            } else if (exception2 != null) {
                throwable = exception2;
            }
            return throwable;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            C3P0PooledConnection.this.ensureOkay();
            try {
                String string = method.getName();
                if (this.activeConnection != null) {
                    if (string.equals("createStatement")) {
                        Object object2 = method.invoke((Object)this.activeConnection, objectArray);
                        return C3P0PooledConnection.this.createProxyStatement((Statement)object2, STMT_PROXY_CTOR);
                    }
                    if (string.equals("prepareStatement")) {
                        if (C3P0PooledConnection.this.scache == null) {
                            Object object3 = method.invoke((Object)this.activeConnection, objectArray);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)object3, PSTMT_PROXY_CTOR);
                        }
                        Object object4 = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, method, objectArray);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)object4, PSTMT_PROXY_CTOR);
                    }
                    if (string.equals("prepareCall")) {
                        if (C3P0PooledConnection.this.scache == null) {
                            Object object5 = method.invoke((Object)this.activeConnection, objectArray);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)object5, CSTMT_PROXY_CTOR);
                        }
                        Object object6 = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, method, objectArray);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)object6, CSTMT_PROXY_CTOR);
                    }
                    if (string.equals("getMetaData")) {
                        DatabaseMetaData databaseMetaData = this.activeConnection.getMetaData();
                        if (this.metaData == null) {
                            this.metaData = new SetManagedDatabaseMetaData(databaseMetaData, this.activeMetaDataResultSets);
                        }
                        return this.metaData;
                    }
                    if (string.equals("silentClose")) {
                        this.doSilentClose(object);
                        return null;
                    }
                    if (string.equals("close")) {
                        Exception exception = this.doSilentClose(object);
                        C3P0PooledConnection.this.ces.fireConnectionClosed();
                        if (exception != null) {
                            throw exception;
                        }
                        return null;
                    }
                    return method.invoke((Object)this.activeConnection, objectArray);
                }
                if (string.equals("close") || string.equals("silentClose")) {
                    return null;
                }
                if (string.equals("isClosed")) {
                    return new Boolean(true);
                }
                throw new SQLException("You can't operate on a closed connection!!!");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                SQLException sQLException = SqlUtils.toSQLException(throwable);
                C3P0PooledConnection.this.ces.fireConnectionErrorOccurred(sQLException);
                throw sQLException;
            }
        }
    }
}

