/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.DriverManagerDataSource;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;

public final class DataSources {
    public static final String MAX_STATEMENTS = "c3p0.maxStatements";
    public static final String INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    public static final String MIN_POOL_SIZE = "c3p0.minPoolSize";
    public static final String MAX_POOL_SIZE = "c3p0.maxPoolSize";
    public static final String MAX_IDLE_TIME = "c3p0.maxIdleTime";
    public static final String PROPERTY_CYCLE = "c3p0.propertyCycle";
    public static final String ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    public static final String TEST_CONNECTION_ON_CHECKOUT = "c3p0.testConnectionOnCheckout";
    public static final String CONNECTION_TESTER_CLASS_NAME = "c3p0.connectionTesterClassName";
    public static final String NUM_HELPER_THREADS = "c3p0.numHelperThreads";
    public static final String FACTORY_CLASS_LOCATION = "c3p0.factoryClassLocation";
    public static final String DEFAULT_CONFIG_RSRC_PATH = "/c3p0.properties";

    public static DataSource unpooledDataSource(String string) {
        return DataSources.unpooledDataSource(string, new Properties());
    }

    public static DataSource unpooledDataSource(String string, String string2, String string3) {
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", string2);
        ((Hashtable)properties).put("password", string3);
        return DataSources.unpooledDataSource(string, properties);
    }

    public static DataSource unpooledDataSource(String string, Properties properties) {
        DriverManagerDataSource.Mutable mutable = new DriverManagerDataSource.Mutable();
        mutable.setJdbcUrl(string);
        mutable.setProperties(properties);
        return mutable.asImmutable();
    }

    public static DataSource pooledDataSource(DataSource dataSource) {
        return DataSources.pooledDataSource(dataSource, PoolConfig.DEFAULTS);
    }

    public static DataSource pooledDataSource(DataSource dataSource, PoolConfig poolConfig) {
        WrapperConnectionPoolDataSource.Mutable mutable = new WrapperConnectionPoolDataSource.Mutable();
        mutable.setNestedDataSource(dataSource);
        mutable.setMaxStatements(poolConfig.getMaxStatements());
        mutable.setInitialPoolSize(poolConfig.getInitialPoolSize());
        mutable.setMinPoolSize(poolConfig.getMinPoolSize());
        mutable.setMaxPoolSize(poolConfig.getMaxPoolSize());
        mutable.setMaxIdleTime(poolConfig.getMaxIdleTime());
        mutable.setPropertyCycle(poolConfig.getPropertyCycle());
        mutable.setAcquireIncrement(poolConfig.getAcquireIncrement());
        mutable.setConnectionTesterClassName(poolConfig.getConnectionTesterClassName());
        mutable.setTestConnectionOnCheckout(poolConfig.getTestConnectionOnCheckout());
        mutable.setFactoryClassLocation(poolConfig.getFactoryClassLocation());
        WrapperConnectionPoolDataSource.Immutable immutable = mutable.asImmutable();
        PoolBackedDataSource poolBackedDataSource = new PoolBackedDataSource();
        poolBackedDataSource.setConnectionPoolDataSource(immutable);
        poolBackedDataSource.setNumHelperThreads(poolConfig.getNumHelperThreads());
        poolBackedDataSource.setFactoryClassLocation(poolConfig.getFactoryClassLocation());
        return poolBackedDataSource.asImmutable();
    }

    public static DataSource pooledDataSource(DataSource dataSource, Properties properties) {
        return DataSources.pooledDataSource(dataSource, new PoolConfig(properties));
    }

    private DataSources() {
    }
}

